/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.entities.EntityStructureFinder;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketParticles {
    private float posX;
    private float posY;
    private float posZ;
    private Type type;
    private int[] data;

    public PacketParticles(float posX, float posY, float posZ, Type type, int ... data) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.type = type;
        this.data = data;
    }

    private PacketParticles() {
    }

    public static PacketParticles fromBytes(PacketBuffer buf) {
        PacketParticles packet = new PacketParticles();
        packet.posX = buf.readFloat();
        packet.posY = buf.readFloat();
        packet.posZ = buf.readFloat();
        packet.type = Type.values()[buf.readByte()];
        packet.data = new int[buf.readByte()];
        for (int i = 0; i < packet.data.length; ++i) {
            packet.data[i] = buf.readInt();
        }
        return packet;
    }

    public static void toBytes(PacketParticles packet, PacketBuffer buf) {
        buf.writeFloat(packet.posX);
        buf.writeFloat(packet.posY);
        buf.writeFloat(packet.posZ);
        buf.writeByte(packet.type.ordinal());
        buf.writeByte(packet.data.length);
        for (int i : packet.data) {
            buf.writeInt(i);
        }
    }

    public static void onMessage(final PacketParticles message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                if (world != null) {
                    ((PacketParticles)message).type.action.accept(message, (World)world);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Type {
        TR_GOLD_POWDER((message, world) -> {
            BlockPos pos = new BlockPos((double)((PacketParticles)message).posX, (double)((PacketParticles)message).posY, (double)((PacketParticles)message).posZ);
            Multiblocks.TREE_RITUAL.forEach(pos, 'G', (dustPos, matcher) -> {
                BlockState state = world.func_180495_p(dustPos);
                AxisAlignedBB box = state.func_196954_c((IBlockReader)world, dustPos).func_197752_a();
                NaturesAuraAPI.instance().spawnMagicParticle((double)dustPos.func_177958_n() + box.field_72340_a + (box.field_72336_d - box.field_72340_a) * (double)world.field_73012_v.nextFloat(), (float)dustPos.func_177956_o() + 0.1f, (double)dustPos.func_177952_p() + box.field_72339_c + (box.field_72334_f - box.field_72339_c) * (double)world.field_73012_v.nextFloat(), (float)world.field_73012_v.nextGaussian() * 0.02f, world.field_73012_v.nextFloat() * 0.01f + 0.02f, (float)world.field_73012_v.nextGaussian() * 0.02f, 16042818, 2.0f, 50, 0.0f, false, true);
                return true;
            });
        }),
        TR_CONSUME_ITEM((message, world) -> {
            for (int i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + 0.5f, ((PacketParticles)message).posY + 0.9f, ((PacketParticles)message).posZ + 0.5f, (float)world.field_73012_v.nextGaussian() * 0.04f, world.field_73012_v.nextFloat() * 0.04f, (float)world.field_73012_v.nextGaussian() * 0.04f, 9030711, 1.5f, 25, 0.0f, false, true);
            }
        }),
        TR_DISAPPEAR((message, world) -> {
            for (int i = world.field_73012_v.nextInt(5) + 3; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + world.field_73012_v.nextFloat(), ((PacketParticles)message).posY + world.field_73012_v.nextFloat(), ((PacketParticles)message).posZ + world.field_73012_v.nextFloat(), 0.0, 0.0, 0.0, 0x33FF33, 1.0f, 50, 0.0f, false, true);
            }
        }),
        TR_SPAWN_RESULT((message, world) -> {
            for (int i = world.field_73012_v.nextInt(10) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX, ((PacketParticles)message).posY, ((PacketParticles)message).posZ, world.field_73012_v.nextGaussian() * (double)0.1f, world.field_73012_v.nextGaussian() * (double)0.1f, world.field_73012_v.nextGaussian() * (double)0.1f, 9030711, 2.0f, 100, 0.0f, true, true);
            }
        }),
        ALTAR_CONVERSION((message, world) -> {
            int color = ((PacketParticles)message).data[0];
            for (int i = world.field_73012_v.nextInt(5) + 2; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + 0.25f + world.field_73012_v.nextFloat() * 0.5f, ((PacketParticles)message).posY + 0.9f + 0.25f * world.field_73012_v.nextFloat(), ((PacketParticles)message).posZ + 0.25f + world.field_73012_v.nextFloat() * 0.5f, world.field_73012_v.nextGaussian() * (double)0.02f, world.field_73012_v.nextFloat() * 0.02f, world.field_73012_v.nextGaussian() * (double)0.02f, color, world.field_73012_v.nextFloat() * 1.5f + 0.75f, 20, 0.0f, false, true);
            }
        }),
        POTION_GEN((message, world) -> {
            int color = ((PacketParticles)message).data[0];
            boolean releaseAura = ((PacketParticles)message).data[1] > 0;
            for (int i = world.field_73012_v.nextInt(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + world.field_73012_v.nextFloat(), ((PacketParticles)message).posY + 1.1f, ((PacketParticles)message).posZ + world.field_73012_v.nextFloat(), world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.1f, world.field_73012_v.nextGaussian() * (double)0.01f, color, 2.0f + world.field_73012_v.nextFloat(), 40, 0.0f, true, true);
                if (!releaseAura) continue;
                for (int x = -1; x <= 1; x += 2) {
                    for (int z = -1; z <= 1; z += 2) {
                        NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + (float)(x * 3) + 0.5f, (double)((PacketParticles)message).posY + 2.5, ((PacketParticles)message).posZ + (float)(z * 3) + 0.5f, world.field_73012_v.nextGaussian() * (double)0.02f, world.field_73012_v.nextFloat() * 0.04f, world.field_73012_v.nextGaussian() * (double)0.02f, 14038028, 1.0f + world.field_73012_v.nextFloat() * 2.0f, 75, 0.0f, true, true);
                    }
                }
            }
        }),
        PLANT_BOOST((message, world) -> {
            for (int i = world.field_73012_v.nextInt(20) + 15; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + world.field_73012_v.nextFloat(), ((PacketParticles)message).posY + 0.25f + world.field_73012_v.nextFloat() * 0.5f, ((PacketParticles)message).posZ + world.field_73012_v.nextFloat(), 0.0, world.field_73012_v.nextFloat() * 0.02f, 0.0, 6081584, 1.0f + world.field_73012_v.nextFloat() * 2.0f, 50, 0.0f, false, true);
            }
        }),
        FLOWER_GEN_CONSUME((message, world) -> {
            int color = ((PacketParticles)message).data[0];
            for (int i = world.field_73012_v.nextInt(10) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + 0.25f + world.field_73012_v.nextFloat() * 0.5f, ((PacketParticles)message).posY + 0.25f + world.field_73012_v.nextFloat() * 0.5f, ((PacketParticles)message).posZ + 0.25f + world.field_73012_v.nextFloat() * 0.5f, world.field_73012_v.nextGaussian() * (double)0.02f, world.field_73012_v.nextGaussian() * (double)0.02f, world.field_73012_v.nextGaussian() * (double)0.02f, color, world.field_73012_v.nextFloat() * 2.0f + 1.0f, 25, 0.0f, false, true);
            }
        }),
        FLOWER_GEN_AURA_CREATION((message, world) -> {
            for (int i = world.field_73012_v.nextInt(10) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + 0.25f + world.field_73012_v.nextFloat() * 0.5f, ((PacketParticles)message).posY + 1.01f, ((PacketParticles)message).posZ + 0.25f + world.field_73012_v.nextFloat() * 0.5f, world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.04f + 0.02f, world.field_73012_v.nextGaussian() * (double)0.01f, 6081584, 1.0f + world.field_73012_v.nextFloat() * 1.5f, 40, 0.0f, false, true);
            }
        }),
        PLACER_PLACING((message, world) -> {
            for (int i = world.field_73012_v.nextInt(20) + 20; i >= 0; --i) {
                float x;
                boolean side = world.field_73012_v.nextBoolean();
                float f = side ? world.field_73012_v.nextFloat() : (x = world.field_73012_v.nextBoolean() ? 1.1f : -0.1f);
                float z = !side ? world.field_73012_v.nextFloat() : (world.field_73012_v.nextBoolean() ? 1.1f : -0.1f);
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + x, ((PacketParticles)message).posY + 0.1f + world.field_73012_v.nextFloat() * 0.98f, ((PacketParticles)message).posZ + z, 0.0, 0.0, 0.0, 11369015, world.field_73012_v.nextFloat() + 1.0f, 50, 0.0f, true, true);
            }
        }),
        HOPPER_UPGRADE((message, world) -> {
            for (int i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX, ((PacketParticles)message).posY + 0.45f, ((PacketParticles)message).posZ, world.field_73012_v.nextGaussian() * (double)0.015f, world.field_73012_v.nextGaussian() * (double)0.015f, world.field_73012_v.nextGaussian() * (double)0.015f, 14542847, world.field_73012_v.nextFloat() + 1.0f, 30, -0.06f, true, true);
            }
        }),
        SHOCKWAVE_CREATOR((message, world) -> {
            for (int i = 0; i < 360; i += 2) {
                double rad = Math.toRadians(i);
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX, ((PacketParticles)message).posY + 0.01f, ((PacketParticles)message).posZ, (float)Math.sin(rad) * 0.65f, 0.0, (float)Math.cos(rad) * 0.65f, 9509639, 3.0f, 10, 0.0f, false, true);
            }
        }),
        OAK_GENERATOR((message, world) -> {
            int i;
            int sapX = ((PacketParticles)message).data[0];
            int sapY = ((PacketParticles)message).data[1];
            int sapZ = ((PacketParticles)message).data[2];
            boolean releaseAura = ((PacketParticles)message).data[3] > 0;
            for (i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnParticleStream((float)sapX + 0.5f + (float)world.field_73012_v.nextGaussian() * 3.0f, (float)sapY + 0.5f + world.field_73012_v.nextFloat() * 4.0f, (float)sapZ + 0.5f + (float)world.field_73012_v.nextGaussian() * 3.0f, ((PacketParticles)message).posX + 0.5f, ((PacketParticles)message).posY + 0.5f, ((PacketParticles)message).posZ + 0.5f, 0.6f, BiomeColors.func_228361_b_((ILightReader)world, (BlockPos)new BlockPos(sapX, sapY, sapZ)), 1.5f);
            }
            if (releaseAura) {
                for (i = world.field_73012_v.nextInt(10) + 10; i >= 0; --i) {
                    NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + 0.25f + world.field_73012_v.nextFloat() * 0.5f, ((PacketParticles)message).posY + 1.01f, ((PacketParticles)message).posZ + 0.25f + world.field_73012_v.nextFloat() * 0.5f, world.field_73012_v.nextGaussian() * (double)0.03f, world.field_73012_v.nextFloat() * 0.04f + 0.04f, world.field_73012_v.nextGaussian() * (double)0.03f, 6081584, 1.0f + world.field_73012_v.nextFloat() * 1.5f, 60, 0.0f, false, true);
                }
            }
        }),
        OFFERING_TABLE((message, world) -> {
            int i;
            int genX = ((PacketParticles)message).data[0];
            int genY = ((PacketParticles)message).data[1];
            int genZ = ((PacketParticles)message).data[2];
            for (i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX, ((PacketParticles)message).posY + 0.5f, ((PacketParticles)message).posZ, world.field_73012_v.nextGaussian() * (double)0.02f, world.field_73012_v.nextFloat() * 0.25f, world.field_73012_v.nextGaussian() * (double)0.02f, 0xFFADFD, 1.5f, 40, 0.0f, false, true);
            }
            for (i = world.field_73012_v.nextInt(50) + 30; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((double)((float)genX + 0.5f) + world.field_73012_v.nextGaussian() * 2.5, (float)genY + 0.1f, (double)((float)genZ + 0.5f) + world.field_73012_v.nextGaussian() * 2.5, world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.01f, world.field_73012_v.nextGaussian() * (double)0.01f, 13886719, 1.5f, 150, 0.0f, false, true);
            }
        }),
        PICKUP_STOPPER((message, world) -> NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX, ((PacketParticles)message).posY + 0.4f, ((PacketParticles)message).posZ, world.field_73012_v.nextGaussian() * (double)0.005f, world.field_73012_v.nextFloat() * 0.005f, world.field_73012_v.nextGaussian() * (double)0.005f, 13381910, 1.5f, 40, 0.0f, false, true)),
        SPAWN_LAMP((message, world) -> {
            for (int i = world.field_73012_v.nextInt(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + 0.3f + world.field_73012_v.nextFloat() * 0.4f, ((PacketParticles)message).posY + 0.15f + world.field_73012_v.nextFloat() * 0.5f, ((PacketParticles)message).posZ + 0.3f + world.field_73012_v.nextFloat() * 0.4f, 0.0, 0.0, 0.0, 16032066, 1.0f, 30, 0.0f, false, true);
            }
        }),
        ANIMAL_GEN_CREATE((message, world) -> {
            for (int i = world.field_73012_v.nextInt(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + 0.25f + world.field_73012_v.nextFloat() * 0.5f, ((PacketParticles)message).posY + 1.01f, ((PacketParticles)message).posZ + 0.25f + world.field_73012_v.nextFloat() * 0.5f, world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.04f + 0.02f, world.field_73012_v.nextGaussian() * (double)0.01f, 13710088, 1.0f + world.field_73012_v.nextFloat() * 1.5f, 40, 0.0f, false, true);
            }
        }),
        ANIMAL_GEN_CONSUME((message, world) -> {
            int i;
            boolean child = ((PacketParticles)message).data[0] > 0;
            float height = (float)((PacketParticles)message).data[1] / 10.0f;
            int genX = ((PacketParticles)message).data[2];
            int genY = ((PacketParticles)message).data[3];
            int genZ = ((PacketParticles)message).data[4];
            int n = i = child ? world.field_73012_v.nextInt(10) + 10 : world.field_73012_v.nextInt(20) + 20;
            while (i >= 0) {
                NaturesAuraAPI.instance().spawnMagicParticle((double)((PacketParticles)message).posX + world.field_73012_v.nextGaussian() * 0.25, (double)(((PacketParticles)message).posY + height * 0.75f) + world.field_73012_v.nextGaussian() * 0.25, (double)((PacketParticles)message).posZ + world.field_73012_v.nextGaussian() * 0.25, world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.01f, world.field_73012_v.nextGaussian() * (double)0.01f, 4388040, world.field_73012_v.nextFloat() * (child ? 0.5f : 2.0f) + 1.0f, world.field_73012_v.nextInt(30) + 40, 0.0f, true, true);
                --i;
            }
            NaturesAuraAPI.instance().spawnParticleStream(((PacketParticles)message).posX, ((PacketParticles)message).posY + height * 0.75f, ((PacketParticles)message).posZ, (float)genX + 0.5f, (float)genY + 0.5f, (float)genZ + 0.5f, 0.15f, 4310260, child ? 1.5f : 3.0f);
        }),
        END_FLOWER_DECAY((message, world) -> {
            int color = ((PacketParticles)message).data[0];
            for (int i = world.field_73012_v.nextInt(10) + 20; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + world.field_73012_v.nextFloat(), ((PacketParticles)message).posY + world.field_73012_v.nextFloat(), ((PacketParticles)message).posZ + world.field_73012_v.nextFloat(), world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.01f, world.field_73012_v.nextGaussian() * (double)0.01f, color, 1.5f, 80, 0.0f, true, true);
            }
        }),
        ANIMAL_SPAWNER((message, world) -> {
            for (int i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX, ((PacketParticles)message).posY + 0.5f, ((PacketParticles)message).posZ, world.field_73012_v.nextGaussian() * (double)0.02f, world.field_73012_v.nextFloat() * 0.02f, world.field_73012_v.nextGaussian() * (double)0.02f, 1488818, 1.5f, 40, 0.0f, false, true);
            }
        }),
        RF_CONVERTER((message, world) -> {
            for (int i = world.field_73012_v.nextInt(5) + 2; i >= 0; --i) {
                Multiblocks.RF_CONVERTER.forEach(new BlockPos((double)((PacketParticles)message).posX, (double)((PacketParticles)message).posY, (double)((PacketParticles)message).posZ), 'R', (blockPos, matcher) -> {
                    if (world.field_73012_v.nextFloat() < 0.35f) {
                        NaturesAuraAPI.instance().spawnParticleStream((float)blockPos.func_177958_n() + world.field_73012_v.nextFloat(), (float)blockPos.func_177956_o() + world.field_73012_v.nextFloat(), (float)blockPos.func_177952_p() + world.field_73012_v.nextFloat(), ((PacketParticles)message).posX + world.field_73012_v.nextFloat(), ((PacketParticles)message).posY + world.field_73012_v.nextFloat(), ((PacketParticles)message).posZ + world.field_73012_v.nextFloat(), 0.05f, 16718341, 1.5f);
                    }
                    return true;
                });
            }
        }),
        END_FLOWER_CONSUME((message, world) -> {
            int color = ((PacketParticles)message).data[0];
            for (int i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX, ((PacketParticles)message).posY + 0.5f, ((PacketParticles)message).posZ, world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.01f, world.field_73012_v.nextGaussian() * (double)0.01f, color, 1.5f, 40, 0.0f, false, true);
            }
        }),
        MOVER_CART((message, world) -> {
            float motionX = (float)((PacketParticles)message).data[0] / 100.0f;
            float motionY = (float)((PacketParticles)message).data[1] / 100.0f;
            float motionZ = (float)((PacketParticles)message).data[2] / 100.0f;
            for (int i = world.field_73012_v.nextInt(60) + 30; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((double)((PacketParticles)message).posX + world.field_73012_v.nextGaussian() * 10.0, (double)((PacketParticles)message).posY + world.field_73012_v.nextGaussian() * 10.0, (double)((PacketParticles)message).posZ + world.field_73012_v.nextGaussian() * 10.0, motionX * 0.2f, motionY * 0.2f, motionZ * 0.2f, IAuraType.forWorld((IWorld)world).getColor(), 2.0f, 30, 0.0f, false, true);
            }
        }),
        MOSS_GENERATOR((message, world) -> {
            int i;
            for (i = world.field_73012_v.nextInt(30) + 30; i >= 0; --i) {
                float y;
                float x;
                int side = world.field_73012_v.nextInt(3);
                float f = side != 0 ? world.field_73012_v.nextFloat() : (x = world.field_73012_v.nextBoolean() ? 1.1f : -0.1f);
                float f2 = side != 1 ? world.field_73012_v.nextFloat() : (y = world.field_73012_v.nextBoolean() ? 1.1f : -0.1f);
                float z = side != 2 ? world.field_73012_v.nextFloat() : (world.field_73012_v.nextBoolean() ? 1.1f : -0.1f);
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + x, ((PacketParticles)message).posY + y, ((PacketParticles)message).posZ + z, 0.0, 0.0, 0.0, 1592333, world.field_73012_v.nextFloat() + 1.0f, 30, 0.0f, true, true);
            }
            for (i = world.field_73012_v.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + world.field_73012_v.nextFloat(), ((PacketParticles)message).posY + 1.0f, ((PacketParticles)message).posZ + world.field_73012_v.nextFloat(), world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.04f + 0.02f, world.field_73012_v.nextGaussian() * (double)0.01f, 6081584, 1.0f + world.field_73012_v.nextFloat() * 1.5f, 40, 0.0f, true, true);
            }
        }),
        FIREWORK_GEN((message, world) -> {
            int goalX = ((PacketParticles)message).data[0];
            int goalY = ((PacketParticles)message).data[1];
            int goalZ = ((PacketParticles)message).data[2];
            NaturesAuraAPI.instance().setParticleSpawnRange(64);
            for (int i = world.field_73012_v.nextInt(30) + 30; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnParticleStream(((PacketParticles)message).posX + (float)world.field_73012_v.nextGaussian(), ((PacketParticles)message).posY + (float)world.field_73012_v.nextGaussian(), ((PacketParticles)message).posZ + (float)world.field_73012_v.nextGaussian(), (float)goalX + 0.25f + world.field_73012_v.nextFloat() * 0.5f, (float)goalY + 0.25f + world.field_73012_v.nextFloat() * 0.5f, (float)goalZ + 0.25f + world.field_73012_v.nextFloat() * 0.5f, 0.65f, ((PacketParticles)message).data[3 + world.field_73012_v.nextInt(((PacketParticles)message).data.length - 3)], 1.0f);
            }
            NaturesAuraAPI.instance().setParticleSpawnRange(32);
        }),
        DIMENSION_RAIL((message, world) -> {
            float width = (float)((PacketParticles)message).data[0] / 100.0f;
            float height = (float)((PacketParticles)message).data[1] / 100.0f;
            float depth = (float)((PacketParticles)message).data[2] / 100.0f;
            for (int i = world.field_73012_v.nextInt(100) + 50; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + world.field_73012_v.nextFloat() * width, ((PacketParticles)message).posY + world.field_73012_v.nextFloat() * height, ((PacketParticles)message).posZ + world.field_73012_v.nextFloat() * depth, 0.0, 0.0, 0.0, 14028031, 1.0f + world.field_73012_v.nextFloat(), 60, 0.0f, false, true);
            }
        }),
        PROJECTILE_GEN((message, world) -> {
            int i;
            int x = ((PacketParticles)message).data[0];
            int y = ((PacketParticles)message).data[1];
            int z = ((PacketParticles)message).data[2];
            for (i = world.field_73012_v.nextInt(10) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((float)x + 0.25f + world.field_73012_v.nextFloat() * 0.5f, (float)y + 1.01f, (float)z + 0.25f + world.field_73012_v.nextFloat() * 0.5f, world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.04f + 0.02f, world.field_73012_v.nextGaussian() * (double)0.01f, 6081584, 1.0f + world.field_73012_v.nextFloat() * 1.5f, 40, 0.0f, false, true);
            }
            for (i = world.field_73012_v.nextInt(10) + 10; i >= 0; --i) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197629_v, (double)((PacketParticles)message).posX, (double)((PacketParticles)message).posY, (double)((PacketParticles)message).posZ, world.field_73012_v.nextGaussian() * (double)0.03f, world.field_73012_v.nextGaussian() * (double)0.03f, world.field_73012_v.nextGaussian() * (double)0.03f);
            }
        }),
        BLAST_FURNACE_BOOSTER((message, world) -> {
            boolean worked = ((PacketParticles)message).data[0] > 0;
            for (int i = world.field_73012_v.nextInt(10) + 5; i >= 0; --i) {
                world.func_195594_a((IParticleData)ParticleTypes.field_218417_ae, (double)(((PacketParticles)message).posX + 0.3125f + (float)world.field_73012_v.nextInt(6) / 16.0f), (double)(((PacketParticles)message).posY + 0.6f), (double)(((PacketParticles)message).posZ + 0.3125f + (float)world.field_73012_v.nextInt(6) / 16.0f), world.field_73012_v.nextGaussian() * (double)0.005f, (double)(world.field_73012_v.nextFloat() * 0.02f + 0.01f), world.field_73012_v.nextGaussian() * (double)0.005f);
            }
            if (worked) {
                BlockPos pos = new BlockPos((double)((PacketParticles)message).posX, (double)((PacketParticles)message).posY, (double)((PacketParticles)message).posZ);
                int color = IAuraChunk.getAuraChunk((IWorld)world, pos).getType().getColor();
                for (int i = world.field_73012_v.nextInt(10) + 10; i >= 0; --i) {
                    NaturesAuraAPI.instance().spawnParticleStream(((PacketParticles)message).posX + (float)world.field_73012_v.nextGaussian() * 5.0f, ((PacketParticles)message).posY + world.field_73012_v.nextFloat() * 5.0f, ((PacketParticles)message).posZ + (float)world.field_73012_v.nextGaussian() * 5.0f, ((PacketParticles)message).posX + 0.5f, ((PacketParticles)message).posY + 0.5f, ((PacketParticles)message).posZ + 0.5f, 0.25f, color, 0.5f + world.field_73012_v.nextFloat());
                }
            }
        }),
        ANIMAL_CONTAINER((message, world) -> {
            for (int i = world.field_73012_v.nextInt(2) + 1; i > 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((double)((PacketParticles)message).posX + world.field_73012_v.nextGaussian() * (double)0.15f, ((PacketParticles)message).posY - world.field_73012_v.nextFloat() * 0.5f, (double)((PacketParticles)message).posZ + world.field_73012_v.nextGaussian() * (double)0.15f, 0.0, 0.0, 0.0, 4385269, 1.0f + world.field_73012_v.nextFloat() * 2.0f, 40, 0.0f, false, true);
            }
        }),
        SNOW_CREATOR((message, world) -> {
            BlockPos pos = new BlockPos((double)((PacketParticles)message).posX, (double)((PacketParticles)message).posY, (double)((PacketParticles)message).posZ);
            int color = IAuraChunk.getAuraChunk((IWorld)world, pos).getType().getColor();
            for (int i = world.field_73012_v.nextInt(3) + 1; i > 0; --i) {
                NaturesAuraAPI.instance().spawnParticleStream(((PacketParticles)message).posX + (float)world.field_73012_v.nextGaussian() * 5.0f, ((PacketParticles)message).posY + world.field_73012_v.nextFloat() * 5.0f, ((PacketParticles)message).posZ + (float)world.field_73012_v.nextGaussian() * 5.0f, ((PacketParticles)message).posX + 0.5f, ((PacketParticles)message).posY + 0.5f, ((PacketParticles)message).posZ + 0.5f, 0.25f, color, 0.5f + world.field_73012_v.nextFloat());
            }
        }),
        CHORUS_GENERATOR((message, world) -> {
            int i;
            int chorusX = ((PacketParticles)message).data[0];
            int chorusY = ((PacketParticles)message).data[1];
            int chorusZ = ((PacketParticles)message).data[2];
            for (i = world.field_73012_v.nextInt(5) + 3; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((float)chorusX + world.field_73012_v.nextFloat(), (float)chorusY + world.field_73012_v.nextFloat(), (float)chorusZ + world.field_73012_v.nextFloat(), 0.0, 0.0, 0.0, 12258275, 1.0f + world.field_73012_v.nextFloat(), 50, 0.0f, false, true);
            }
            for (i = world.field_73012_v.nextInt(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + 0.25f + world.field_73012_v.nextFloat() * 0.5f, ((PacketParticles)message).posY + 1.01f, ((PacketParticles)message).posZ + 0.25f + world.field_73012_v.nextFloat() * 0.5f, world.field_73012_v.nextGaussian() * (double)0.01f, world.field_73012_v.nextFloat() * 0.04f + 0.02f, world.field_73012_v.nextGaussian() * (double)0.01f, IAuraType.forWorld((IWorld)world).getColor(), 1.0f + world.field_73012_v.nextFloat() * 1.5f, 40, 0.0f, false, true);
            }
        }),
        TIMER_RESET((message, world) -> {
            int color = ((PacketParticles)message).data[0];
            for (int i = world.field_73012_v.nextInt(10) + 15; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(((PacketParticles)message).posX + 0.3125f + world.field_73012_v.nextFloat() * 6.0f / 16.0f, ((PacketParticles)message).posY + 0.125f + world.field_73012_v.nextFloat() * 8.0f / 16.0f, ((PacketParticles)message).posZ + 0.3125f + world.field_73012_v.nextFloat() * 6.0f / 16.0f, 0.0, 0.0, 0.0, color, 2.0f, 40 + world.field_73012_v.nextInt(20), 0.0f, false, true);
            }
        }),
        STRUCTURE_FINDER((message, world) -> {
            EntityStructureFinder entity = (EntityStructureFinder)world.func_73045_a(((PacketParticles)message).data[0]);
            WorldRenderer renderer = Minecraft.func_71410_x().field_71438_f;
            double d0 = (double)((PacketParticles)message).posX + 0.5;
            double d13 = ((PacketParticles)message).posY;
            double d18 = (double)((PacketParticles)message).posZ + 0.5;
            for (int j2 = 0; j2 < 8; ++j2) {
                renderer.func_195461_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, entity.func_184543_l()), false, d0, d13, d18, world.field_73012_v.nextGaussian() * 0.15, world.field_73012_v.nextDouble() * 0.2, world.field_73012_v.nextGaussian() * 0.15);
            }
            int color = (Integer)entity.func_184212_Q().func_187225_a(EntityStructureFinder.COLOR);
            for (double d24 = 0.0; d24 < Math.PI * 2; d24 += 0.15707963267948966) {
                NaturesAuraAPI.instance().spawnMagicParticle(d0 + Math.cos(d24) * 5.0, d13 - 0.4, d18 + Math.sin(d24) * 5.0, Math.cos(d24) * -2.0, 0.0, Math.sin(d24) * -2.0, color, 2.0f, 60, 0.0f, false, true);
                NaturesAuraAPI.instance().spawnMagicParticle(d0 + Math.cos(d24) * 5.0, d13 - 0.4, d18 + Math.sin(d24) * 5.0, Math.cos(d24) * -2.5, 0.0, Math.sin(d24) * -2.5, color, 2.0f, 60, 0.0f, false, true);
            }
        });

        public final BiConsumer<PacketParticles, World> action;

        private Type(BiConsumer<PacketParticles, World> action) {
            this.action = action;
        }
    }
}

