/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util.text;

import java.util.ArrayList;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.IHasTranslationKey;
import mekanism.common.MekanismLang;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class TextComponentUtil {
    public static ITextComponent build(Object ... components) {
        ITextComponent result = null;
        TextFormatting cachedFormat = null;
        for (Object component : components) {
            if (component == null) continue;
            Object current = null;
            if (component instanceof IHasTextComponent) {
                current = ((IHasTextComponent)component).getTextComponent();
            } else if (component instanceof IHasTranslationKey) {
                current = TextComponentUtil.translate(((IHasTranslationKey)component).getTranslationKey(), new Object[0]);
            } else if (component instanceof EnumColor) {
                cachedFormat = ((EnumColor)((Object)component)).textFormatting;
            } else if (component instanceof ITextComponent) {
                current = (ITextComponent)component;
            } else if (component instanceof TextFormatting) {
                cachedFormat = (TextFormatting)component;
            } else {
                current = component instanceof Block ? TextComponentUtil.translate(((Block)component).func_149739_a(), new Object[0]) : (component instanceof Item ? TextComponentUtil.translate(((Item)component).func_77658_a(), new Object[0]) : (component instanceof ItemStack ? ((ItemStack)component).func_200301_q() : (component instanceof FluidStack ? TextComponentUtil.translate(((FluidStack)component).getTranslationKey(), new Object[0]) : (component instanceof Fluid ? TextComponentUtil.translate(((Fluid)component).getAttributes().getTranslationKey(), new Object[0]) : (component instanceof Direction ? TextComponentUtil.getTranslatedDirection((Direction)component) : (component instanceof String || component instanceof Boolean || component instanceof Number ? TextComponentUtil.getString(component.toString()) : MekanismLang.GENERIC.translate(component)))))));
            }
            if (current == null) continue;
            if (cachedFormat != null) {
                current.func_211708_a(cachedFormat);
                cachedFormat = null;
            }
            if (result == null) {
                result = current;
                continue;
            }
            result.func_150257_a(current);
        }
        return result;
    }

    private static ITextComponent getTranslatedDirection(Direction direction) {
        switch (direction) {
            case DOWN: {
                return MekanismLang.DOWN.translate(new Object[0]);
            }
            case UP: {
                return MekanismLang.UP.translate(new Object[0]);
            }
            case NORTH: {
                return MekanismLang.NORTH.translate(new Object[0]);
            }
            case SOUTH: {
                return MekanismLang.SOUTH.translate(new Object[0]);
            }
            case WEST: {
                return MekanismLang.WEST.translate(new Object[0]);
            }
            case EAST: {
                return MekanismLang.EAST.translate(new Object[0]);
            }
        }
        return TextComponentUtil.getString(direction.toString());
    }

    public static StringTextComponent getString(String component) {
        return new StringTextComponent(component);
    }

    public static TranslationTextComponent translate(String key, Object ... args) {
        return new TranslationTextComponent(key, args);
    }

    public static TranslationTextComponent smartTranslate(String key, Object ... components) {
        if (components.length == 0) {
            return TextComponentUtil.translate(key, new Object[0]);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        TextFormatting cachedFormat = null;
        for (Object component : components) {
            if (component == null) {
                args.add(null);
                cachedFormat = null;
                continue;
            }
            Object current = null;
            if (component instanceof IHasTextComponent) {
                current = ((IHasTextComponent)component).getTextComponent();
            } else if (component instanceof IHasTranslationKey) {
                current = TextComponentUtil.translate(((IHasTranslationKey)component).getTranslationKey(), new Object[0]);
            } else if (component instanceof Block) {
                current = TextComponentUtil.translate(((Block)component).func_149739_a(), new Object[0]);
            } else if (component instanceof Item) {
                current = TextComponentUtil.translate(((Item)component).func_77658_a(), new Object[0]);
            } else if (component instanceof ItemStack) {
                current = ((ItemStack)component).func_200301_q();
            } else if (component instanceof FluidStack) {
                current = TextComponentUtil.translate(((FluidStack)component).getTranslationKey(), new Object[0]);
            } else if (component instanceof Fluid) {
                current = TextComponentUtil.translate(((Fluid)component).getAttributes().getTranslationKey(), new Object[0]);
            } else if (component instanceof Direction) {
                current = TextComponentUtil.getTranslatedDirection((Direction)component);
            } else if (cachedFormat != null) {
                current = component instanceof ITextComponent ? (ITextComponent)component : (component instanceof String || component instanceof Boolean || component instanceof Number ? TextComponentUtil.getString(component.toString()) : (component instanceof EnumColor ? ((EnumColor)((Object)component)).getName() : MekanismLang.GENERIC.translate(component)));
            } else {
                if (component instanceof EnumColor) {
                    cachedFormat = ((EnumColor)((Object)component)).textFormatting;
                    continue;
                }
                if (component instanceof TextFormatting) {
                    cachedFormat = (TextFormatting)component;
                    continue;
                }
            }
            if (cachedFormat != null) {
                if (current == null) {
                    args.add(component);
                } else {
                    args.add(current.func_211708_a(cachedFormat));
                }
                cachedFormat = null;
                continue;
            }
            if (current == null) {
                args.add(component);
                continue;
            }
            args.add(current);
        }
        if (cachedFormat != null) {
            Object lastComponent = components[components.length - 1];
            if (lastComponent instanceof EnumColor) {
                args.add(((EnumColor)((Object)lastComponent)).getName());
            } else {
                args.add(lastComponent);
            }
        }
        return TextComponentUtil.translate(key, args.toArray());
    }
}

