/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import javax.annotation.Nonnull;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.util.InventoryUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.items.ItemHandlerHelper;

public class TItemStackFilter
extends TransporterFilter<TItemStackFilter>
implements IItemStackFilter<TItemStackFilter> {
    public boolean sizeMode;
    public boolean fuzzyMode;
    public int min;
    public int max;
    private ItemStack itemType = ItemStack.field_190927_a;

    @Override
    public boolean canFilter(ItemStack itemStack, boolean strict) {
        return super.canFilter(itemStack, strict) && (!strict || !this.sizeMode || this.max != 0 && itemStack.func_190916_E() >= this.min) && (this.fuzzyMode ? ItemStack.func_179545_c((ItemStack)this.itemType, (ItemStack)itemStack) : ItemHandlerHelper.canItemStacksStack((ItemStack)this.itemType, (ItemStack)itemStack));
    }

    @Override
    public InvStack getStackFromInventory(TileEntity tile, Direction side, boolean singleItem) {
        if (this.sizeMode && !singleItem) {
            return InventoryUtils.takeDefinedItem(tile, side, this.itemType, this.min, this.max);
        }
        return super.getStackFromInventory(tile, side, singleItem);
    }

    @Override
    public Finder getFinder() {
        return new Finder.ItemStackFinder(this.itemType);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74757_a("sizeMode", this.sizeMode);
        nbtTags.func_74757_a("fuzzyMode", this.fuzzyMode);
        nbtTags.func_74768_a("min", this.min);
        nbtTags.func_74768_a("max", this.max);
        this.itemType.func_77955_b(nbtTags);
        return nbtTags;
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        super.read(nbtTags);
        this.sizeMode = nbtTags.func_74767_n("sizeMode");
        this.fuzzyMode = nbtTags.func_74767_n("fuzzyMode");
        this.min = nbtTags.func_74762_e("min");
        this.max = nbtTags.func_74762_e("max");
        this.itemType = ItemStack.func_199557_a((CompoundNBT)nbtTags);
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.sizeMode);
        buffer.writeBoolean(this.fuzzyMode);
        buffer.func_150787_b(this.min);
        buffer.func_150787_b(this.max);
        buffer.func_150788_a(this.itemType);
    }

    @Override
    public void read(PacketBuffer dataStream) {
        super.read(dataStream);
        this.sizeMode = dataStream.readBoolean();
        this.fuzzyMode = dataStream.readBoolean();
        this.min = dataStream.func_150792_a();
        this.max = dataStream.func_150792_a();
        this.itemType = dataStream.func_150791_c();
    }

    @Override
    public int hashCode() {
        int code = 1;
        code = 31 * code + super.hashCode();
        code = 31 * code + this.itemType.hashCode();
        code = 31 * code + (this.sizeMode ? 1 : 0);
        code = 31 * code + (this.fuzzyMode ? 1 : 0);
        code = 31 * code + this.min;
        code = 31 * code + this.max;
        return code;
    }

    @Override
    public boolean equals(Object filter) {
        return super.equals(filter) && filter instanceof TItemStackFilter && ((TItemStackFilter)filter).itemType.func_77969_a(this.itemType) && ((TItemStackFilter)filter).sizeMode == this.sizeMode && ((TItemStackFilter)filter).fuzzyMode == this.fuzzyMode && ((TItemStackFilter)filter).min == this.min && ((TItemStackFilter)filter).max == this.max;
    }

    @Override
    public TItemStackFilter clone() {
        TItemStackFilter filter = new TItemStackFilter();
        filter.allowDefault = this.allowDefault;
        filter.color = this.color;
        filter.itemType = this.itemType.func_77946_l();
        filter.sizeMode = this.sizeMode;
        filter.fuzzyMode = this.fuzzyMode;
        filter.min = this.min;
        filter.max = this.max;
        return filter;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.SORTER_ITEMSTACK_FILTER;
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return this.itemType;
    }

    @Override
    public void setItemStack(@Nonnull ItemStack stack) {
        this.itemType = stack;
    }
}

