/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import mekanism.api.providers.IBlockProvider;
import mekanism.api.providers.IItemProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.EnumUtils;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.util.ResourceLocation;

public class CatalystRegistryHelper {
    public static void register(IRecipeCatalystRegistration registry, IBlockProvider mekanismBlock) {
        CatalystRegistryHelper.registerRecipeItem(registry, mekanismBlock, mekanismBlock.getRegistryName());
    }

    public static void registerCondensentrator(IRecipeCatalystRegistration registry) {
        ResourceLocation condensentrating = new ResourceLocation("mekanism", "rotary_condensentrator_condensentrating");
        ResourceLocation decondensentrating = new ResourceLocation("mekanism", "rotary_condensentrator_decondensentrating");
        registry.addRecipeCatalyst((Object)MekanismBlocks.ROTARY_CONDENSENTRATOR.getItemStack(), new ResourceLocation[]{condensentrating, decondensentrating});
    }

    public static void registerSmelter(IRecipeCatalystRegistration registry) {
        CatalystRegistryHelper.register(registry, MekanismBlocks.ENERGIZED_SMELTER);
        CatalystRegistryHelper.registerRecipeItem(registry, MekanismBlocks.ENERGIZED_SMELTER, VanillaRecipeCategoryUid.FURNACE);
    }

    public static void registerRecipeItem(IRecipeCatalystRegistration registry, IBlockProvider mekanismBlock, ResourceLocation category) {
        registry.addRecipeCatalyst((Object)mekanismBlock.getItemStack(), new ResourceLocation[]{category});
        Attribute.ifHas(mekanismBlock.getBlock(), AttributeFactoryType.class, attr -> {
            for (FactoryTier tier : EnumUtils.FACTORY_TIERS) {
                registry.addRecipeCatalyst((Object)MekanismBlocks.getFactory(tier, attr.getFactoryType()).getItemStack(), new ResourceLocation[]{category});
            }
        });
    }

    public static void registerRecipeItem(IRecipeCatalystRegistration registry, IItemProvider mekanismItem, ResourceLocation category) {
        registry.addRecipeCatalyst((Object)mekanismItem.getItemStack(), new ResourceLocation[]{category});
    }
}

