/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Map;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MovableFilterButton;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.TagCache;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiFilterHolder<FILTER extends IFilter<?>, TILE extends TileEntityMekanism, CONTAINER extends EmptyTileContainer<TILE>>
extends GuiMekanismTile<TILE, CONTAINER> {
    private static final int FILTER_COUNT = 4;
    private Map<ITagFilter<?>, StackData> oreDictStacks = new Object2ObjectOpenHashMap();
    private Map<IModIDFilter<?>, StackData> modIDStacks = new Object2ObjectOpenHashMap();
    private GuiScrollBar scrollBar;
    private int stackSwitch;

    public GuiFilterHolder(CONTAINER container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiInnerScreen(this, 9, 17, 46, 140));
        this.addButton(new GuiElementHolder(this, 55, 17, 98, 118));
        this.addButton(new GuiElementHolder(this, 55, 135, 98, 22));
        this.scrollBar = new GuiScrollBar((IGuiWrapper)this, 153, 17, 140, () -> this.getFilters().size(), () -> 4);
        this.addButton(this.scrollBar);
        for (int i = 0; i < 4; ++i) {
            this.addButton(new MovableFilterButton((IGuiWrapper)this, 56, 18 + i * 29, i, this.scrollBar::getCurrentSelection, this::getFilters, index -> {
                if (index > 0) {
                    Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.MOVE_FILTER_UP, this.tile, index));
                }
            }, index -> {
                if (index < this.getFilters().size() - 1) {
                    Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.MOVE_FILTER_DOWN, this.tile, index));
                }
            }, this::onClick));
        }
    }

    protected HashList<FILTER> getFilters() {
        return ((ITileFilterHolder)((Object)this.tile)).getFilters();
    }

    protected abstract void onClick(IFilter<?> var1, int var2);

    public void tick() {
        super.tick();
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0) {
            for (Map.Entry<ITagFilter<?>, StackData> entry : this.oreDictStacks.entrySet()) {
                this.setNextRenderStack(entry.getValue());
            }
            for (Map.Entry<IFilter<?>, StackData> entry : this.modIDStacks.entrySet()) {
                this.setNextRenderStack(entry.getValue());
            }
            this.stackSwitch = 20;
        } else {
            StackData data;
            for (Map.Entry<ITagFilter<?>, StackData> entry : this.oreDictStacks.entrySet()) {
                data = entry.getValue();
                if (data.iterStacks == null || !data.iterStacks.isEmpty()) continue;
                data.renderStack = ItemStack.field_190927_a;
            }
            for (Map.Entry<IFilter<?>, StackData> entry : this.modIDStacks.entrySet()) {
                data = entry.getValue();
                if (data.iterStacks == null || !data.iterStacks.isEmpty()) continue;
                data.renderStack = ItemStack.field_190927_a;
            }
        }
        ObjectOpenHashSet oreDictFilters = new ObjectOpenHashSet();
        ObjectOpenHashSet objectOpenHashSet = new ObjectOpenHashSet();
        HashList<FILTER> filters = this.getFilters();
        for (int i = 0; i < 4; ++i) {
            IFilter filter = (IFilter)filters.getOrNull(this.scrollBar.getCurrentSelection() + i);
            if (filter instanceof ITagFilter) {
                oreDictFilters.add((ITagFilter)filter);
                continue;
            }
            if (!(filter instanceof IModIDFilter)) continue;
            objectOpenHashSet.add((IModIDFilter)filter);
        }
        for (IFilter filter : filters) {
            if (filter instanceof ITagFilter && !oreDictFilters.contains(filter)) {
                this.oreDictStacks.remove(filter);
                continue;
            }
            if (!(filter instanceof IModIDFilter) || objectOpenHashSet.contains(filter)) continue;
            this.modIDStacks.remove(filter);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        HashList<FILTER> filters = this.getFilters();
        for (int i = 0; i < 4; ++i) {
            IFilter filter = (IFilter)filters.getOrNull(this.scrollBar.getCurrentSelection() + i);
            if (filter == null) continue;
            int yStart = i * 29 + 18;
            if (filter instanceof IItemStackFilter) {
                this.renderItem(((IItemStackFilter)filter).getItemStack(), 59, yStart + 3);
                continue;
            }
            if (filter instanceof ITagFilter) {
                ITagFilter oreFilter = (ITagFilter)filter;
                if (!this.oreDictStacks.containsKey(oreFilter)) {
                    this.updateStackList(oreFilter);
                }
                this.renderItem(this.oreDictStacks.get((Object)filter).renderStack, 59, yStart + 3);
                continue;
            }
            if (filter instanceof IMaterialFilter) {
                this.renderItem(((IMaterialFilter)filter).getMaterialItem(), 59, yStart + 3);
                continue;
            }
            if (!(filter instanceof IModIDFilter)) continue;
            IModIDFilter modFilter = (IModIDFilter)filter;
            if (!this.modIDStacks.containsKey(modFilter)) {
                this.updateStackList(modFilter);
            }
            this.renderItem(this.modIDStacks.get((Object)filter).renderStack, 59, yStart + 3);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        return this.scrollBar.adjustScroll(delta) || super.mouseScrolled(mouseX, mouseY, delta);
    }

    private void updateStackList(ITagFilter<?> filter) {
        if (!this.oreDictStacks.containsKey(filter)) {
            this.oreDictStacks.put(filter, new StackData());
        }
        this.oreDictStacks.get(filter).iterStacks = this.getTagStacks(filter.getTagName());
        this.stackSwitch = 0;
        this.tick();
        this.oreDictStacks.get(filter).stackIndex = -1;
    }

    protected abstract List<ItemStack> getTagStacks(String var1);

    private void updateStackList(IModIDFilter<?> filter) {
        if (!this.modIDStacks.containsKey(filter)) {
            this.modIDStacks.put(filter, new StackData());
        }
        this.modIDStacks.get(filter).iterStacks = TagCache.getModIDStacks(filter.getModID(), false);
        this.stackSwitch = 0;
        this.tick();
        this.modIDStacks.get(filter).stackIndex = -1;
    }

    private void setNextRenderStack(StackData data) {
        if (data.iterStacks != null && !data.iterStacks.isEmpty()) {
            if (data.stackIndex == -1 || data.stackIndex == data.iterStacks.size() - 1) {
                data.stackIndex = 0;
            } else if (data.stackIndex < data.iterStacks.size() - 1) {
                ++data.stackIndex;
            }
            data.renderStack = data.iterStacks.get(data.stackIndex);
        }
    }

    private boolean needsScrollBars() {
        return this.getFilters().size() > 4;
    }

    public static class StackData {
        public List<ItemStack> iterStacks;
        public int stackIndex;
        public ItemStack renderStack = ItemStack.field_190927_a;
    }
}

