/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.tag;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ForgeRegistryTagProvider<TYPE extends IForgeRegistryEntry<TYPE>>
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator gen;
    private final Map<Tag<TYPE>, Tag.Builder<TYPE>> tagToBuilder = new Object2ObjectLinkedOpenHashMap();
    private final IForgeRegistry<TYPE> registry;
    protected final String modid;

    protected ForgeRegistryTagProvider(DataGenerator gen, String modid, IForgeRegistry<TYPE> registry) {
        this.gen = gen;
        this.modid = modid;
        this.registry = registry;
    }

    protected abstract void registerTags();

    public void func_200398_a(@Nonnull DirectoryCache cache) {
        this.tagToBuilder.clear();
        this.registerTags();
        TagCollection tagCollection = new TagCollection(id -> Optional.empty(), "", false, "generated");
        tagCollection.func_219779_a(this.tagToBuilder.entrySet().stream().collect(Collectors.toMap(tag -> ((Tag)tag.getKey()).func_199886_b(), Map.Entry::getValue)));
        tagCollection.func_200039_c().forEach((id, tag) -> {
            Path path = this.makePath((ResourceLocation)id);
            try {
                String json = GSON.toJson((JsonElement)tag.func_200571_a(arg_0 -> this.registry.getKey(arg_0)));
                String hash = field_208307_a.hashUnencodedChars((CharSequence)json).toString();
                if (!Objects.equals(cache.func_208323_a(path), hash) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(json);
                    }
                }
                cache.func_208316_a(path, hash);
            }
            catch (IOException exception) {
                LOGGER.error("Couldn't save tags to {}", (Object)path, (Object)exception);
            }
        });
        this.setCollection(tagCollection);
    }

    protected Tag.Builder<TYPE> getBuilder(Tag<TYPE> tag) {
        return this.tagToBuilder.computeIfAbsent(tag, ignored -> Tag.Builder.func_200047_a());
    }

    protected abstract void setCollection(TagCollection<TYPE> var1);

    @Nonnull
    protected abstract Path makePath(ResourceLocation var1);
}

