/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.util.helpers.BlockHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.energy.CapabilityEnergy;

public class EnergyHelper {
    private EnergyHelper() {
    }

    public static boolean validFurnaceFuel(ItemStack input) {
        return EnergyHelper.getEnergyFurnaceFuel(input) > 0;
    }

    public static int getEnergyFurnaceFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack) * 10;
    }

    public static boolean hasEnergyHandlerCap(ItemStack item) {
        return !item.func_190926_b() && item.getCapability(CapabilityEnergy.ENERGY).isPresent();
    }

    public static void insertIntoAdjacent(TileEntity tile, int amount, Direction side) {
        TileEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        Direction opposite = side.func_176734_d();
        if (adjTile != null) {
            adjTile.getCapability(CapabilityEnergy.ENERGY, opposite).ifPresent(e -> e.receiveEnergy(amount, false));
        }
    }

    public static ItemStack setDefaultEnergyTag(ItemStack container, int energy) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new CompoundNBT());
        }
        container.func_77978_p().func_74768_a("Energy", energy);
        return container;
    }
}

