/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.capability.CapabilityAOE;
import cofh.lib.util.RayTracer;
import cofh.lib.util.references.EnsorcellationReferences;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class AOEHelper {
    private AOEHelper() {
    }

    public static boolean validAOEItem(ItemStack stack) {
        return stack.getCapability(CapabilityAOE.AOE_ITEM_CAPABILITY).isPresent() || stack.func_77973_b() instanceof ToolItem || stack.func_77973_b() instanceof HoeItem;
    }

    public static boolean validAOEMiningItem(ItemStack stack) {
        return stack.getCapability(CapabilityAOE.AOE_ITEM_CAPABILITY).isPresent() || stack.func_77973_b() instanceof ToolItem;
    }

    public static ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, BlockPos pos, PlayerEntity player) {
        int encExcavating = EnchantmentHelper.func_77506_a((Enchantment)EnsorcellationReferences.EXCAVATING, (ItemStack)stack);
        if (encExcavating > 0) {
            return AOEHelper.getAOEBlocksMiningRadius(stack, pos, player, encExcavating);
        }
        int encTilling = EnchantmentHelper.func_77506_a((Enchantment)EnsorcellationReferences.TILLING, (ItemStack)stack);
        if (encTilling > 0) {
            return AOEHelper.getAOEBlocksHoeRadius(stack, pos, player, encTilling);
        }
        int encFurrowing = EnchantmentHelper.func_77506_a((Enchantment)EnsorcellationReferences.FURROWING, (ItemStack)stack);
        if (encFurrowing > 0) {
            return AOEHelper.getAOEBlocksHoeLine(stack, pos, player, encFurrowing * 2);
        }
        return ImmutableList.of();
    }

    public static ImmutableList<BlockPos> getAOEBlocksMiningRadius(ItemStack stack, BlockPos pos, PlayerEntity player, int radius) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        World world = player.func_130014_f_();
        Item tool = stack.func_77973_b();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockRayTraceResult traceResult = RayTracer.retrace(player, RayTraceContext.FluidMode.NONE);
        if (traceResult.func_216346_c() == RayTraceResult.Type.MISS || player.func_225608_bj_() || !AOEHelper.canToolAffect(tool, stack, world, pos) || radius <= 0) {
            return ImmutableList.of();
        }
        switch (traceResult.func_216354_b()) {
            case DOWN: 
            case UP: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos query;
                        if (i == x && k == z || !AOEHelper.canToolAffect(tool, stack, world, query = new BlockPos(i, y, k))) continue;
                        area.add(query);
                    }
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                int posY = y;
                y += radius - 1;
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        BlockPos query;
                        if (i == x && j == posY || !AOEHelper.canToolAffect(tool, stack, world, query = new BlockPos(i, j, z))) continue;
                        area.add(query);
                    }
                }
                break;
            }
            default: {
                int posY = y;
                for (int j = (y += radius - 1) - radius; j <= y + radius; ++j) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos query;
                        if (j == posY && k == z || !AOEHelper.canToolAffect(tool, stack, world, query = new BlockPos(x, j, k))) continue;
                        area.add(query);
                    }
                }
            }
        }
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getAOEBlocksMiningArea(ItemStack stack, BlockPos pos, PlayerEntity player, int radius, int depth) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        World world = player.func_130014_f_();
        Item tool = stack.func_77973_b();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int depth_min = depth;
        int depth_max = 0;
        BlockRayTraceResult traceResult = RayTracer.retrace(player, RayTraceContext.FluidMode.NONE);
        if (traceResult.func_216346_c() == RayTraceResult.Type.MISS || player.func_225608_bj_() || !AOEHelper.canToolAffect(tool, stack, world, pos) || radius <= 0 && depth <= 0) {
            return ImmutableList.of();
        }
        switch (traceResult.func_216354_b()) {
            case DOWN: {
                depth_min = 0;
                depth_max = depth;
            }
            case UP: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - depth_min; j <= y + depth_max; ++j) {
                        for (int k = z - radius; k <= z + radius; ++k) {
                            BlockPos query;
                            if (i == x && j == y && k == z || !AOEHelper.canToolAffect(tool, stack, world, query = new BlockPos(i, y, k))) continue;
                            area.add(query);
                        }
                    }
                }
                break;
            }
            case NORTH: {
                depth_min = 0;
                depth_max = depth;
            }
            case SOUTH: {
                int posY = y;
                y += radius - 1;
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        for (int k = z - depth_min; k <= z + depth_max; ++k) {
                            BlockPos query;
                            if (i == x && j == posY && k == z || !AOEHelper.canToolAffect(tool, stack, world, query = new BlockPos(i, j, z))) continue;
                            area.add(query);
                        }
                    }
                }
                break;
            }
            case WEST: {
                depth_min = 0;
                depth_max = depth;
            }
            case EAST: {
                int posY = y;
                y += radius - 1;
                for (int i = x - depth_min; i <= x + depth_max; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        for (int k = z - radius; k <= z + radius; ++k) {
                            BlockPos query;
                            if (i == x && j == posY && k == z || !AOEHelper.canToolAffect(tool, stack, world, query = new BlockPos(x, j, k))) continue;
                            area.add(query);
                        }
                    }
                }
                break;
            }
        }
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getAOEBlocksMiningLine(ItemStack stack, BlockPos pos, PlayerEntity player, int length) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        World world = player.func_130014_f_();
        Item tool = stack.func_77973_b();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (player.func_225608_bj_() || !AOEHelper.canToolAffect(tool, stack, world, pos) || length <= 0) {
            return ImmutableList.of();
        }
        switch (player.func_174811_aO()) {
            case SOUTH: {
                BlockPos query;
                for (int k = z + 1; k < z + length + 1 && AOEHelper.canToolAffect(tool, stack, world, query = new BlockPos(x, y, k)); ++k) {
                    area.add(query);
                }
                break;
            }
            case WEST: {
                BlockPos query;
                for (int i = x - 1; i > x - length - 1 && AOEHelper.canToolAffect(tool, stack, world, query = new BlockPos(i, y, z)); --i) {
                    area.add(query);
                }
                break;
            }
            case NORTH: {
                BlockPos query;
                for (int k = z - 1; k > z - length - 1 && AOEHelper.canToolAffect(tool, stack, world, query = new BlockPos(x, y, k)); --k) {
                    area.add(query);
                }
                break;
            }
            case EAST: {
                BlockPos query;
                for (int i = x + 1; i < x + length + 1 && AOEHelper.canToolAffect(tool, stack, world, query = new BlockPos(i, y, z)); ++i) {
                    area.add(query);
                }
                break;
            }
        }
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getAOEBlocksHoeRadius(ItemStack stack, BlockPos pos, PlayerEntity player, int radius) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        World world = player.func_130014_f_();
        boolean weeding = EnchantmentHelper.func_77506_a((Enchantment)EnsorcellationReferences.WEEDING, (ItemStack)stack) > 0;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockRayTraceResult traceResult = RayTracer.retrace(player, RayTraceContext.FluidMode.NONE);
        if (traceResult.func_216346_c() == RayTraceResult.Type.MISS || traceResult.func_216354_b() == Direction.DOWN || player.func_225608_bj_() || !AOEHelper.canHoeAffect(world, pos, weeding) || radius <= 0) {
            return ImmutableList.of();
        }
        for (int i = x - radius; i <= x + radius; ++i) {
            for (int k = z - radius; k <= z + radius; ++k) {
                BlockPos query;
                if (i == x && k == z || !AOEHelper.canHoeAffect(world, query = new BlockPos(i, y, k), weeding)) continue;
                area.add(query);
            }
        }
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getAOEBlocksHoeLine(ItemStack stack, BlockPos pos, PlayerEntity player, int length) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        World world = player.func_130014_f_();
        boolean weeding = EnchantmentHelper.func_77506_a((Enchantment)EnsorcellationReferences.WEEDING, (ItemStack)stack) > 0;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (player.func_225608_bj_() || !AOEHelper.canHoeAffect(world, pos, weeding) || length <= 0) {
            return ImmutableList.of();
        }
        switch (player.func_174811_aO()) {
            case SOUTH: {
                for (int k = z + 1; k < z + length + 1; ++k) {
                    BlockPos query = new BlockPos(x, y, k);
                    if (!AOEHelper.canHoeAffect(world, query, weeding)) continue;
                    area.add(query);
                }
                break;
            }
            case WEST: {
                for (int i = x - 1; i > x - length - 1; --i) {
                    BlockPos query = new BlockPos(i, y, z);
                    if (!AOEHelper.canHoeAffect(world, query, weeding)) continue;
                    area.add(query);
                }
                break;
            }
            case NORTH: {
                for (int k = z - 1; k > z - length - 1; --k) {
                    BlockPos query = new BlockPos(x, y, k);
                    if (!AOEHelper.canHoeAffect(world, query, weeding)) continue;
                    area.add(query);
                }
                break;
            }
            case EAST: {
                for (int i = x + 1; i < x + length + 1; ++i) {
                    BlockPos query = new BlockPos(i, y, z);
                    if (!AOEHelper.canHoeAffect(world, query, weeding)) continue;
                    area.add(query);
                }
                break;
            }
        }
        return ImmutableList.copyOf(area);
    }

    public static ImmutableList<BlockPos> getAOEBlocksSickle(ItemStack stack, BlockPos pos, PlayerEntity player, int radius, int height) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        World world = player.func_130014_f_();
        Item tool = stack.func_77973_b();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (player.func_225608_bj_() || !AOEHelper.canToolAffect(tool, stack, world, pos) || radius <= 0 && height <= 0) {
            return ImmutableList.of();
        }
        for (int i = x - radius; i <= x + radius; ++i) {
            for (int j = y - height; j <= y + height; ++j) {
                for (int k = z - radius; k <= z + radius; ++k) {
                    BlockPos query;
                    if (i == x && j == y && k == z || !AOEHelper.canToolAffect(tool, stack, world, query = new BlockPos(i, y, k))) continue;
                    area.add(query);
                }
            }
        }
        return ImmutableList.copyOf(area);
    }

    private static boolean canToolAffect(Item toolItem, ItemStack toolStack, World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_185887_b((IBlockReader)world, pos) < 0.0f) {
            return false;
        }
        return toolItem.canHarvestBlock(toolStack, state) || state.func_185904_a().func_76229_l() && toolItem.func_150893_a(toolStack, state) > 1.0f;
    }

    private static boolean canHoeAffect(World world, BlockPos pos, boolean weeding) {
        BlockState state = world.func_180495_p(pos);
        if (HoeItem.field_195973_b.containsKey(state.func_177230_c())) {
            BlockPos up = pos.func_177984_a();
            BlockState stateUp = world.func_180495_p(up);
            return world.func_175623_d(up) || weeding && (stateUp.func_185904_a() == Material.field_151585_k || stateUp.func_185904_a() == Material.field_151582_l) && stateUp.func_185887_b((IBlockReader)world, up) <= 0.0f;
        }
        return false;
    }
}

