/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.SimpleItemHandler;
import cofh.lib.tileentity.ITileCallback;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class SimpleItemInv
extends SimpleItemHandler {
    protected String tag;

    public SimpleItemInv(@Nullable ITileCallback tile) {
        this(tile, 0, "ItemInv");
    }

    public SimpleItemInv(@Nullable ITileCallback tile, int size) {
        this(tile, size, "ItemInv");
    }

    public SimpleItemInv(@Nullable ITileCallback tile, @Nonnull List<ItemStorageCoFH> slots) {
        this(tile, slots, "ItemInv");
    }

    public SimpleItemInv(@Nullable ITileCallback tile, @Nonnull String tag) {
        this(tile, 0, tag);
    }

    public SimpleItemInv(@Nullable ITileCallback tile, @Nonnull List<ItemStorageCoFH> slots, @Nonnull String tag) {
        super(tile, slots);
        this.tag = tag;
    }

    public SimpleItemInv(@Nullable ITileCallback tile, int size, @Nonnull String tag) {
        super(tile, new ArrayList<ItemStorageCoFH>(size));
        this.tile = tile;
        this.tag = tag;
        for (int i = 0; i < size; ++i) {
            this.slots.add(new ItemStorageCoFH());
        }
    }

    public void clear() {
        for (ItemStorageCoFH slot : this.slots) {
            slot.setItemStack(ItemStack.field_190927_a);
        }
    }

    public void set(int slot, ItemStack stack) {
        ((ItemStorageCoFH)this.slots.get(slot)).setItemStack(stack);
    }

    public ItemStack get(int slot) {
        return ((ItemStorageCoFH)this.slots.get(slot)).getItemStack();
    }

    public ItemStorageCoFH getSlot(int slot) {
        return (ItemStorageCoFH)this.slots.get(slot);
    }

    public SimpleItemInv readFromNBT(CompoundNBT nbt) {
        for (ItemStorageCoFH slot : this.slots) {
            slot.setItemStack(ItemStack.field_190927_a);
        }
        ListNBT list = nbt.func_150295_c(this.tag, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.slots.size()) continue;
            ((ItemStorageCoFH)this.slots.get(slot)).readFromNBT(tag);
        }
        return this;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        if (this.slots.size() <= 0) {
            return nbt;
        }
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.slots.size(); ++i) {
            if (((ItemStorageCoFH)this.slots.get(i)).isEmpty()) continue;
            CompoundNBT tag = new CompoundNBT();
            tag.func_74774_a("Slot", (byte)i);
            ((ItemStorageCoFH)this.slots.get(i)).writeToNBT(tag);
            list.add((Object)tag);
        }
        if (!list.isEmpty()) {
            nbt.func_218657_a(this.tag, (INBT)list);
        }
        return nbt;
    }
}

