/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.ManagedItemHandler;
import cofh.lib.inventory.SimpleItemHandler;
import cofh.lib.inventory.SimpleItemInv;
import cofh.lib.tileentity.ITileCallback;
import cofh.lib.util.StorageGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ManagedItemInv
extends SimpleItemInv {
    protected List<ItemStorageCoFH> inputSlots = new ArrayList<ItemStorageCoFH>();
    protected List<ItemStorageCoFH> catalystSlots = new ArrayList<ItemStorageCoFH>();
    protected List<ItemStorageCoFH> outputSlots = new ArrayList<ItemStorageCoFH>();
    protected List<ItemStorageCoFH> internalSlots = new ArrayList<ItemStorageCoFH>();

    public ManagedItemInv(ITileCallback tile) {
        super(tile);
    }

    public ManagedItemInv(ITileCallback tile, String tag) {
        super(tile, tag);
    }

    public void addSlot(StorageGroup group) {
        this.addSlot(new ItemStorageCoFH(), group);
    }

    public void addSlots(StorageGroup group, int amount) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot(new ItemStorageCoFH(), group);
        }
    }

    public void addSlot(ItemStorageCoFH slot, StorageGroup group) {
        this.slots.add(slot);
        switch (group) {
            case CATALYST: {
                this.catalystSlots.add(slot);
                this.inputSlots.add(slot);
            }
            case INPUT: {
                this.inputSlots.add(slot);
                break;
            }
            case OUTPUT: {
                this.outputSlots.add(slot);
                break;
            }
            case INTERNAL: {
                this.internalSlots.add(slot);
                break;
            }
        }
    }

    public void addSlot(Predicate<ItemStack> validator, StorageGroup group) {
        this.addSlot(new ItemStorageCoFH(validator), group);
    }

    public List<ItemStorageCoFH> getInputSlots() {
        return this.inputSlots;
    }

    public List<ItemStorageCoFH> getOutputSlots() {
        return this.outputSlots;
    }

    public List<ItemStorageCoFH> getInternalSlots() {
        return this.internalSlots;
    }

    public IItemHandler getHandler(StorageGroup group) {
        switch (group) {
            case INPUT: {
                return new ManagedItemHandler(this.tile, this.inputSlots, Collections.emptyList());
            }
            case OUTPUT: {
                return new ManagedItemHandler(this.tile, Collections.emptyList(), this.outputSlots);
            }
            case ACCESSIBLE: {
                return new ManagedItemHandler(this.tile, this.inputSlots, this.outputSlots);
            }
            case INTERNAL: {
                return new SimpleItemHandler(this.tile, this.internalSlots);
            }
            case ALL: {
                return new SimpleItemHandler(this.tile, this.slots);
            }
        }
        return EmptyHandler.INSTANCE;
    }
}

