/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.blocks;

import com.mojang.authlib.GameProfile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.information.CapabilityPowerInformation;
import mcjty.lib.api.information.IPowerInformation;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.smartwrench.ISmartWrenchSelector;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsbase.modules.various.VariousSetup;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.shield.DamageTypeMode;
import mcjty.rftoolsbuilder.modules.shield.RelCoordinate;
import mcjty.rftoolsbuilder.modules.shield.RelCoordinateShield;
import mcjty.rftoolsbuilder.modules.shield.ShieldConfiguration;
import mcjty.rftoolsbuilder.modules.shield.ShieldRenderingMode;
import mcjty.rftoolsbuilder.modules.shield.ShieldSetup;
import mcjty.rftoolsbuilder.modules.shield.ShieldTexture;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldTemplateBlock;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingBlock;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingTileEntity;
import mcjty.rftoolsbuilder.modules.shield.client.GuiShield;
import mcjty.rftoolsbuilder.modules.shield.client.ShieldRenderData;
import mcjty.rftoolsbuilder.modules.shield.filters.AbstractShieldFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.PlayerFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.ShieldFilter;
import mcjty.rftoolsbuilder.shapes.Shape;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ShieldProjectorTileEntity
extends GenericTileEntity
implements ISmartWrenchSelector,
ITickableTileEntity {
    public static final String CMD_ADDFILTER = "shield.addFilter";
    public static final Key<Integer> PARAM_ACTION = new Key("action", Type.INTEGER);
    public static final Key<String> PARAM_TYPE = new Key("type", Type.STRING);
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final Key<Integer> PARAM_SELECTED = new Key("selected", Type.INTEGER);
    public static final String CMD_DELFILTER = "shield.delFilter";
    public static final String CMD_UPFILTER = "shield.upFilter";
    public static final String CMD_DOWNFILTER = "shield.downFilter";
    public static final String CMD_GETFILTERS = "getFilters";
    public static final String CLIENTCMD_GETFILTERS = "getFilters";
    public static final String COMPONENT_NAME = "shield_projector";
    public static final Key<Integer> VALUE_SHIELDVISMODE = new Key("shieldVisMode", Type.INTEGER);
    public static final Key<Integer> VALUE_SHIELDTEXTURE = new Key("shieldTexture", Type.INTEGER);
    public static final Key<Integer> VALUE_DAMAGEMODE = new Key("damageMode", Type.INTEGER);
    public static final Key<Integer> VALUE_COLOR = new Key("color", Type.INTEGER);
    public static final Key<Boolean> VALUE_LIGHT = new Key("light", Type.BOOLEAN);
    private ShieldRenderData renderData;
    private DamageTypeMode damageMode = DamageTypeMode.DAMAGETYPE_GENERIC;
    private boolean shieldComposed = false;
    private BlockState templateState = Blocks.field_150350_a.func_176223_P();
    private boolean shieldActive = false;
    private int powerTimeout = 0;
    private int updateTimeout = 0;
    private int shieldColor;
    private boolean blockLight = false;
    private int supportedBlocks;
    private float damageFactor = 1.0f;
    private float costFactor = 1.0f;
    private final List<ShieldFilter> filters = new ArrayList<ShieldFilter>();
    private ShieldTexture shieldTexture = ShieldTexture.SHIELD;
    private ShieldRenderingMode shieldRenderingMode = ShieldRenderingMode.SHIELD;
    private final List<RelCoordinateShield> shieldBlocks = new ArrayList<RelCoordinateShield>();
    private final List<BlockState> blockStateTable = new ArrayList<BlockState>();
    public static final int SLOT_BUFFER = 0;
    public static final int SLOT_SHAPE = 1;
    public static final int SLOT_SHARD = 2;
    public static final int BUFFER_SIZE = 3;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(3).slot(SlotDefinition.input(), "container", 0, 26, 142).slot(SlotDefinition.specific(s -> s.func_77973_b() instanceof ShapeCardItem), "container", 1, 26, 200).slot(SlotDefinition.specific(s -> s.func_77973_b() == VariousSetup.DIMENSIONALSHARD.get()), "container", 2, 229, 118).playerSlots(85, 142));
    private final NoDirectionItemHander items = this.createItemHandler();
    private final LazyOptional<NoDirectionItemHander> itemHandler = LazyOptional.of(() -> this.items);
    private final LazyOptional<AutomationFilterItemHander> automationItemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> new GenericEnergyStorage((GenericTileEntity)this, true, (long)this.getConfigMaxEnergy(), (long)this.getConfigRfPerTick()));
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Screen").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)ShieldSetup.CONTAINER_SHIELD.get(), windowId.intValue(), (ContainerFactory)CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)).energyHandler(this.energyHandler).itemHandler(this.itemHandler));
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    private final LazyOptional<IPowerInformation> powerInfoHandler = LazyOptional.of(this::createPowerInfo);
    private final int maxEnergy;
    private final int rfPerTick;
    private FakePlayer fakePlayer = null;
    private FakePlayer killer = null;
    private ItemStack lootingSword = ItemStack.field_190927_a;

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_RSMODE, () -> ((ShieldProjectorTileEntity)this).getRSModeInt(), arg_0 -> ((ShieldProjectorTileEntity)this).setRSModeInt(arg_0)), new DefaultValue(VALUE_SHIELDVISMODE, () -> this.getShieldRenderingMode().ordinal(), value -> this.setShieldRenderingMode(ShieldRenderingMode.values()[value])), new DefaultValue(VALUE_SHIELDTEXTURE, () -> this.getShieldTexture().ordinal(), value -> this.setShieldTexture(ShieldTexture.values()[value])), new DefaultValue(VALUE_DAMAGEMODE, () -> this.getDamageMode().ordinal(), value -> this.setDamageMode(DamageTypeMode.values()[value])), new DefaultValue(VALUE_COLOR, this::getShieldColor, this::setShieldColor), new DefaultValue(VALUE_LIGHT, this::isBlockLight, this::setBlockLight)};
    }

    public ShieldProjectorTileEntity(TileEntityType<?> type, int supportedBlocks, int maxEnergy, int rfPerTick) {
        super(type);
        this.supportedBlocks = supportedBlocks;
        this.maxEnergy = maxEnergy;
        this.rfPerTick = rfPerTick;
    }

    private int getConfigMaxEnergy() {
        return this.maxEnergy;
    }

    private int getConfigRfPerTick() {
        return this.rfPerTick;
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public ShieldProjectorTileEntity setDamageFactor(float factor) {
        this.damageFactor = factor;
        return this;
    }

    public ShieldProjectorTileEntity setCostFactor(float factor) {
        this.costFactor = factor;
        return this;
    }

    public ShieldRenderData getRenderData() {
        if (this.renderData == null) {
            float r = (float)(this.shieldColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.shieldColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.shieldColor & 0xFF) / 255.0f;
            this.renderData = new ShieldRenderData(r, g, b, 1.0f, this.shieldTexture);
        }
        return this.renderData;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        int oldColor = this.shieldColor;
        ShieldTexture oldTexture = this.shieldTexture;
        super.onDataPacket(net, packet);
        if (oldColor != this.shieldColor || oldTexture != this.shieldTexture) {
            this.renderData = null;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    private Object[] setDamageMode(String mode) {
        DamageTypeMode damageMode = DamageTypeMode.getMode(mode);
        if (damageMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setDamageMode(damageMode);
        return null;
    }

    private Object[] setRedstoneMode(String mode) {
        RedstoneMode redstoneMode = RedstoneMode.getMode((String)mode);
        if (redstoneMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setRSMode(redstoneMode);
        return null;
    }

    private Object[] setShieldRenderingMode(String mode) {
        ShieldRenderingMode renderingMode = ShieldRenderingMode.getMode(mode);
        if (renderingMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setShieldRenderingMode(renderingMode);
        return null;
    }

    private Object[] composeShieldComp(boolean ctrl) {
        boolean done = false;
        if (!this.isShieldComposed()) {
            this.composeShield(ctrl);
            done = true;
        }
        return new Object[]{done};
    }

    private Object[] decomposeShieldComp() {
        boolean done = false;
        if (this.isShieldComposed()) {
            this.decomposeShield();
            done = true;
        }
        return new Object[]{done};
    }

    public boolean isPowered() {
        return this.powerLevel > 0;
    }

    public List<ShieldFilter> getFilters() {
        return this.filters;
    }

    public boolean isBlockLight() {
        return this.blockLight;
    }

    public void setBlockLight(boolean blockLight) {
        this.blockLight = blockLight;
        this.updateTimeout = 10;
        this.markDirtyClient();
    }

    public int getShieldColor() {
        return this.shieldColor;
    }

    public void setShieldColor(int shieldColor) {
        this.shieldColor = shieldColor;
        this.updateTimeout = 10;
        this.markDirtyClient();
    }

    private void delFilter(int selected) {
        this.filters.remove(selected);
        this.updateTimeout = 10;
        this.markDirtyClient();
    }

    private void upFilter(int selected) {
        ShieldFilter filter1 = this.filters.get(selected - 1);
        ShieldFilter filter2 = this.filters.get(selected);
        this.filters.set(selected - 1, filter2);
        this.filters.set(selected, filter1);
        this.markDirtyClient();
    }

    private void downFilter(int selected) {
        ShieldFilter filter1 = this.filters.get(selected);
        ShieldFilter filter2 = this.filters.get(selected + 1);
        this.filters.set(selected, filter2);
        this.filters.set(selected + 1, filter1);
        this.markDirtyClient();
    }

    private void addFilter(int action, String type, String player, int selected) {
        ShieldFilter filter = AbstractShieldFilter.createFilter(type);
        filter.setAction(action);
        if (filter instanceof PlayerFilter) {
            ((PlayerFilter)filter).setName(player);
        }
        if (selected == -1) {
            this.filters.add(filter);
        } else {
            this.filters.add(selected, filter);
        }
        this.updateTimeout = 10;
        this.markDirtyClient();
    }

    public DamageTypeMode getDamageMode() {
        return this.damageMode;
    }

    public void setDamageMode(DamageTypeMode damageMode) {
        this.damageMode = damageMode;
        this.markDirtyClient();
    }

    public ShieldRenderingMode getShieldRenderingMode() {
        return this.shieldRenderingMode;
    }

    public void setShieldRenderingMode(ShieldRenderingMode shieldRenderingMode) {
        this.shieldRenderingMode = shieldRenderingMode;
        this.updateTimeout = 10;
        this.markDirtyClient();
    }

    public ShieldTexture getShieldTexture() {
        return this.shieldTexture;
    }

    public void setShieldTexture(ShieldTexture shieldTexture) {
        this.shieldTexture = shieldTexture;
        this.updateTimeout = 10;
        this.markDirtyClient();
    }

    private FakePlayer getFakePlayer() {
        if (this.fakePlayer == null) {
            this.fakePlayer = FakePlayerFactory.get((ServerWorld)((ServerWorld)this.field_145850_b), (GameProfile)new GameProfile(UUID.nameUUIDFromBytes("rftools_shield".getBytes()), "rftools_builder"));
        }
        this.fakePlayer.func_70029_a(this.field_145850_b);
        this.fakePlayer.func_70107_b((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
        return this.fakePlayer;
    }

    @Nonnull
    private BlockState getStateFromItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            FakePlayer player = this.getFakePlayer();
            player.func_184611_a(Hand.MAIN_HAND, stack);
            BlockRayTraceResult result = new BlockRayTraceResult(new Vec3d(0.5, 0.0, 0.5), Direction.UP, this.field_174879_c, false);
            BlockItemUseContext context = new BlockItemUseContext(new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, result));
            BlockState stateForPlacement = blockItem.func_179223_d().func_196258_a(context);
            return stateForPlacement == null ? blockItem.func_179223_d().func_176223_P() : stateForPlacement;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Nullable
    private BlockState calculateMimic() {
        if (!ShieldRenderingMode.MIMIC.equals((Object)this.shieldRenderingMode)) {
            return null;
        }
        LazyOptional map = this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(h -> h.getStackInSlot(0)).filter(stack -> !stack.func_190926_b()).map(this::getStateFromItem);
        if (map.isPresent()) {
            return (BlockState)map.orElseThrow(RuntimeException::new);
        }
        return null;
    }

    private BlockState calculateShieldBlock(BlockState mimic, boolean blockLight) {
        if (!this.shieldActive || this.powerTimeout > 0) {
            return Blocks.field_150350_a.func_176223_P();
        }
        ShieldRenderingMode render = this.shieldRenderingMode;
        if (!((Boolean)ShieldConfiguration.allowInvisibleShield.get()).booleanValue() && ShieldRenderingMode.INVISIBLE.equals((Object)this.shieldRenderingMode)) {
            render = ShieldRenderingMode.SOLID;
        }
        if (mimic != null) {
            render = ShieldRenderingMode.MIMIC;
        }
        BlockState shielding = this.getShieldingBlock(render, mimic).func_176223_P();
        shielding = (BlockState)shielding.func_206870_a((IProperty)ShieldingBlock.FLAG_OPAQUE, (Comparable)Boolean.valueOf(!blockLight));
        shielding = (BlockState)shielding.func_206870_a(ShieldingBlock.RENDER_MODE, (Comparable)((Object)render));
        shielding = this.calculateShieldCollisionData(shielding);
        shielding = this.calculateDamageBits(shielding);
        return shielding;
    }

    private Block getShieldingBlock(ShieldRenderingMode render, BlockState mimic) {
        if (mimic == null) {
            if (render.isTranslucent()) {
                return (Block)ShieldSetup.SHIELDING_TRANSLUCENT.get();
            }
            return (Block)ShieldSetup.SHIELDING_SOLID.get();
        }
        return (Block)ShieldSetup.SHIELDING_SOLID.get();
    }

    private BlockState calculateDamageBits(BlockState shielding) {
        for (ShieldFilter filter : this.filters) {
            if ((filter.getAction() & 2) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.func_206870_a((IProperty)ShieldingBlock.DAMAGE_ITEMS, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.func_206870_a((IProperty)ShieldingBlock.DAMAGE_PASSIVE, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.func_206870_a((IProperty)ShieldingBlock.DAMAGE_HOSTILE, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.func_206870_a((IProperty)ShieldingBlock.DAMAGE_PLAYERS, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            shielding = (BlockState)((BlockState)((BlockState)((BlockState)shielding.func_206870_a((IProperty)ShieldingBlock.DAMAGE_ITEMS, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)ShieldingBlock.DAMAGE_PASSIVE, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)ShieldingBlock.DAMAGE_HOSTILE, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)ShieldingBlock.DAMAGE_PLAYERS, (Comparable)Boolean.valueOf(true));
        }
        return shielding;
    }

    private BlockState calculateShieldCollisionData(BlockState shielding) {
        for (ShieldFilter filter : this.filters) {
            if ((filter.getAction() & 1) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.func_206870_a((IProperty)ShieldingBlock.BLOCKED_ITEMS, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.func_206870_a((IProperty)ShieldingBlock.BLOCKED_PASSIVE, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.func_206870_a((IProperty)ShieldingBlock.BLOCKED_HOSTILE, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.func_206870_a((IProperty)ShieldingBlock.BLOCKED_PLAYERS, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            shielding = (BlockState)((BlockState)((BlockState)((BlockState)shielding.func_206870_a((IProperty)ShieldingBlock.BLOCKED_ITEMS, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)ShieldingBlock.BLOCKED_PASSIVE, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)ShieldingBlock.BLOCKED_HOSTILE, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)ShieldingBlock.BLOCKED_PLAYERS, (Comparable)Boolean.valueOf(true));
        }
        return shielding;
    }

    private int calculateRfPerTick() {
        if (!this.shieldActive) {
            return 0;
        }
        int s = this.shieldBlocks.size() - 50;
        if (s < 10) {
            s = 10;
        }
        int rf = (Integer)ShieldConfiguration.rfBase.get() * s / 10;
        if (ShieldRenderingMode.SHIELD.equals((Object)this.shieldRenderingMode)) {
            rf += (Integer)ShieldConfiguration.rfShield.get() * s / 10;
        } else if (ShieldRenderingMode.MIMIC.equals((Object)this.shieldRenderingMode)) {
            rf += (Integer)ShieldConfiguration.rfCamo.get() * s / 10;
        }
        return rf;
    }

    public boolean isShieldComposed() {
        return this.shieldComposed;
    }

    public boolean isShieldActive() {
        return this.shieldActive;
    }

    public void applyDamageToEntity(Entity entity) {
        this.energyHandler.ifPresent(h -> {
            DamageSource source;
            int rf;
            if (DamageTypeMode.DAMAGETYPE_GENERIC.equals((Object)this.damageMode)) {
                rf = (Integer)ShieldConfiguration.rfDamage.get();
                source = DamageSource.field_76377_j;
            } else {
                rf = (Integer)ShieldConfiguration.rfDamagePlayer.get();
                if (this.killer == null) {
                    this.killer = FakePlayerFactory.get((ServerWorld)WorldTools.getOverworld((World)this.field_145850_b), (GameProfile)new GameProfile(UUID.nameUUIDFromBytes("rftools_shield".getBytes()), "rftools_shield"));
                }
                this.killer.func_70029_a(this.field_145850_b);
                this.killer.func_70107_b((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
                FakePlayer fakePlayer = this.killer;
                ItemStack shards = this.items.getStackInSlot(2);
                if (!shards.func_190926_b() && shards.func_190916_E() >= (Integer)ShieldConfiguration.shardsPerLootingKill.get()) {
                    this.items.extractItem(2, ((Integer)ShieldConfiguration.shardsPerLootingKill.get()).intValue(), false);
                    if (this.lootingSword.func_190926_b()) {
                        this.lootingSword = ShieldProjectorTileEntity.createEnchantedItem(Items.field_151048_u, Enchantments.field_185304_p, (Integer)ShieldConfiguration.lootingKillBonus.get());
                    }
                    this.lootingSword.func_196085_b(0);
                    fakePlayer.func_184611_a(Hand.MAIN_HAND, this.lootingSword);
                } else {
                    fakePlayer.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                }
                source = DamageSource.func_76365_a((PlayerEntity)fakePlayer);
            }
            float factor = ((Float)this.infusableHandler.map(IInfusable::getInfusedFactor).orElse((Object)Float.valueOf(0.0f))).floatValue();
            rf = (int)((float)rf * this.costFactor * (4.0f - factor) / 4.0f);
            if (h.getEnergyStored() < rf) {
                return;
            }
            h.consumeEnergy((long)rf);
            float damage = (float)((Double)ShieldConfiguration.damage.get()).doubleValue();
            damage *= this.damageFactor;
            entity.func_70097_a(source, damage *= 1.0f + factor / 2.0f);
        });
    }

    public static ItemStack createEnchantedItem(Item item, Enchantment effectId, int amount) {
        ItemStack stack = new ItemStack((IItemProvider)item);
        HashMap<Enchantment, Integer> enchant = new HashMap<Enchantment, Integer>();
        enchant.put(effectId, amount);
        EnchantmentHelper.func_82782_a(enchant, (ItemStack)stack);
        return stack;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (!this.shieldComposed) {
            return;
        }
        if (this.updateTimeout > 0) {
            --this.updateTimeout;
            if (this.updateTimeout <= 0) {
                this.updateShield();
            }
        }
        this.energyHandler.ifPresent(h -> {
            boolean newShieldActive;
            boolean checkPower = false;
            if (this.powerTimeout > 0) {
                --this.powerTimeout;
                this.func_70296_d();
                if (this.powerTimeout > 0) {
                    return;
                }
                checkPower = true;
            }
            boolean needsUpdate = false;
            int rf = this.getRfPerTick();
            if (rf > 0) {
                if (h.getEnergyStored() < rf) {
                    this.powerTimeout = 100;
                    needsUpdate = true;
                } else {
                    if (checkPower) {
                        needsUpdate = true;
                    }
                    h.consumeEnergy((long)rf);
                }
            }
            if ((newShieldActive = this.isMachineEnabled()) != this.shieldActive) {
                needsUpdate = true;
                this.shieldActive = newShieldActive;
            }
            if (needsUpdate) {
                this.updateShield();
                this.func_70296_d();
            }
        });
    }

    private int getRfPerTick() {
        int rf = this.calculateRfPerTick();
        float factor = ((Float)this.infusableHandler.map(IInfusable::getInfusedFactor).orElse((Object)Float.valueOf(0.0f))).floatValue();
        rf = (int)((float)rf * (2.0f - factor) / 2.0f);
        return rf;
    }

    public void composeDecomposeShield(boolean ctrl) {
        if (this.shieldComposed) {
            this.decomposeShield();
        } else {
            this.composeShield(ctrl);
        }
    }

    public void composeShield(boolean ctrl) {
        HashMap<BlockPos, BlockState> coordinates;
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        if (this.isShapedShield()) {
            this.templateState = Blocks.field_150350_a.func_176223_P();
            ItemStack shapeItem = this.items.getStackInSlot(1);
            Shape shape = ShapeCardItem.getShape(shapeItem);
            boolean solid = ShapeCardItem.isSolid(shapeItem);
            BlockPos dimension = ShapeCardItem.getClampedDimension(shapeItem, (int)((Integer)ShieldConfiguration.maxShieldDimension.get()));
            BlockPos offset = ShapeCardItem.getClampedOffset(shapeItem, (int)((Integer)ShieldConfiguration.maxShieldOffset.get()));
            HashMap<BlockPos, BlockState> col = new HashMap<BlockPos, BlockState>();
            ShapeCardItem.composeFormula(shapeItem, shape.getFormulaFactory().get(), this.func_145831_w(), this.func_174877_v(), dimension, offset, col, this.supportedBlocks, solid, false, null);
            coordinates = col;
        } else {
            if (!this.findTemplateState()) {
                return;
            }
            HashMap<BlockPos, BlockState> col = new HashMap<BlockPos, BlockState>();
            this.findTemplateBlocks(col, this.templateState, ctrl, this.func_174877_v());
            coordinates = col;
        }
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        for (Map.Entry entry : coordinates.entrySet()) {
            BlockPos c = (BlockPos)entry.getKey();
            BlockState state = (BlockState)entry.getValue();
            int st = -1;
            if (state != null) {
                for (int i = 0; i < this.blockStateTable.size(); ++i) {
                    if (!state.equals(this.blockStateTable.get(i))) continue;
                    st = i;
                    break;
                }
                if (st == -1) {
                    st = this.blockStateTable.size();
                    this.blockStateTable.add(state);
                }
            }
            this.shieldBlocks.add(new RelCoordinateShield(c.func_177958_n() - xCoord, c.func_177956_o() - yCoord, c.func_177952_p() - zCoord, st));
            this.func_145831_w().func_175656_a(c, Blocks.field_150350_a.func_176223_P());
        }
        this.shieldComposed = true;
        this.updateShield();
    }

    private boolean isShapedShield() {
        return !this.items.getStackInSlot(1).func_190926_b();
    }

    private boolean findTemplateState() {
        for (Direction dir : OrientationTools.DIRECTION_VALUES) {
            BlockState state;
            BlockPos p = this.func_174877_v().func_177972_a(dir);
            if (p.func_177956_o() < 0 || p.func_177956_o() >= this.func_145831_w().func_217301_I() || !((state = this.func_145831_w().func_180495_p(p)).func_177230_c() instanceof ShieldTemplateBlock)) continue;
            this.templateState = state;
            return true;
        }
        return false;
    }

    public void selectBlock(PlayerEntity player, BlockPos pos) {
        if (!this.shieldComposed) {
            Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Shield is not composed. Nothing happens!"));
            return;
        }
        float squaredDistance = (float)this.func_174877_v().func_177951_i((Vec3i)pos);
        if (squaredDistance > (float)((Integer)ShieldConfiguration.maxDisjointShieldDistance.get() * (Integer)ShieldConfiguration.maxDisjointShieldDistance.get())) {
            Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "This template is too far to connect to the shield!"));
            return;
        }
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        Block origBlock = this.func_145831_w().func_180495_p(pos).func_177230_c();
        if (origBlock instanceof ShieldTemplateBlock) {
            if (this.isShapedShield()) {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "You cannot add template blocks to a shaped shield (using a shape card)!"));
                return;
            }
            HashMap<BlockPos, BlockState> templateBlocks = new HashMap<BlockPos, BlockState>();
            BlockState state = this.func_145831_w().func_180495_p(pos);
            templateBlocks.put(pos, null);
            this.findTemplateBlocks(templateBlocks, state, false, pos);
            BlockState mimic = this.calculateMimic();
            BlockState shielding = this.calculateShieldBlock(mimic, this.blockLight);
            for (Map.Entry entry : templateBlocks.entrySet()) {
                BlockPos templateBlock = (BlockPos)entry.getKey();
                RelCoordinateShield relc = new RelCoordinateShield(templateBlock.func_177958_n() - xCoord, templateBlock.func_177956_o() - yCoord, templateBlock.func_177952_p() - zCoord, -1);
                this.shieldBlocks.add(relc);
                this.updateShieldBlock(mimic, shielding, relc);
            }
        } else if (origBlock instanceof ShieldingBlock) {
            this.shieldBlocks.remove(new RelCoordinate(pos.func_177958_n() - xCoord, pos.func_177956_o() - yCoord, pos.func_177952_p() - zCoord));
            this.func_145831_w().func_180501_a(pos, this.templateState, 2);
        } else {
            Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "The selected shield can't do anything with this block!"));
            return;
        }
        this.markDirtyClient();
    }

    private void updateShield() {
        BlockState mimic = this.calculateMimic();
        BlockState shielding = this.calculateShieldBlock(mimic, this.blockLight);
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (RelCoordinateShield c : this.shieldBlocks) {
            if (Blocks.field_150350_a.equals(shielding.func_177230_c())) {
                pos.func_181079_c(xCoord + c.getDx(), yCoord + c.getDy(), zCoord + c.getDz());
                BlockState oldState = this.func_145831_w().func_180495_p((BlockPos)pos);
                if (!(oldState.func_177230_c() instanceof ShieldingBlock)) continue;
                this.func_145831_w().func_175656_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P());
                continue;
            }
            this.updateShieldBlock(mimic, shielding, c);
        }
        this.markDirtyClient();
    }

    private void updateShieldBlock(BlockState mimic, BlockState shielding, RelCoordinateShield c) {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        BlockPos pp = new BlockPos(xCoord + c.getDx(), yCoord + c.getDy(), zCoord + c.getDz());
        BlockState oldState = this.func_145831_w().func_180495_p(pp);
        if (!(oldState.func_177230_c() instanceof ShieldingBlock || oldState.func_185904_a().func_76222_j() || oldState.func_177230_c() instanceof ShieldTemplateBlock)) {
            return;
        }
        this.field_145850_b.func_175656_a(pp, Blocks.field_150350_a.func_176223_P());
        this.field_145850_b.func_180501_a(pp, shielding, 2);
        TileEntity te = this.func_145831_w().func_175625_s(pp);
        if (te instanceof ShieldingTileEntity) {
            ShieldingTileEntity shieldingTE = (ShieldingTileEntity)te;
            if (c.getState() != -1) {
                BlockState state = this.blockStateTable.get(c.getState());
                shieldingTE.setMimic(state);
            } else {
                shieldingTE.setMimic(mimic);
            }
            shieldingTE.setShieldProjector(this.field_174879_c);
        }
    }

    public void decomposeShield() {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        BlockPos.Mutable pp = new BlockPos.Mutable();
        for (RelCoordinate relCoordinate : this.shieldBlocks) {
            int cx = xCoord + relCoordinate.getDx();
            int cy = yCoord + relCoordinate.getDy();
            int cz = zCoord + relCoordinate.getDz();
            pp.func_181079_c(cx, cy, cz);
            Block block = this.func_145831_w().func_180495_p((BlockPos)pp).func_177230_c();
            if (this.func_145831_w().func_175623_d((BlockPos)pp) || block instanceof ShieldingBlock) {
                this.func_145831_w().func_180501_a(new BlockPos((Vec3i)pp), this.templateState, 2);
                continue;
            }
            if (this.templateState.func_185904_a() == Material.field_151579_a || this.isShapedShield()) continue;
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)cx, (double)cy, (double)cz, (ItemStack)this.templateState.func_177230_c().func_185473_a((IBlockReader)this.func_145831_w(), new BlockPos(cx, cy, cz), this.templateState));
        }
        this.shieldComposed = false;
        this.shieldActive = false;
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        this.markDirtyClient();
    }

    private void findTemplateBlocks(Map<BlockPos, BlockState> coordinateSet, BlockState templateState, boolean ctrl, BlockPos start) {
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        if (ctrl) {
            this.addToTodoCornered(coordinateSet, todo, start, templateState);
            while (!todo.isEmpty() && coordinateSet.size() < this.supportedBlocks) {
                BlockPos coordinate = (BlockPos)todo.pollFirst();
                coordinateSet.put(coordinate, null);
                this.addToTodoCornered(coordinateSet, todo, coordinate, templateState);
            }
        } else {
            this.addToTodoStraight(coordinateSet, todo, start, templateState);
            while (!todo.isEmpty() && coordinateSet.size() < this.supportedBlocks) {
                BlockPos coordinate = (BlockPos)todo.pollFirst();
                coordinateSet.put(coordinate, null);
                this.addToTodoStraight(coordinateSet, todo, coordinate, templateState);
            }
        }
    }

    private void addToTodoStraight(Map<BlockPos, BlockState> coordinateSet, Deque<BlockPos> todo, BlockPos coordinate, BlockState templateState) {
        for (Direction dir : OrientationTools.DIRECTION_VALUES) {
            BlockState state;
            BlockPos pp = coordinate.func_177972_a(dir);
            if (pp.func_177956_o() < 0 || pp.func_177956_o() >= this.func_145831_w().func_217301_I() || coordinateSet.containsKey(pp) || (state = this.func_145831_w().func_180495_p(pp)) != templateState || todo.contains(pp)) continue;
            todo.addLast(pp);
        }
    }

    private void addToTodoCornered(Map<BlockPos, BlockState> coordinateSet, Deque<BlockPos> todo, BlockPos coordinate, BlockState templateState) {
        int x = coordinate.func_177958_n();
        int y = coordinate.func_177956_o();
        int z = coordinate.func_177952_p();
        BlockPos.Mutable c = new BlockPos.Mutable();
        for (int xx = x - 1; xx <= x + 1; ++xx) {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                for (int zz = z - 1; zz <= z + 1; ++zz) {
                    BlockState state;
                    if (xx == x && yy == y && zz == z || yy < 0 || yy >= this.func_145831_w().func_217301_I()) continue;
                    c.func_181079_c(xx, yy, zz);
                    if (coordinateSet.containsKey(c) || (state = this.func_145831_w().func_180495_p((BlockPos)c)) != templateState || todo.contains(c)) continue;
                    todo.addLast(c.func_185334_h());
                }
            }
        }
    }

    private static short bytesToShort(byte b1, byte b2) {
        short s1 = (short)(b1 & 0xFF);
        short s2 = (short)(b2 & 0xFF);
        return (short)(s1 * 256 + s2);
    }

    private static byte shortToByte1(short s) {
        return (byte)((s & 0xFF00) >> 8);
    }

    private static byte shortToByte2(short s) {
        return (byte)(s & 0xFF);
    }

    public void readClientDataFromNBT(CompoundNBT tagCompound) {
        this.powerLevel = tagCompound.func_74771_c("powered");
        this.shieldComposed = tagCompound.func_74767_n("composed");
        this.shieldActive = tagCompound.func_74767_n("active");
        this.powerTimeout = tagCompound.func_74762_e("powerTimeout");
        if (tagCompound.func_74764_b("templateColor")) {
            int templateColor = tagCompound.func_74762_e("templateColor");
            ShieldTemplateBlock.TemplateColor color = ShieldTemplateBlock.TemplateColor.values()[templateColor];
            switch (color) {
                case BLUE: {
                    this.templateState = ((ShieldTemplateBlock)ShieldSetup.TEMPLATE_BLUE.get()).func_176223_P();
                    break;
                }
                case RED: {
                    this.templateState = ((ShieldTemplateBlock)ShieldSetup.TEMPLATE_RED.get()).func_176223_P();
                    break;
                }
                case GREEN: {
                    this.templateState = ((ShieldTemplateBlock)ShieldSetup.TEMPLATE_GREEN.get()).func_176223_P();
                    break;
                }
                case YELLOW: {
                    this.templateState = ((ShieldTemplateBlock)ShieldSetup.TEMPLATE_YELLOW.get()).func_176223_P();
                }
            }
        } else {
            this.templateState = Blocks.field_150350_a.func_176223_P();
        }
        this.readEnergyCap(tagCompound);
        if (tagCompound.func_74764_b("Info")) {
            CompoundNBT info = tagCompound.func_74775_l("Info");
            this.shieldRenderingMode = ShieldRenderingMode.values()[info.func_74762_e("visMode")];
            this.shieldTexture = ShieldTexture.values()[info.func_74762_e("shieldTexture")];
            this.rsMode = RedstoneMode.values()[info.func_74771_c("rsMode")];
            this.damageMode = DamageTypeMode.values()[info.func_74771_c("damageMode")];
            this.blockLight = info.func_74767_n("blocklight");
            this.shieldColor = info.func_74764_b("shieldColor") ? info.func_74762_e("shieldColor") : 9895880;
            this.readFiltersFromNBT(info);
        }
        this.renderData = null;
    }

    public void writeClientDataToNBT(CompoundNBT tagCompound) {
        tagCompound.func_74774_a("powered", (byte)this.powerLevel);
        tagCompound.func_74757_a("composed", this.shieldComposed);
        tagCompound.func_74757_a("active", this.shieldActive);
        tagCompound.func_74768_a("powerTimeout", this.powerTimeout);
        if (this.templateState.func_185904_a() != Material.field_151579_a) {
            tagCompound.func_74768_a("templateColor", ((ShieldTemplateBlock)this.templateState.func_177230_c()).getColor().ordinal());
        }
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("visMode", this.shieldRenderingMode.ordinal());
        info.func_74768_a("shieldTexture", this.shieldTexture.ordinal());
        info.func_74774_a("rsMode", (byte)this.rsMode.ordinal());
        info.func_74774_a("damageMode", (byte)this.damageMode.ordinal());
        info.func_74757_a("blocklight", this.blockLight);
        info.func_74768_a("shieldColor", this.shieldColor);
        this.writeFiltersToNBT(info);
        this.writeEnergyCap(tagCompound);
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.shieldComposed = tagCompound.func_74767_n("composed");
        this.shieldActive = tagCompound.func_74767_n("active");
        this.powerTimeout = tagCompound.func_74762_e("powerTimeout");
        if (!this.isShapedShield()) {
            if (tagCompound.func_74764_b("templateColor")) {
                int templateColor = tagCompound.func_74762_e("templateColor");
                ShieldTemplateBlock.TemplateColor color = ShieldTemplateBlock.TemplateColor.values()[templateColor];
                switch (color) {
                    case BLUE: {
                        this.templateState = ((ShieldTemplateBlock)ShieldSetup.TEMPLATE_BLUE.get()).func_176223_P();
                        break;
                    }
                    case RED: {
                        this.templateState = ((ShieldTemplateBlock)ShieldSetup.TEMPLATE_RED.get()).func_176223_P();
                        break;
                    }
                    case GREEN: {
                        this.templateState = ((ShieldTemplateBlock)ShieldSetup.TEMPLATE_GREEN.get()).func_176223_P();
                        break;
                    }
                    case YELLOW: {
                        this.templateState = ((ShieldTemplateBlock)ShieldSetup.TEMPLATE_YELLOW.get()).func_176223_P();
                    }
                }
            } else {
                this.templateState = Blocks.field_150350_a.func_176223_P();
            }
        } else {
            this.templateState = Blocks.field_150350_a.func_176223_P();
        }
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        if (tagCompound.func_74764_b("relcoordsNew")) {
            byte[] byteArray = tagCompound.func_74770_j("relcoordsNew");
            int j = 0;
            for (int i = 0; i < byteArray.length / 8; ++i) {
                short dx = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 0], byteArray[j + 1]);
                short dy = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 2], byteArray[j + 3]);
                short dz = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 4], byteArray[j + 5]);
                short st = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 6], byteArray[j + 7]);
                j += 8;
                this.shieldBlocks.add(new RelCoordinateShield(dx, dy, dz, st));
            }
            ListNBT list = tagCompound.func_150295_c("gstates", 10);
            for (INBT inbt : list) {
                CompoundNBT tc = (CompoundNBT)inbt;
                String b = tc.func_74779_i("b");
                int m = tc.func_74762_e("m");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(b));
                if (block == null) {
                    block = Blocks.field_150348_b;
                    m = 0;
                }
                BlockState state = block.func_176223_P();
                this.blockStateTable.add(state);
            }
        } else {
            byte[] byteArray = tagCompound.func_74770_j("relcoords");
            int j = 0;
            for (int i = 0; i < byteArray.length / 6; ++i) {
                short dx = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 0], byteArray[j + 1]);
                short dy = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 2], byteArray[j + 3]);
                short dz = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 4], byteArray[j + 5]);
                j += 6;
                this.shieldBlocks.add(new RelCoordinateShield(dx, dy, dz, -1));
            }
        }
    }

    protected void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        if (tagCompound.func_74764_b("Info")) {
            CompoundNBT info = tagCompound.func_74775_l("Info");
            this.shieldRenderingMode = ShieldRenderingMode.values()[info.func_74762_e("visMode")];
            this.shieldTexture = ShieldTexture.values()[info.func_74762_e("shieldTexture")];
            this.damageMode = DamageTypeMode.values()[info.func_74771_c("damageMode")];
            this.blockLight = info.func_74767_n("blocklight");
            this.shieldColor = info.func_74764_b("shieldColor") ? info.func_74762_e("shieldColor") : 9895880;
            this.readFiltersFromNBT(info);
        }
    }

    private void readFiltersFromNBT(CompoundNBT tagCompound) {
        this.filters.clear();
        ListNBT filterList = tagCompound.func_150295_c("filters", 10);
        for (int i = 0; i < filterList.size(); ++i) {
            CompoundNBT compound = filterList.func_150305_b(i);
            this.filters.add(AbstractShieldFilter.createFilter(compound));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("composed", this.shieldComposed);
        tagCompound.func_74757_a("active", this.shieldActive);
        tagCompound.func_74768_a("powerTimeout", this.powerTimeout);
        if (this.templateState.func_185904_a() != Material.field_151579_a) {
            tagCompound.func_74768_a("templateColor", ((ShieldTemplateBlock)this.templateState.func_177230_c()).getColor().ordinal());
        }
        byte[] blocks = new byte[this.shieldBlocks.size() * 8];
        int j = 0;
        for (RelCoordinateShield c : this.shieldBlocks) {
            blocks[j + 0] = ShieldProjectorTileEntity.shortToByte1((short)c.getDx());
            blocks[j + 1] = ShieldProjectorTileEntity.shortToByte2((short)c.getDx());
            blocks[j + 2] = ShieldProjectorTileEntity.shortToByte1((short)c.getDy());
            blocks[j + 3] = ShieldProjectorTileEntity.shortToByte2((short)c.getDy());
            blocks[j + 4] = ShieldProjectorTileEntity.shortToByte1((short)c.getDz());
            blocks[j + 5] = ShieldProjectorTileEntity.shortToByte2((short)c.getDz());
            blocks[j + 6] = ShieldProjectorTileEntity.shortToByte1((short)c.getState());
            blocks[j + 7] = ShieldProjectorTileEntity.shortToByte2((short)c.getState());
            j += 8;
        }
        tagCompound.func_74773_a("relcoordsNew", blocks);
        ListNBT list = new ListNBT();
        for (BlockState state : this.blockStateTable) {
            CompoundNBT tc = new CompoundNBT();
            tc.func_74778_a("b", state.func_177230_c().getRegistryName().toString());
            list.add((Object)tc);
        }
        tagCompound.func_218657_a("gstates", (INBT)list);
        return tagCompound;
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("visMode", this.shieldRenderingMode.ordinal());
        info.func_74768_a("shieldTexture", this.shieldTexture.ordinal());
        info.func_74774_a("damageMode", (byte)this.damageMode.ordinal());
        info.func_74757_a("blocklight", this.blockLight);
        info.func_74768_a("shieldColor", this.shieldColor);
        this.writeFiltersToNBT(info);
    }

    private void writeFiltersToNBT(CompoundNBT tagCompound) {
        ListNBT filterList = new ListNBT();
        for (ShieldFilter filter : this.filters) {
            CompoundNBT compound = new CompoundNBT();
            filter.writeToNBT(compound);
            filterList.add((Object)compound);
        }
        tagCompound.func_218657_a("filters", (INBT)filterList);
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_ADDFILTER.equals(command)) {
            int action = (Integer)params.get(PARAM_ACTION);
            String type = (String)params.get(PARAM_TYPE);
            String player = (String)params.get(PARAM_PLAYER);
            int selected = (Integer)params.get(PARAM_SELECTED);
            this.addFilter(action, type, player, selected);
            return true;
        }
        if (CMD_DELFILTER.equals(command)) {
            int selected = (Integer)params.get(PARAM_SELECTED);
            this.delFilter(selected);
            return true;
        }
        if (CMD_UPFILTER.equals(command)) {
            int selected = (Integer)params.get(PARAM_SELECTED);
            this.upFilter(selected);
            return true;
        }
        if (CMD_DOWNFILTER.equals(command)) {
            int selected = (Integer)params.get(PARAM_SELECTED);
            this.downFilter(selected);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getFilters".equals(command)) {
            return type.convert(this.getFilters());
        }
        return Collections.emptyList();
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if ("getFilters".equals(command)) {
            GuiShield.storeFiltersForClient(Type.create(ShieldFilter.class).convert(list));
            return true;
        }
        return false;
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander(this, (ContainerFactory)CONTAINER_FACTORY.get()){

            protected void onUpdate(int index) {
                super.onUpdate(index);
                if (index == 1 && !this.getStackInSlot(index).func_190926_b()) {
                    ShieldProjectorTileEntity.this.decomposeShield();
                }
            }
        };
    }

    private IPowerInformation createPowerInfo() {
        return new IPowerInformation(){

            public long getEnergyDiffPerTick() {
                return ShieldProjectorTileEntity.this.shieldActive ? (long)ShieldProjectorTileEntity.this.getRfPerTick() : 0L;
            }

            @Nullable
            public String getEnergyUnitName() {
                return "RF";
            }

            public boolean isMachineActive() {
                return ShieldProjectorTileEntity.this.shieldActive;
            }

            public boolean isMachineRunning() {
                return ShieldProjectorTileEntity.this.shieldActive;
            }

            @Nullable
            public String getMachineStatus() {
                return ShieldProjectorTileEntity.this.shieldActive ? "active" : "idle";
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.automationItemHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        if (cap == CapabilityPowerInformation.POWER_INFORMATION_CAPABILITY) {
            return this.powerInfoHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

