/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.block.MachineFrameBlock;
import net.silentchaos512.mechanisms.block.alloysmelter.AlloySmelterBlock;
import net.silentchaos512.mechanisms.block.batterybox.BatteryBoxBlock;
import net.silentchaos512.mechanisms.block.compressor.CompressorBlock;
import net.silentchaos512.mechanisms.block.crusher.CrusherBlock;
import net.silentchaos512.mechanisms.block.dryingrack.DryingRackBlock;
import net.silentchaos512.mechanisms.block.electricfurnace.ElectricFurnaceBlock;
import net.silentchaos512.mechanisms.block.generator.coal.CoalGeneratorBlock;
import net.silentchaos512.mechanisms.block.generator.diesel.DieselGeneratorBlock;
import net.silentchaos512.mechanisms.block.generator.lava.LavaGeneratorBlock;
import net.silentchaos512.mechanisms.block.mixer.MixerBlock;
import net.silentchaos512.mechanisms.block.pipe.PipeBlock;
import net.silentchaos512.mechanisms.block.pump.PumpBlock;
import net.silentchaos512.mechanisms.block.refinery.RefineryBlock;
import net.silentchaos512.mechanisms.block.solidifier.SolidifierBlock;
import net.silentchaos512.mechanisms.block.wire.WireBlock;
import net.silentchaos512.mechanisms.init.Metals;
import net.silentchaos512.mechanisms.init.ModFluids;
import net.silentchaos512.mechanisms.init.ModItems;
import net.silentchaos512.mechanisms.init.Ores;
import net.silentchaos512.mechanisms.util.MachineTier;

public final class ModBlocks {
    public static final List<DryingRackBlock> DRYING_RACKS = new ArrayList<DryingRackBlock>();
    public static MachineFrameBlock stoneMachineFrame;
    public static MachineFrameBlock alloyMachineFrame;
    public static AlloySmelterBlock basicAlloySmelter;
    public static AlloySmelterBlock alloySmelter;
    public static CrusherBlock basicCrusher;
    public static CrusherBlock crusher;
    public static CompressorBlock compressor;
    public static ElectricFurnaceBlock electricFurnace;
    public static RefineryBlock refinery;
    public static MixerBlock mixer;
    public static SolidifierBlock solidifier;
    public static Block pump;
    public static CoalGeneratorBlock coalGenerator;
    public static LavaGeneratorBlock lavaGenerator;
    public static DieselGeneratorBlock dieselGenerator;
    public static BatteryBoxBlock batteryBox;
    public static WireBlock wire;
    public static PipeBlock pipe;
    public static FlowingFluidBlock oil;
    public static FlowingFluidBlock diesel;

    private ModBlocks() {
    }

    public static void registerAll(RegistryEvent.Register<Block> event) {
        Arrays.stream(Ores.values()).forEach(ore -> ModBlocks.register(ore.getName() + "_ore", ore.getBlock()));
        Arrays.stream(Metals.values()).forEach(metal -> ModBlocks.register(metal.getName() + "_block", metal.asBlock()));
        DRYING_RACKS.add(ModBlocks.register("oak_drying_rack", new DryingRackBlock()));
        DRYING_RACKS.add(ModBlocks.register("birch_drying_rack", new DryingRackBlock()));
        DRYING_RACKS.add(ModBlocks.register("spruce_drying_rack", new DryingRackBlock()));
        DRYING_RACKS.add(ModBlocks.register("jungle_drying_rack", new DryingRackBlock()));
        DRYING_RACKS.add(ModBlocks.register("dark_oak_drying_rack", new DryingRackBlock()));
        DRYING_RACKS.add(ModBlocks.register("acacia_drying_rack", new DryingRackBlock()));
        stoneMachineFrame = ModBlocks.register("stone_machine_frame", new MachineFrameBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 10.0f).func_200947_a(SoundType.field_185851_d).func_226896_b_()));
        alloyMachineFrame = ModBlocks.register("alloy_machine_frame", new MachineFrameBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.0f, 10.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_()));
        basicAlloySmelter = ModBlocks.register("basic_alloy_smelter", new AlloySmelterBlock(MachineTier.BASIC));
        alloySmelter = ModBlocks.register("alloy_smelter", new AlloySmelterBlock(MachineTier.STANDARD));
        basicCrusher = ModBlocks.register("basic_crusher", new CrusherBlock(MachineTier.BASIC));
        crusher = ModBlocks.register("crusher", new CrusherBlock(MachineTier.STANDARD));
        compressor = ModBlocks.register("compressor", new CompressorBlock());
        electricFurnace = ModBlocks.register("electric_furnace", new ElectricFurnaceBlock());
        refinery = ModBlocks.register("refinery", new RefineryBlock());
        mixer = ModBlocks.register("mixer", new MixerBlock());
        solidifier = ModBlocks.register("solidifier", new SolidifierBlock());
        pump = ModBlocks.register("pump", new PumpBlock());
        coalGenerator = ModBlocks.register("coal_generator", new CoalGeneratorBlock());
        lavaGenerator = ModBlocks.register("lava_generator", new LavaGeneratorBlock());
        dieselGenerator = ModBlocks.register("diesel_generator", new DieselGeneratorBlock());
        batteryBox = ModBlocks.register("battery_box", new BatteryBoxBlock());
        wire = ModBlocks.register("wire", new WireBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200948_a(1.0f, 5.0f)));
        pipe = ModBlocks.register("pipe", new PipeBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200948_a(1.0f, 5.0f)));
        oil = ModBlocks.register("oil", ModBlocks.createFluidBlock(() -> ModFluids.OIL), null);
        diesel = ModBlocks.register("diesel", ModBlocks.createFluidBlock(() -> ModFluids.DIESEL), null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderTypes(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)stoneMachineFrame, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)alloyMachineFrame, (RenderType)RenderType.func_228643_e_());
    }

    private static <T extends Block> T register(String name, T block) {
        BlockItem item = new BlockItem(block, new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP));
        return ModBlocks.register(name, block, item);
    }

    private static <T extends Block> T register(String name, T block, @Nullable BlockItem item) {
        ResourceLocation id = SilentMechanisms.getId(name);
        block.setRegistryName(id);
        ForgeRegistries.BLOCKS.register(block);
        if (item != null) {
            ModItems.BLOCKS_TO_REGISTER.put(name, item);
        }
        return block;
    }

    private static FlowingFluidBlock createFluidBlock(Supplier<FlowingFluid> fluid) {
        return new FlowingFluidBlock(fluid, Block.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e());
    }

    @Nullable
    public static ITextComponent checkForMissingLootTables(PlayerEntity player) {
        if (!(player.field_70170_p instanceof ServerWorld) || !SilentMechanisms.isDevBuild()) {
            return null;
        }
        LootTableManager lootTableManager = ((ServerWorld)player.field_70170_p).func_73046_m().func_200249_aQ();
        ArrayList<String> missing = new ArrayList<String>();
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            ResourceLocation lootTable = block.func_220068_i();
            if (!lootTable.func_110624_b().equals("silents_mechanisms") || block instanceof AirBlock || lootTableManager.func_215304_a().contains(lootTable)) continue;
            SilentMechanisms.LOGGER.error("Missing block loot table '{}' for {}", (Object)lootTable, (Object)block.getRegistryName());
            missing.add(lootTable.toString());
        }
        if (!missing.isEmpty()) {
            String list = String.join((CharSequence)", ", missing);
            return new StringTextComponent("The following block loot tables are missing: " + list).func_211708_a(TextFormatting.RED);
        }
        return null;
    }
}

