/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.mechanisms.block.AbstractMachineTileEntity;
import net.silentchaos512.mechanisms.item.MachineUpgrades;
import net.silentchaos512.mechanisms.util.Constants;
import net.silentchaos512.utils.MathUtils;

public class CrushingRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<CrushingRecipe> RECIPE_TYPE = new IRecipeType<CrushingRecipe>(){

        public String toString() {
            return Constants.CRUSHING.toString();
        }
    };
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation recipeId;
    private int processTime;
    private Ingredient ingredient;
    private final Map<ItemStack, Float> results = new LinkedHashMap<ItemStack, Float>();

    public CrushingRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<ItemStack> getResults(IInventory inv) {
        int outputUpgrades = inv instanceof AbstractMachineTileEntity ? ((AbstractMachineTileEntity)inv).getUpgradeCount(MachineUpgrades.OUTPUT_CHANCE) : 0;
        return this.results.entrySet().stream().filter(e -> {
            float chance = ((Float)e.getValue()).floatValue() + (float)outputUpgrades * 0.1f;
            return MathUtils.tryPercentage((double)chance);
        }).map(e -> ((ItemStack)e.getKey()).func_77946_l()).collect(Collectors.toList());
    }

    public Set<ItemStack> getPossibleResults(IInventory inv) {
        return this.results.keySet();
    }

    public List<Pair<ItemStack, Float>> getPossibleResultsWithChances() {
        return this.results.entrySet().stream().map(e -> new Pair(e.getKey(), e.getValue())).collect(Collectors.toList());
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.ingredient.test(inv.func_70301_a(0));
    }

    @Deprecated
    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return !this.results.isEmpty() ? this.results.keySet().iterator().next() : ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return RECIPE_TYPE;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CrushingRecipe> {
        public CrushingRecipe read(ResourceLocation recipeId, JsonObject json) {
            CrushingRecipe recipe = new CrushingRecipe(recipeId);
            recipe.processTime = JSONUtils.func_151208_a((JsonObject)json, (String)"process_time", (int)400);
            recipe.ingredient = Ingredient.func_199802_a((JsonElement)json.get("ingredient"));
            JsonArray resultsArray = json.getAsJsonArray("results");
            for (JsonElement element : resultsArray) {
                JsonObject obj = element.getAsJsonObject();
                String itemId = JSONUtils.func_151200_h((JsonObject)obj, (String)"item");
                Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)itemId));
                int count = JSONUtils.func_151208_a((JsonObject)obj, (String)"count", (int)1);
                ItemStack stack = new ItemStack((IItemProvider)item, count);
                float chance = JSONUtils.func_151221_a((JsonObject)obj, (String)"chance", (float)1.0f);
                recipe.results.put(stack, Float.valueOf(chance));
            }
            return recipe;
        }

        public CrushingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            CrushingRecipe recipe = new CrushingRecipe(recipeId);
            recipe.processTime = buffer.func_150792_a();
            recipe.ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int resultCount = buffer.readByte();
            for (int i = 0; i < resultCount; ++i) {
                ResourceLocation itemId = buffer.func_192575_l();
                int count = buffer.func_150792_a();
                float chance = buffer.readFloat();
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
                recipe.results.put(new ItemStack((IItemProvider)item, count), Float.valueOf(chance));
            }
            return recipe;
        }

        public void write(PacketBuffer buffer, CrushingRecipe recipe) {
            buffer.func_150787_b(recipe.processTime);
            recipe.ingredient.func_199564_a(buffer);
            buffer.writeByte(recipe.results.size());
            recipe.results.forEach((stack, chance) -> {
                buffer.func_192572_a(Objects.requireNonNull(stack.func_77973_b().getRegistryName()));
                buffer.func_150787_b(stack.func_190916_E());
                buffer.writeFloat(chance.floatValue());
            });
        }
    }
}

