/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.controller;

import com.yogpc.qp.machines.base.IHandleButton;
import com.yogpc.qp.machines.controller.GuiSlotEntities;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.controller.SetEntity;
import com.yogpc.qp.utils.Holder;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiController
extends Screen
implements IHandleButton {
    private GuiSlotEntities slot;
    private TextFieldWidget search;
    List<ResourceLocation> names;
    @Nonnull
    private final List<ResourceLocation> allEntities;
    final int dim;
    final int xc;
    final int yc;
    final int zc;

    public GuiController(int d, int x, int y, int z, List<ResourceLocation> allEntities) {
        super((ITextComponent)new TranslationTextComponent(Holder.blockController().func_149739_a(), new Object[0]));
        this.dim = d;
        this.xc = x;
        this.yc = y;
        this.zc = z;
        this.allEntities = allEntities;
        this.names = allEntities.stream().sorted(Comparator.comparing(ResourceLocation::func_110624_b)).collect(Collectors.toList());
    }

    public void init() {
        super.init();
        this.slot = new GuiSlotEntities(this.minecraft, this.width, this.height, 30, this.height - 60, 18, this);
        this.children.add(this.slot);
        this.addButton((Widget)new IHandleButton.Button(-1, this.width / 2 - 125, this.height - 26, 250, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), this));
        this.setFocused((IGuiEventListener)this.slot);
        this.search = new TextFieldWidget(this.font, this.width / 2 - 125, this.height - 56, 250, 20, "");
        this.children.add(this.search);
        this.search.func_146205_d(true);
        this.search.func_212954_a(this::searchEntities);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.slot != null) {
            this.slot.render(mouseX, mouseY, partialTicks);
            this.search.render(mouseX, mouseY, partialTicks);
        }
        super.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"yog.spanwer.setting", (Object[])new Object[0]), this.width / 2, 8, 0xFFFFFF);
    }

    public void tick() {
        super.tick();
        if (!this.getMinecraft().field_71439_g.func_70089_S()) {
            this.getMinecraft().field_71439_g.func_71053_j();
        }
    }

    public boolean keyPressed(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (keyCode == 256 || !this.search.isFocused() && keyCode == this.getMinecraft().field_71474_y.field_151445_Q.getKey().func_197937_c()) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    public void actionPerformed(IHandleButton.Button button) {
        if (button.id == -1) {
            GuiSlotEntities.Entry selected = (GuiSlotEntities.Entry)this.slot.getSelected();
            if (selected != null) {
                PacketHandler.sendToServer(SetEntity.create(this.dim, new BlockPos(this.xc, this.yc, this.zc), selected.location));
            }
            this.getMinecraft().field_71439_g.func_71053_j();
        }
    }

    public void buildModList(Consumer<GuiSlotEntities.Entry> modListViewConsumer, Function<ResourceLocation, GuiSlotEntities.Entry> newEntry) {
        this.names.stream().map(newEntry).forEach(modListViewConsumer);
    }

    public void searchEntities(String text) {
        List collect;
        if (!text.isEmpty()) {
            try {
                Pattern pattern = Pattern.compile(text);
                collect = this.allEntities.stream().filter(l -> pattern.matcher(l.toString()).find()).sorted(Comparator.comparing(ResourceLocation::func_110624_b)).collect(Collectors.toList());
            }
            catch (PatternSyntaxException e) {
                collect = this.allEntities.stream().filter(l -> l.toString().contains(text)).sorted(Comparator.comparing(ResourceLocation::func_110624_b)).collect(Collectors.toList());
            }
        } else {
            collect = this.allEntities.stream().sorted(Comparator.comparing(ResourceLocation::func_110624_b)).collect(Collectors.toList());
        }
        this.names = collect;
        this.slot.refreshList();
        this.slot.setSelected(null);
    }
}

