/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.capability;

import com.direwolf20.buildinggadgets.common.items.pastes.ConstructionPasteContainerCreative;
import com.direwolf20.buildinggadgets.common.items.pastes.GenericPasteContainer;
import com.direwolf20.buildinggadgets.common.registry.OurItems;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandlerModifiable;

public final class PasteContainerItemHandler
implements IItemHandlerModifiable {
    private final ItemStack container;
    private boolean isCreative;

    public PasteContainerItemHandler(ItemStack container) {
        this.container = container;
        this.isCreative = this.getContainerItem() instanceof ConstructionPasteContainerCreative;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.setCount(stack.func_190916_E(), false);
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int count = this.getCount();
        return count <= 0 ? ItemStack.field_190927_a : new ItemStack((IItemProvider)OurItems.constructionPaste, count);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b() || !this.isItemValid(slot, stack)) {
            return stack;
        }
        if (this.isCreative) {
            return ItemStack.field_190927_a;
        }
        int currentCount = this.getCount();
        int newCount = this.setCount(currentCount + stack.func_190916_E(), simulate);
        int dif = newCount - currentCount;
        if (dif == 0) {
            return stack;
        }
        stack = stack.func_77946_l();
        stack.func_190920_e(stack.func_190916_E() - dif);
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int newCount;
        if (amount <= 0) {
            return ItemStack.field_190927_a;
        }
        if (this.isCreative) {
            return new ItemStack((IItemProvider)OurItems.constructionPaste, amount);
        }
        int currentCount = this.getCount();
        int dif = currentCount - (newCount = this.setCount(currentCount - amount, simulate));
        if (dif == 0) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)OurItems.constructionPaste, dif);
    }

    public int getSlotLimit(int slot) {
        return this.getContainerItem().getMaxCapacity();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.func_77973_b() == OurItems.constructionPaste;
    }

    private int getCount() {
        return this.getContainerItem().getPasteCount(this.container);
    }

    private GenericPasteContainer getContainerItem() {
        return (GenericPasteContainer)this.container.func_77973_b();
    }

    private int setCount(int count, boolean simulate) {
        int res = MathHelper.func_76125_a((int)count, (int)0, (int)this.getContainerItem().getMaxCapacity());
        if (!simulate) {
            this.getContainerItem().setPasteCount(this.container, res);
        }
        return res;
    }
}

