/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client;

import com.direwolf20.buildinggadgets.client.KeyBindings;
import com.direwolf20.buildinggadgets.client.cache.CacheTemplateProvider;
import com.direwolf20.buildinggadgets.client.events.EventTooltip;
import com.direwolf20.buildinggadgets.client.models.ConstructionBakedModel;
import com.direwolf20.buildinggadgets.common.registry.OurBlocks;
import com.direwolf20.buildinggadgets.common.registry.Registries;
import com.direwolf20.buildinggadgets.common.tiles.ConstructionBlockTileEntity;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class ClientProxy {
    public static final CacheTemplateProvider CACHE_TEMPLATE_PROVIDER = new CacheTemplateProvider();

    public static void clientSetup(IEventBus eventBus) {
        KeyBindings.init();
        eventBus.addListener(ClientProxy::bakeModels);
        eventBus.addListener(ClientProxy::registerSprites);
        MinecraftForge.EVENT_BUS.addListener(EventTooltip::onDrawTooltip);
        MinecraftForge.EVENT_BUS.addListener(ClientProxy::onPlayerLoggedOut);
        Registries.clientSetup();
        RenderTypeLookup.setRenderLayer((Block)OurBlocks.constructionBlock, RenderType2 -> true);
    }

    private static void registerSprites(TextureStitchEvent.Pre event) {
        event.addSprite(new ResourceLocation("buildinggadgets:gui/slot_copy_paste_gadget"));
        event.addSprite(new ResourceLocation("buildinggadgets:gui/slot_template"));
    }

    public static void playSound(SoundEvent sound, float pitch) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)sound, (float)pitch));
    }

    private static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        CACHE_TEMPLATE_PROVIDER.clear();
    }

    private static void bakeModels(ModelBakeEvent event) {
        ResourceLocation ConstrName = new ResourceLocation("buildinggadgets", "construction_block");
        final TextureAtlasSprite breakPart = Minecraft.func_71410_x().func_175602_ab().func_184389_a(Blocks.field_150348_b.func_176223_P()).func_177554_e();
        ModelResourceLocation ConstrLocation1 = new ModelResourceLocation(ConstrName, "ambient_occlusion=false,bright=false,neighbor_brightness=false");
        ModelResourceLocation ConstrLocation1a = new ModelResourceLocation(ConstrName, "ambient_occlusion=true,bright=false,neighbor_brightness=false");
        ModelResourceLocation ConstrLocation2 = new ModelResourceLocation(ConstrName, "ambient_occlusion=false,bright=true,neighbor_brightness=false");
        ModelResourceLocation ConstrLocation2a = new ModelResourceLocation(ConstrName, "ambient_occlusion=true,bright=true,neighbor_brightness=false");
        ModelResourceLocation ConstrLocation3 = new ModelResourceLocation(ConstrName, "ambient_occlusion=false,bright=false,neighbor_brightness=true");
        ModelResourceLocation ConstrLocation3a = new ModelResourceLocation(ConstrName, "ambient_occlusion=true,bright=false,neighbor_brightness=true");
        ModelResourceLocation ConstrLocation4 = new ModelResourceLocation(ConstrName, "ambient_occlusion=false,bright=true,neighbor_brightness=true");
        ModelResourceLocation ConstrLocation4a = new ModelResourceLocation(ConstrName, "ambient_occlusion=true,bright=true,neighbor_brightness=true");
        ConstructionBakedModel constructionBakedModel = new ConstructionBakedModel();
        IDynamicBakedModel bakedModelLoader = new IDynamicBakedModel(){
            BlockState facadeState;

            public boolean func_177556_c() {
                return false;
            }

            public boolean func_230044_c_() {
                return false;
            }

            public boolean func_188618_c() {
                return false;
            }

            public boolean func_177555_b() {
                return true;
            }

            public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
                this.facadeState = (BlockState)modelData.getData(ConstructionBlockTileEntity.FACADE_STATE);
                RenderType layer = MinecraftForgeClient.getRenderLayer();
                if (this.facadeState == null || this.facadeState == Blocks.field_150350_a.func_176223_P()) {
                    this.facadeState = OurBlocks.constructionBlockDense.func_176223_P();
                }
                if (layer != null && !RenderTypeLookup.canRenderInLayer((BlockState)this.facadeState, (RenderType)layer)) {
                    return Collections.emptyList();
                }
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(this.facadeState);
                return model.func_200117_a(this.facadeState, side, rand);
            }

            public TextureAtlasSprite func_177554_e() {
                return breakPart;
            }

            public ItemOverrideList func_188617_f() {
                return null;
            }

            @Nonnull
            public IModelData getModelData(@Nonnull ILightReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
                return tileData;
            }
        };
        IDynamicBakedModel bakedModelLoaderAmbient = new IDynamicBakedModel(){
            BlockState facadeState;

            public boolean func_177556_c() {
                return false;
            }

            public boolean func_230044_c_() {
                return false;
            }

            public boolean func_188618_c() {
                return false;
            }

            public boolean func_177555_b() {
                return true;
            }

            public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
                this.facadeState = (BlockState)modelData.getData(ConstructionBlockTileEntity.FACADE_STATE);
                RenderType layer = MinecraftForgeClient.getRenderLayer();
                if (this.facadeState == null || this.facadeState == Blocks.field_150350_a.func_176223_P()) {
                    this.facadeState = OurBlocks.constructionBlockDense.func_176223_P();
                }
                if (layer != null && !RenderTypeLookup.canRenderInLayer((BlockState)this.facadeState, (RenderType)layer)) {
                    return Collections.emptyList();
                }
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(this.facadeState);
                return model.func_200117_a(this.facadeState, side, rand);
            }

            public TextureAtlasSprite func_177554_e() {
                return breakPart;
            }

            public ItemOverrideList func_188617_f() {
                return null;
            }

            @Nonnull
            public IModelData getModelData(@Nonnull ILightReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
                return tileData;
            }
        };
        event.getModelRegistry().put(ConstrLocation1, bakedModelLoader);
        event.getModelRegistry().put(ConstrLocation2, bakedModelLoader);
        event.getModelRegistry().put(ConstrLocation3, bakedModelLoader);
        event.getModelRegistry().put(ConstrLocation4, bakedModelLoader);
        event.getModelRegistry().put(ConstrLocation1a, bakedModelLoaderAmbient);
        event.getModelRegistry().put(ConstrLocation2a, bakedModelLoaderAmbient);
        event.getModelRegistry().put(ConstrLocation3a, bakedModelLoaderAmbient);
        event.getModelRegistry().put(ConstrLocation4a, bakedModelLoaderAmbient);
    }
}

