/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.function.Supplier;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.Parameter;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTypeTools;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketVariableToServer {
    private BlockPos pos;
    private int varIndex;
    private CompoundNBT tagCompound;

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.varIndex);
        buf.func_150786_a(this.tagCompound);
    }

    public PacketVariableToServer() {
    }

    public PacketVariableToServer(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.varIndex = buf.readInt();
        this.tagCompound = buf.func_150793_b();
    }

    public PacketVariableToServer(BlockPos pos, int varIndex, CompoundNBT tagCompound) {
        this.pos = pos;
        this.varIndex = varIndex;
        this.tagCompound = tagCompound;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ProcessorTileEntity processor;
            Parameter[] variables;
            ServerPlayerEntity playerEntity = ctx.getSender();
            TileEntity te = playerEntity.func_130014_f_().func_175625_s(this.pos);
            if (te instanceof ProcessorTileEntity && this.varIndex < (variables = (processor = (ProcessorTileEntity)te).getVariableArray()).length) {
                Parameter parameter = variables[this.varIndex];
                ParameterType type = parameter.getParameterType();
                ParameterValue value = ParameterTypeTools.readFromNBT(this.tagCompound, type);
                variables[this.varIndex] = Parameter.builder().type(type).value(value).build();
                processor.func_70296_d();
            }
        });
        ctx.setPacketHandled(true);
    }
}

