/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.network;

import java.util.function.Supplier;
import mcjty.lib.McJtyLib;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageTileEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketStorageInfoToClient {
    private BlockPos pos;
    private String viewMode;
    private String sortMode;
    private boolean groupMode;
    private String filter;

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.viewMode);
        buf.func_180714_a(this.sortMode);
        buf.writeBoolean(this.groupMode);
        buf.func_180714_a(this.filter);
    }

    public PacketStorageInfoToClient() {
    }

    public PacketStorageInfoToClient(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.viewMode = buf.func_150789_c(Short.MAX_VALUE);
        this.sortMode = buf.func_150789_c(Short.MAX_VALUE);
        this.groupMode = buf.readBoolean();
        this.filter = buf.func_150789_c(Short.MAX_VALUE);
    }

    public PacketStorageInfoToClient(BlockPos pos, String sortMode, String viewMode, boolean groupMode, String filter) {
        this.sortMode = sortMode;
        this.viewMode = viewMode;
        this.groupMode = groupMode;
        this.filter = filter;
        this.pos = pos;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = McJtyLib.proxy.getClientWorld().func_175625_s(this.pos);
            if (te instanceof ModularStorageTileEntity) {
                ModularStorageTileEntity storage = (ModularStorageTileEntity)te;
                storage.syncInventoryFromServer(this.sortMode, this.viewMode, this.groupMode, this.filter);
            }
        });
        ctx.setPacketHandled(true);
    }
}

