/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator.library;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ipsis.woot.Woot;
import ipsis.woot.policy.PolicyRegistry;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.simulator.library.SimulatedMobDrop;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.helper.MathHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;

public class SimulatedMob {
    private FakeMob fakeMob;
    private int[] simulatedKills;
    private List<SimulatedMobDrop> simulatedMobDrops;
    private static final String TAG_MOB = "mob";
    private static final String TAG_SIM_KILLS = "simulatedKills";
    private static final String TAG_DROPS = "learnedDrops";

    private SimulatedMob() {
    }

    public SimulatedMob(FakeMob fakeMob) {
        this.fakeMob = fakeMob;
        this.simulatedKills = new int[]{0, 0, 0, 0};
        this.simulatedMobDrops = new ArrayList<SimulatedMobDrop>();
    }

    public FakeMob getFakeMob() {
        return this.fakeMob;
    }

    @Nonnull
    private SimulatedMobDrop getOrCreateSimulatedMobDrop(@Nonnull ItemStack itemStack) {
        SimulatedMobDrop simulatedMobDrop = null;
        for (SimulatedMobDrop d : this.simulatedMobDrops) {
            if (!MobSimulator.getInstance().isEqualForLearning(itemStack, d.itemStack)) continue;
            simulatedMobDrop = d;
            break;
        }
        return simulatedMobDrop == null ? new SimulatedMobDrop(itemStack, this) : simulatedMobDrop;
    }

    public void incrementSimulatedKills(int looting) {
        int n = looting = MathHelper.clampLooting(looting);
        this.simulatedKills[n] = this.simulatedKills[n] + 1;
    }

    public int getSimulatedKills(int looting) {
        return this.simulatedKills[MathHelper.clampLooting(looting)];
    }

    public void addSimulatedDrop(int looting, ItemStack itemStack) {
        if (itemStack.func_190926_b() || itemStack.func_190916_E() == 0) {
            return;
        }
        if (!PolicyRegistry.get().canLearnItem(itemStack.func_77973_b().getRegistryName())) {
            return;
        }
        SimulatedMobDrop simulatedMobDrop = this.getOrCreateSimulatedMobDrop(itemStack);
        if (!this.simulatedMobDrops.contains(simulatedMobDrop)) {
            this.simulatedMobDrops.add(simulatedMobDrop);
        }
        simulatedMobDrop.addSimulatedData(looting, itemStack.func_190916_E());
    }

    public void addCustomDrop(int looting, @Nonnull ItemStack itemStack, float dropChance, HashMap<Integer, Integer> stackSizes) {
        if (itemStack.func_190926_b()) {
            return;
        }
        SimulatedMobDrop simulatedMobDrop = this.getOrCreateSimulatedMobDrop(itemStack);
        if (!this.simulatedMobDrops.contains(simulatedMobDrop)) {
            this.simulatedMobDrops.add(simulatedMobDrop);
        }
        simulatedMobDrop.addCustomDrop(looting, dropChance, stackSizes);
    }

    @Nonnull
    public List<SimulatedMobDropSummary> getDropSummary() {
        ArrayList<SimulatedMobDropSummary> drops = new ArrayList<SimulatedMobDropSummary>();
        this.simulatedMobDrops.forEach(d -> drops.add(d.createSummary()));
        return drops;
    }

    @Nonnull
    public List<ItemStack> getRolledDrops(int looting) {
        Woot.setup.getLogger().debug("getRolledDrop: *** looting {}:{}", (Object)looting, (Object)this.fakeMob);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        looting = MathHelper.clampLooting(looting);
        for (SimulatedMobDrop drop : this.simulatedMobDrops) {
            ItemStack itemStack = drop.getRolledDrop(looting);
            if (itemStack.func_190926_b()) continue;
            drops.add(itemStack);
        }
        return drops;
    }

    public JsonObject toJson(FakeMob fakeMob) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(TAG_MOB, fakeMob.toString());
        JsonArray simKillsArray = new JsonArray();
        for (int i = 0; i < 4; ++i) {
            simKillsArray.add((Number)this.simulatedKills[i]);
        }
        jsonObject.add(TAG_SIM_KILLS, (JsonElement)simKillsArray);
        JsonArray dropsArray = new JsonArray();
        this.simulatedMobDrops.forEach(d -> dropsArray.add((JsonElement)d.toJson()));
        jsonObject.add(TAG_DROPS, (JsonElement)dropsArray);
        return jsonObject;
    }

    @Nullable
    public static SimulatedMob fromJson(JsonObject jsonObject) {
        String mob = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)TAG_MOB);
        FakeMob fakeMob = new FakeMob(mob);
        if (!fakeMob.isValid()) {
            Woot.setup.getLogger().info("SimulatedMob:fromJson invalid mob {}", (Object)mob);
            return null;
        }
        if (!FakeMob.isInEntityList(fakeMob)) {
            Woot.setup.getLogger().info("SimulatedMob:fromJson mob not in entity list {}", (Object)mob);
            return null;
        }
        JsonArray killsArray = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)TAG_SIM_KILLS);
        if (killsArray.size() != 4) {
            throw new JsonSyntaxException("Simulated kills array must be of size 4");
        }
        SimulatedMob simulatedMob = new SimulatedMob(fakeMob);
        for (int i = 0; i < 4; ++i) {
            simulatedMob.simulatedKills[i] = killsArray.get(i).getAsInt();
        }
        for (JsonElement jsonElement : JSONUtils.func_151214_t((JsonObject)jsonObject, (String)TAG_DROPS)) {
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                throw new JsonSyntaxException("Simulated drop must be an object");
            }
            SimulatedMobDrop simulatedMobDrop = SimulatedMobDrop.fromJson(simulatedMob, (JsonObject)jsonElement);
            if (simulatedMobDrop == null) continue;
            simulatedMob.simulatedMobDrops.add(simulatedMobDrop);
        }
        return simulatedMob;
    }
}

