/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator.library;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ipsis.woot.policy.PolicyRegistry;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.simulator.library.SimulatedMob;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.FakeMobKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;

public class LootLibrary {
    private Map<FakeMob, SimulatedMob> mobs = new HashMap<FakeMob, SimulatedMob>();
    private static final int JSON_VERSION = 1;
    private static final String TAG_VERSION = "version";
    private static final String TAG_SIMULATED_MOBS = "simulatedMobs";

    @Nonnull
    private SimulatedMob getOrCreateSimulatedMob(@Nonnull FakeMob fakeMob) {
        if (!this.mobs.containsKey(fakeMob)) {
            this.mobs.put(fakeMob, new SimulatedMob(fakeMob));
        }
        return this.mobs.get(fakeMob);
    }

    public void learnSimulatedDrops(@Nonnull FakeMobKey fakeMobKey, @Nonnull List<ItemStack> drops) {
        SimulatedMob simulatedMob = this.getOrCreateSimulatedMob(fakeMobKey.getMob());
        simulatedMob.incrementSimulatedKills(fakeMobKey.getLooting());
        this.learnSimulatedDropsSilent(fakeMobKey, drops);
    }

    public void learnSimulatedDropsSilent(@Nonnull FakeMobKey fakeMobKey, @Nonnull List<ItemStack> drops) {
        SimulatedMob simulatedMob = this.getOrCreateSimulatedMob(fakeMobKey.getMob());
        drops.forEach(d -> simulatedMob.addSimulatedDrop(fakeMobKey.getLooting(), (ItemStack)d));
    }

    public void learnCustomDrop(@Nonnull FakeMobKey fakeMobKey, @Nonnull ItemStack drop, float dropChance, HashMap<Integer, Integer> stackSizes) {
        SimulatedMob simulatedMob = this.getOrCreateSimulatedMob(fakeMobKey.getMob());
        simulatedMob.addCustomDrop(fakeMobKey.getLooting(), drop, dropChance, stackSizes);
    }

    public int getSimulatedKills(@Nonnull FakeMobKey fakeMobKey) {
        int count = 0;
        SimulatedMob simulatedMob = this.mobs.get(fakeMobKey.getMob());
        if (simulatedMob != null) {
            count = simulatedMob.getSimulatedKills(fakeMobKey.getLooting());
        }
        return count;
    }

    public void flush(@Nonnull FakeMob fakeMob) {
        this.mobs.remove(fakeMob);
    }

    @Nonnull
    public List<SimulatedMobDropSummary> getDropSummary(@Nonnull FakeMob fakeMob) {
        List<SimulatedMobDropSummary> drops = new ArrayList<SimulatedMobDropSummary>();
        SimulatedMob simulatedMob = this.mobs.get(fakeMob);
        if (simulatedMob != null) {
            drops = simulatedMob.getDropSummary();
        }
        return drops;
    }

    @Nonnull
    public Set<FakeMob> getKnownMobs() {
        return this.mobs.keySet();
    }

    @Nonnull
    public List<ItemStack> getRolledDrops(@Nonnull FakeMobKey fakeMobKey) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        SimulatedMob simulatedMob = this.mobs.get(fakeMobKey.getMob());
        if (simulatedMob != null) {
            drops.addAll(simulatedMob.getRolledDrops(fakeMobKey.getLooting()));
        }
        return drops;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(TAG_VERSION, (Number)1);
        JsonArray mobsArray = new JsonArray();
        for (Map.Entry<FakeMob, SimulatedMob> entry : this.mobs.entrySet()) {
            FakeMob fakeMob = entry.getKey();
            SimulatedMob simulatedMob = entry.getValue();
            if (!fakeMob.isValid() || !PolicyRegistry.get().canSimulate(fakeMob.getResourceLocation())) continue;
            mobsArray.add((JsonElement)simulatedMob.toJson(fakeMob));
        }
        jsonObject.add(TAG_SIMULATED_MOBS, (JsonElement)mobsArray);
        return jsonObject;
    }

    public void fromJson(JsonObject jsonObject) {
        if (jsonObject == null || jsonObject.isJsonNull()) {
            throw new JsonSyntaxException("JsonObject cannot be null");
        }
        if (JSONUtils.func_151208_a((JsonObject)jsonObject, (String)TAG_VERSION, (int)0) != 1) {
            throw new JsonSyntaxException("Loot file version missing or invalid");
        }
        for (JsonElement jsonElement : JSONUtils.func_151214_t((JsonObject)jsonObject, (String)TAG_SIMULATED_MOBS)) {
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                throw new JsonSyntaxException("Simulated mob must be an object");
            }
            SimulatedMob simulatedMob = SimulatedMob.fromJson((JsonObject)jsonElement);
            if (simulatedMob == null) continue;
            this.mobs.put(simulatedMob.getFakeMob(), simulatedMob);
        }
    }
}

