/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.squeezer.blocks;

import ipsis.woot.modules.debug.items.DebugItem;
import ipsis.woot.modules.squeezer.SqueezerConfiguration;
import ipsis.woot.modules.squeezer.blocks.DyeSqueezerTileEntity;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.helper.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.network.NetworkHooks;

public class DyeSqueezerBlock
extends Block
implements WootDebug {
    public DyeSqueezerBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(3.5f));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208157_J});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new DyeSqueezerTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (!(world.func_175625_s(pos) instanceof DyeSqueezerTileEntity)) {
            throw new IllegalStateException("Tile entity is missing");
        }
        DyeSqueezerTileEntity squeezer = (DyeSqueezerTileEntity)world.func_175625_s(pos);
        ItemStack heldItem = playerEntity.func_184586_b(hand);
        if (FluidUtil.getFluidHandler((ItemStack)heldItem).isPresent()) {
            return FluidUtil.interactWithFluidHandler((PlayerEntity)playerEntity, (Hand)hand, (World)world, (BlockPos)pos, null) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        if (!(squeezer instanceof INamedContainerProvider)) {
            throw new IllegalStateException("Named container provider is missing");
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)squeezer, (BlockPos)squeezer.func_174877_v());
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof DyeSqueezerTileEntity) {
                ((DyeSqueezerTileEntity)te).dropContents(worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> DyeSqueezerBlock");
        DebugItem.getTileEntityDebug(debug, itemUseContext);
        return debug;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT nbt = stack.func_179543_a("BlockEntityTag");
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b("energy")) {
            CompoundNBT nbtEnergy = nbt.func_74775_l("energy");
            tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.energy", new Object[]{nbtEnergy.func_74762_e("energy"), SqueezerConfiguration.DYE_SQUEEZER_MAX_ENERGY.get()}));
        }
        if (nbt.func_74764_b("dye")) {
            CompoundNBT nbtDye = nbt.func_74775_l("dye");
            tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.squeezer.0", new Object[]{nbtDye.func_74762_e("red"), nbtDye.func_74762_e("yellow"), nbtDye.func_74762_e("blue"), nbtDye.func_74762_e("white")}));
        }
        if (nbt.func_74764_b("tank")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("tank"));
            if (!fluidStack.isEmpty()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.output_tank", new Object[]{StringHelper.translate(fluidStack.getTranslationKey()), fluidStack.getAmount(), SqueezerConfiguration.DYE_SQUEEZER_TANK_CAPACITY.get()}));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.output_tank.empty", new Object[]{SqueezerConfiguration.DYE_SQUEEZER_TANK_CAPACITY.get()}));
            }
        }
    }
}

