/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.fluidconvertor.blocks;

import ipsis.woot.crafting.FluidConvertorRecipe;
import ipsis.woot.modules.fluidconvertor.FluidConvertorConfiguration;
import ipsis.woot.modules.fluidconvertor.FluidConvertorSetup;
import ipsis.woot.modules.fluidconvertor.blocks.FluidConvertorContainer;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.WootEnergyStorage;
import ipsis.woot.util.WootFluidTank;
import ipsis.woot.util.WootMachineTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class FluidConvertorTileEntity
extends WootMachineTileEntity
implements WootDebug,
INamedContainerProvider {
    public final IItemHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            FluidConvertorTileEntity.this.onContentsChanged(slot);
            FluidConvertorTileEntity.this.func_70296_d();
        }

        public boolean isItemValidForSlot(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return FluidConvertorRecipe.isValidCatalyst(stack);
            }
            return false;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValidForSlot(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private boolean firstTick = true;
    private LazyOptional<FluidTank> inputTank = LazyOptional.of(this::createInputTank);
    private LazyOptional<WootFluidTank> outputTank = LazyOptional.of(this::createOutputTank);
    private LazyOptional<WootEnergyStorage> energyStorage = LazyOptional.of(this::createEnergy);
    public static final int INPUT_SLOT = 0;
    private final LazyOptional<IItemHandler> inventoryGetter = LazyOptional.of(() -> this.inventory);
    private FluidConvertorRecipe currRecipe = null;

    public FluidConvertorTileEntity() {
        super((TileEntityType)FluidConvertorSetup.FLUID_CONVERTOR_BLOCK_TILE.get());
    }

    public void configureSides() {
        Direction direction = (Direction)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockStateProperties.field_208157_J);
        if (direction == Direction.NORTH) {
            this.settings.put(Direction.UP, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.SOUTH, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.EAST, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.NORTH, WootMachineTileEntity.Mode.INPUT);
        } else if (direction == Direction.SOUTH) {
            this.settings.put(Direction.UP, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.SOUTH, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.EAST, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.NORTH, WootMachineTileEntity.Mode.OUTPUT);
        } else if (direction == Direction.WEST) {
            this.settings.put(Direction.UP, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.SOUTH, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.EAST, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.NORTH, WootMachineTileEntity.Mode.INPUT);
        } else if (direction == Direction.EAST) {
            this.settings.put(Direction.UP, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.DOWN, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.WEST, WootMachineTileEntity.Mode.OUTPUT);
            this.settings.put(Direction.SOUTH, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.EAST, WootMachineTileEntity.Mode.INPUT);
            this.settings.put(Direction.NORTH, WootMachineTileEntity.Mode.OUTPUT);
        }
    }

    @Override
    public void func_73660_a() {
        if (this.firstTick && this.field_145850_b != null) {
            this.configureSides();
            this.firstTick = false;
        }
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (((Boolean)this.outputTank.map(WootFluidTank::isEmpty).orElse((Object)true)).booleanValue()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            LazyOptional lazyOptional;
            TileEntity te;
            if (this.settings.get(direction) != WootMachineTileEntity.Mode.OUTPUT || !((te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction))) instanceof TileEntity) || !(lazyOptional = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d())).isPresent()) continue;
            IFluidHandler iFluidHandler = (IFluidHandler)lazyOptional.orElseThrow(NullPointerException::new);
            FluidStack fluidStack = (FluidStack)this.outputTank.map(WootFluidTank::getFluid).orElse((Object)FluidStack.EMPTY);
            if (fluidStack.isEmpty()) continue;
            int filled = iFluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            this.outputTank.ifPresent(f -> f.internalDrain(filled, IFluidHandler.FluidAction.EXECUTE));
            this.func_70296_d();
        }
    }

    private FluidTank createInputTank() {
        return new FluidTank(((Integer)FluidConvertorConfiguration.FLUID_CONV_INPUT_TANK_CAPACITY.get()).intValue());
    }

    private WootFluidTank createOutputTank() {
        return new WootFluidTank((Integer)FluidConvertorConfiguration.FLUID_CONV_OUTPUT_TANK_CAPACITY.get()).setAccess(false, true);
    }

    public FluidStack getInputTankFluid() {
        return (FluidStack)this.inputTank.map(h -> h.getFluid()).orElse((Object)FluidStack.EMPTY);
    }

    public FluidStack getOutputTankFluid() {
        return (FluidStack)this.outputTank.map(h -> h.getFluid()).orElse((Object)FluidStack.EMPTY);
    }

    private WootEnergyStorage createEnergy() {
        return new WootEnergyStorage((Integer)FluidConvertorConfiguration.FLUID_CONV_MAX_ENERGY.get(), (Integer)FluidConvertorConfiguration.FLUID_CONV_MAX_ENERGY_RX.get());
    }

    public int getEnergy() {
        return (Integer)this.energyStorage.map(h -> h.getEnergyStored()).orElse((Object)0);
    }

    public void setEnergy(int v) {
        this.energyStorage.ifPresent(h -> h.setEnergy(v));
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public void func_145839_a(CompoundNBT compoundNBT) {
        if (compoundNBT.func_150297_b("InputInventory", 9)) {
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inventory, null, (INBT)compoundNBT.func_150295_c("InputInventory", 10));
        }
        CompoundNBT inputTankTag = compoundNBT.func_74775_l("InputTank");
        this.inputTank.ifPresent(h -> h.readFromNBT(inputTankTag));
        CompoundNBT outputTankTag = compoundNBT.func_74775_l("OutputTank");
        this.outputTank.ifPresent(h -> h.readFromNBT(outputTankTag));
        CompoundNBT energyTag = compoundNBT.func_74775_l("Energy");
        this.energyStorage.ifPresent(h -> h.deserializeNBT((INBT)energyTag));
        super.func_145839_a(compoundNBT);
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT.func_218657_a("InputInventory", Objects.requireNonNull(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inventory, null)));
        this.inputTank.ifPresent(h -> {
            CompoundNBT tankTag = h.writeToNBT(new CompoundNBT());
            compoundNBT.func_218657_a("InputTank", (INBT)tankTag);
        });
        this.outputTank.ifPresent(h -> {
            CompoundNBT tankTag = h.writeToNBT(new CompoundNBT());
            compoundNBT.func_218657_a("OutputTank", (INBT)tankTag);
        });
        this.energyStorage.ifPresent(h -> {
            CompoundNBT energyTag = (CompoundNBT)h.serializeNBT();
            compoundNBT.func_218657_a("Energy", (INBT)energyTag);
        });
        return super.func_189515_b(compoundNBT);
    }

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> " + this.getClass().toString());
        debug.add("      Input Tank " + this.getInputTankFluid().getTranslationKey() + " " + this.getInputTankFluid().getAmount());
        debug.add("      Output Tank " + this.getOutputTankFluid().getTranslationKey() + " " + this.getOutputTankFluid().getAmount());
        debug.add("      Energy " + this.getEnergy());
        if (this.currRecipe != null) {
            debug.add("      Energy " + this.currRecipe);
        }
        debug.add("      Settings " + this.settings);
        return debug;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.woot.fluidconvertor.name", new Object[0]);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new FluidConvertorContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public int getProgress() {
        return this.calculateProgress();
    }

    @Override
    protected boolean hasEnergy() {
        return (Boolean)this.energyStorage.map(e -> e.getEnergyStored() > 0).orElse((Object)false);
    }

    @Override
    protected int useEnergy() {
        return (Integer)this.energyStorage.map(e -> e.extractEnergy((Integer)FluidConvertorConfiguration.FLUID_CONV_ENERYG_PER_TICK.get(), false)).orElse((Object)0);
    }

    @Override
    protected void clearRecipe() {
        this.currRecipe = null;
    }

    @Override
    protected int getRecipeEnergy() {
        return this.currRecipe != null ? this.currRecipe.getEnergy() : 0;
    }

    @Override
    protected void processFinish() {
        if (this.currRecipe == null) {
            this.getRecipe();
        }
        if (this.currRecipe == null) {
            this.processOff();
            return;
        }
        FluidConvertorRecipe finishedRecipe = this.currRecipe;
        this.inventory.extractItem(0, finishedRecipe.getCatalystCount(), false);
        this.inputTank.ifPresent(f -> f.drain(finishedRecipe.getInputFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE));
        this.outputTank.ifPresent(f -> f.internalFill(new FluidStack(finishedRecipe.getOutput(), finishedRecipe.getOutput().getAmount()), IFluidHandler.FluidAction.EXECUTE));
        this.func_70296_d();
    }

    @Override
    protected boolean canStart() {
        if (((Boolean)this.energyStorage.map(f -> f.getEnergyStored() <= 0).orElse((Object)true)).booleanValue()) {
            return false;
        }
        if (((Boolean)this.inputTank.map(f -> f.isEmpty()).orElse((Object)true)).booleanValue()) {
            return false;
        }
        this.getRecipe();
        if (this.currRecipe == null) {
            return false;
        }
        if (this.inventory.getStackInSlot(0).func_190916_E() < this.currRecipe.getCatalystCount()) {
            return false;
        }
        FluidStack inFluid = (FluidStack)this.inputTank.map(h -> h.getFluid()).orElse((Object)FluidStack.EMPTY);
        if (inFluid.isEmpty()) {
            return false;
        }
        if (inFluid.getAmount() < this.currRecipe.getInputFluid().getAmount()) {
            return false;
        }
        return (Boolean)this.outputTank.map(h -> {
            int filled;
            int amount = this.currRecipe.getOutput().getAmount();
            return amount == (filled = h.internalFill(new FluidStack(this.currRecipe.getOutput(), amount), IFluidHandler.FluidAction.SIMULATE));
        }).orElse((Object)false) != false;
    }

    @Override
    protected boolean hasValidInput() {
        if (this.currRecipe == null) {
            this.getRecipe();
        }
        if (this.currRecipe == null) {
            return false;
        }
        if (this.inventory.getStackInSlot(0).func_190916_E() < this.currRecipe.getCatalystCount()) {
            return false;
        }
        FluidStack inFluid = (FluidStack)this.inputTank.map(h -> h.getFluid()).orElse((Object)FluidStack.EMPTY);
        if (inFluid.isEmpty()) {
            return false;
        }
        return inFluid.getAmount() >= this.currRecipe.getInputFluid().getAmount();
    }

    @Override
    protected boolean isDisabled() {
        return false;
    }

    private void getRecipe() {
        this.clearRecipe();
        FluidStack inFluid = (FluidStack)this.inputTank.map(h -> h.getFluid()).orElse((Object)FluidStack.EMPTY);
        if (inFluid.isEmpty()) {
            this.clearRecipe();
            return;
        }
        ItemStack catalyst = this.inventory.getStackInSlot(0);
        if (catalyst.func_190926_b()) {
            this.clearRecipe();
            return;
        }
        List recipes = this.field_145850_b.func_199532_z().func_215370_b(FluidConvertorRecipe.FLUID_CONV_TYPE, (IInventory)new Inventory(new ItemStack[]{this.inventory.getStackInSlot(0)}), this.field_145850_b);
        for (FluidConvertorRecipe recipe : recipes) {
            if (!recipe.getInputFluid().isFluidEqual(inFluid)) continue;
            this.currRecipe = recipe;
            return;
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryGetter.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.inputTank.cast();
            }
            if (this.settings.get(side) == WootMachineTileEntity.Mode.INPUT) {
                return this.inputTank.cast();
            }
            if (this.settings.get(side) == WootMachineTileEntity.Mode.OUTPUT) {
                return this.outputTank.cast();
            }
            return this.inputTank.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void dropContents(World world, BlockPos pos) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = this.inventory.getStackInSlot(0);
        if (!itemStack.func_190926_b()) {
            drops.add(itemStack);
            this.inventory.insertItem(0, ItemStack.field_190927_a, false);
        }
        super.dropContents(drops);
    }
}

