/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.client;

import com.mojang.blaze3d.platform.GlStateManager;
import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.modules.factory.MobParam;
import ipsis.woot.modules.factory.Perk;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.blocks.ControllerTileEntity;
import ipsis.woot.modules.factory.blocks.HeartContainer;
import ipsis.woot.modules.factory.client.ClientFactorySetup;
import ipsis.woot.modules.factory.items.PerkItem;
import ipsis.woot.setup.NetworkChannel;
import ipsis.woot.setup.ServerDataRequest;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.WootContainerScreen;
import ipsis.woot.util.helper.StringHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class HeartScreen
extends WootContainerScreen<HeartContainer> {
    private ResourceLocation GUI = new ResourceLocation("woot", "textures/gui/heart.png");
    private List<StackElement> stackElements = new ArrayList<StackElement>();
    private List<StackElement> mobElements = new ArrayList<StackElement>();
    private List<StackElement> upgradeElements = new ArrayList<StackElement>();
    private int DROPS_COLS = 13;
    private int DROPS_ROWS = 2;
    private int DROPS_X = 10;
    private int DROPS_Y = 110;
    private int MOBS_X = 10;
    private int MOBS_Y = 76;
    private int UPGRADES_X = 99;
    private int UPGRADES_Y = 76;
    private float DROP_CYCLE_MS = 5000.0f;
    private int TEXT_COLOR = 0x404040;
    private static final int TANK_LX = 226;
    private static final int TANK_LY = 8;
    private static final int TANK_RX = 241;
    private static final int TANK_RY = 91;
    private long renderTime;
    private boolean sync = false;

    public HeartScreen(HeartContainer container, PlayerInventory inv, ITextComponent name) {
        super(container, inv, name);
        this.field_146999_f = 252;
        this.field_147000_g = 152;
    }

    protected void init() {
        int i;
        super.init();
        for (i = 0; i < 4; ++i) {
            this.mobElements.add(new StackElement(this.MOBS_X + i * 18, this.MOBS_Y, true));
        }
        for (i = 0; i < 4; ++i) {
            this.upgradeElements.add(new StackElement(this.UPGRADES_X + i * 18, this.UPGRADES_Y, true));
        }
        for (int row = 0; row < this.DROPS_ROWS; ++row) {
            for (int col = 0; col < this.DROPS_COLS; ++col) {
                this.stackElements.add(new StackElement(this.DROPS_X + col * 18, this.DROPS_Y + row * 18));
            }
        }
        NetworkChannel.channel.sendToServer((Object)new ServerDataRequest(ServerDataRequest.Type.HEART_STATIC_DATA, ((HeartContainer)this.field_147002_h).getPos(), ""));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.mobElements.forEach(e -> e.drawTooltip(mouseX, mouseY));
        this.upgradeElements.forEach(e -> e.drawTooltip(mouseX, mouseY));
        this.stackElements.forEach(e -> e.drawTooltip(mouseX, mouseY));
        if (this.renderTime == 0L) {
            this.renderTime = Util.func_211177_b();
        }
        if ((float)(Util.func_211177_b() - this.renderTime) > this.DROP_CYCLE_MS) {
            this.stackElements.forEach(e -> e.cycle());
            this.renderTime = Util.func_211177_b();
        }
        if (mouseX > this.field_147003_i + 226 && mouseX < this.field_147003_i + 241 && mouseY > this.field_147009_r + 8 && mouseY < this.field_147009_r + 91) {
            this.renderFluidTankTooltip(mouseX, mouseY, ((HeartContainer)this.field_147002_h).getInputFluid(), ((HeartContainer)this.field_147002_h).getCapacity());
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        ClientFactorySetup clientFactorySetup = ((HeartContainer)this.field_147002_h).getTileEntity().clientFactorySetup;
        if (clientFactorySetup == null) {
            return;
        }
        if (!this.sync) {
            List tooltip;
            int idx = 0;
            for (FakeMob fakeMob : clientFactorySetup.controllerMobs) {
                ClientFactorySetup.Mob mobInfo = clientFactorySetup.mobInfo.get(fakeMob);
                for (ItemStack itemStack : mobInfo.drops) {
                    Iterator<FluidStack> tooltip2 = this.getTooltipFromItem(itemStack);
                    EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(fakeMob.getResourceLocation());
                    if (entityType != null) {
                        TranslationTextComponent iTextComponent = new TranslationTextComponent(entityType.func_210760_d(), new Object[0]);
                        tooltip2.add((FluidStack)String.format("%s : %.2f%%", iTextComponent.func_150254_d(), Float.valueOf((float)itemStack.func_190916_E() / 100.0f)));
                    }
                    this.stackElements.get(idx).addDrop(itemStack, (List<String>)((Object)tooltip2));
                    idx = (idx + 1) % this.stackElements.size();
                }
            }
            if (clientFactorySetup.tier != Tier.TIER_1) {
                for (int i = 0; i < 4; ++i) {
                    this.mobElements.get(i).unlock();
                    this.upgradeElements.get(i).unlock();
                }
            } else {
                this.mobElements.get(0).unlock();
                this.upgradeElements.get(0).unlock();
            }
            idx = 0;
            for (FakeMob fakeMob : clientFactorySetup.controllerMobs) {
                ItemStack controllerStack = ControllerTileEntity.getItemStack(fakeMob);
                tooltip = this.getTooltipFromItem(controllerStack);
                ClientFactorySetup.Mob mobInfo = clientFactorySetup.mobInfo.get(fakeMob);
                if (!mobInfo.itemIngredients.isEmpty()) {
                    for (ItemStack itemStack : mobInfo.itemIngredients) {
                        ITextComponent itextcomponent = new StringTextComponent("").func_150257_a(itemStack.func_200301_q()).func_211708_a(itemStack.func_77953_t().field_77937_e);
                        tooltip.add("Ingredient: " + itemStack.func_190916_E() + " * " + itextcomponent.func_150254_d());
                    }
                }
                if (!mobInfo.fluidIngredients.isEmpty()) {
                    for (FluidStack fluidStack : mobInfo.fluidIngredients) {
                        tooltip.add("Ingredient: " + fluidStack.getAmount() + "mb " + fluidStack.toString());
                    }
                }
                this.mobElements.get(idx).addDrop(controllerStack, tooltip);
                this.mobElements.get(idx).unlock();
                ++idx;
            }
            idx = 0;
            for (Perk perk : clientFactorySetup.perks) {
                ItemStack itemStack = PerkItem.getItemStack(perk);
                tooltip = this.getTooltipFromItem(itemStack);
                for (FakeMob fakeMob : clientFactorySetup.controllerMobs) {
                    MobParam mobParam = clientFactorySetup.mobParams.get(fakeMob);
                    EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(fakeMob.getResourceLocation());
                    if (entityType == null) continue;
                    TranslationTextComponent iTextComponent = new TranslationTextComponent(entityType.func_210760_d(), new Object[0]);
                    if (Perk.EFFICIENCY_PERKS.contains((Object)perk)) {
                        tooltip.add(String.format("%s : %d%%", iTextComponent.func_150254_d(), mobParam.getPerkEfficiencyValue()));
                        continue;
                    }
                    if (Perk.RATE_PERKS.contains((Object)perk)) {
                        tooltip.add(String.format("%s : %d%%", iTextComponent.func_150254_d(), mobParam.getPerkRateValue()));
                        continue;
                    }
                    if (Perk.MASS_PERKS.contains((Object)perk)) {
                        tooltip.add(String.format("%s : %d mobs", iTextComponent.func_150254_d(), mobParam.getMobCount(true)));
                        continue;
                    }
                    if (!Perk.XP_PERKS.contains((Object)perk)) continue;
                    tooltip.add(String.format("%s : %d%%", iTextComponent.func_150254_d(), mobParam.getPerkXpValue()));
                }
                if (Perk.TIER_SHARD_PERKS.contains((Object)perk)) {
                    tooltip.add(String.format("%d rolls @ %.2f%%", clientFactorySetup.shardRolls, clientFactorySetup.shardDropChance));
                    tooltip.add(String.format("Basic: %.2f%%", clientFactorySetup.shardDrops[0]));
                    tooltip.add(String.format("Advanced: %.2f%%", clientFactorySetup.shardDrops[1]));
                    tooltip.add(String.format("Elite: %.2f%%", clientFactorySetup.shardDrops[2]));
                }
                this.upgradeElements.get(idx).addDrop(itemStack, tooltip);
                this.upgradeElements.get(idx).unlock();
                idx = (idx + 1) % this.upgradeElements.size();
            }
            this.sync = true;
        }
        this.addInfoLine(0, StringHelper.translate("gui.woot.heart.0"), this.title.func_150254_d());
        this.addInfoLine(1, StringHelper.translate(new FluidStack((Fluid)FluidSetup.CONATUS_FLUID.get(), 1).getTranslationKey()), clientFactorySetup.recipeFluid + " mB");
        this.addInfoLine(2, StringHelper.translate("gui.woot.heart.1"), clientFactorySetup.recipeTicks + " ticks");
        this.addInfoLine(3, StringHelper.translate("gui.woot.heart.2"), ((HeartContainer)this.field_147002_h).getProgress() + "%");
        this.font.func_211126_b(StringHelper.translate("gui.woot.heart.3"), (float)this.MOBS_X, (float)(this.MOBS_Y - 10), this.TEXT_COLOR);
        this.font.func_211126_b(StringHelper.translate("gui.woot.heart.4"), (float)this.UPGRADES_X, (float)(this.UPGRADES_Y - 10), this.TEXT_COLOR);
        this.font.func_211126_b(StringHelper.translate("gui.woot.heart.5"), (float)this.DROPS_X, (float)(this.DROPS_Y - 10), this.TEXT_COLOR);
        this.mobElements.forEach(e -> e.drawForeground(mouseX, mouseY));
        this.upgradeElements.forEach(e -> e.drawForeground(mouseX, mouseY));
        this.stackElements.forEach(e -> e.drawForeground(mouseX, mouseY));
    }

    private void addInfoLine(int offset, String tag, String value) {
        int INFO_X = 10;
        int INFO_Y = 10;
        int TEXT_HEIGHT = 10;
        this.font.func_211126_b(tag, (float)INFO_X, (float)(INFO_Y + TEXT_HEIGHT * offset), this.TEXT_COLOR);
        this.font.func_211126_b(value, (float)(INFO_X + 80), (float)(INFO_Y + TEXT_HEIGHT * offset), this.TEXT_COLOR);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.GUI);
        int relX = (this.width - this.field_146999_f) / 2;
        int relY = (this.height - this.field_147000_g) / 2;
        this.blit(relX, relY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.mobElements.forEach(e -> e.drawBackground(mouseX, mouseY));
        this.upgradeElements.forEach(e -> e.drawBackground(mouseX, mouseY));
        this.stackElements.forEach(e -> e.drawBackground(mouseX, mouseY));
        this.renderFluidTank(226, 91, 84, 16, ((HeartContainer)this.field_147002_h).getCapacity(), ((HeartContainer)this.field_147002_h).getInputFluid());
    }

    class StackElement {
        int x;
        int y;
        boolean isLocked = false;
        int idx = 0;
        List<ItemStack> itemStacks = new ArrayList<ItemStack>();
        List<List<String>> tooltips = new ArrayList<List<String>>();

        public StackElement(int x, int y, boolean locked) {
            this.x = x;
            this.y = y;
            this.isLocked = locked;
        }

        public StackElement(int x, int y) {
            this(x, y, false);
        }

        public void addDrop(ItemStack itemStack, List<String> tooltip) {
            this.isLocked = false;
            this.itemStacks.add(itemStack);
            this.tooltips.add(tooltip);
        }

        public void unlock() {
            this.isLocked = false;
        }

        public void cycle() {
            if (!this.itemStacks.isEmpty()) {
                this.idx = (this.idx + 1) % this.itemStacks.size();
            }
        }

        public void drawBackground(int mouseX, int mouseY) {
            if (this.isLocked) {
                return;
            }
            if (this.itemStacks.isEmpty()) {
                return;
            }
        }

        public void drawTooltip(int mouseX, int mouseY) {
            if (this.isLocked) {
                return;
            }
            if (this.itemStacks.isEmpty()) {
                return;
            }
            ItemStack itemStack = this.itemStacks.get(this.idx);
            List<String> tooltip = this.tooltips.get(this.idx);
            if (HeartScreen.this.func_195359_a(this.x, this.y, 16, 16, mouseX, mouseY)) {
                FontRenderer fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack);
                if (fontRenderer == null) {
                    fontRenderer = HeartScreen.this.font;
                }
                HeartScreen.this.renderTooltip(tooltip, mouseX, mouseY, fontRenderer);
            }
        }

        public void drawForeground(int mouseX, int mouseY) {
            if (this.isLocked) {
                AbstractGui.fill((int)(this.x - 1), (int)(this.y - 1), (int)(this.x - 1 + 18), (int)(this.y - 1 + 18), (int)-2130706433);
                return;
            }
            if (this.itemStacks.isEmpty()) {
                return;
            }
            ItemStack itemStack = this.itemStacks.get(this.idx);
            HeartScreen.this.setBlitOffset(100);
            ((HeartScreen)HeartScreen.this).itemRenderer.field_77023_b = 100.0f;
            RenderHelper.func_227780_a_();
            GlStateManager.func_227734_k_();
            HeartScreen.this.itemRenderer.func_175042_a(itemStack, this.x, this.y);
            RenderHelper.func_74518_a();
            ((HeartScreen)HeartScreen.this).itemRenderer.field_77023_b = 0.0f;
            HeartScreen.this.setBlitOffset(0);
        }
    }
}

