/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.calculators;

import ipsis.woot.crafting.FactoryRecipe;
import ipsis.woot.modules.factory.FormedSetup;
import ipsis.woot.modules.factory.PerkType;
import ipsis.woot.modules.factory.blocks.ControllerTileEntity;
import ipsis.woot.modules.factory.blocks.HeartTileEntity;
import ipsis.woot.util.FakeMob;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CalculatorVersion2 {
    private static final Logger LOGGER = LogManager.getLogger();

    public static HeartTileEntity.Recipe calculate(FormedSetup setup) {
        int baseSpawnTicks;
        int actualSpawnTicks = baseSpawnTicks = setup.getMaxSpawnTime();
        LOGGER.debug("Calculator baseSpawnTicks:{} actualSpawnTick:{}", (Object)baseSpawnTicks, (Object)actualSpawnTicks);
        for (FakeMob fakeMob : setup.getAllMobs()) {
            LOGGER.debug("Calulator mob:{} params:{}", (Object)fakeMob, (Object)setup.getAllMobParams().get(fakeMob));
        }
        int fluidCost = 0;
        for (FakeMob fakeMob : setup.getAllMobs()) {
            int mobFluidCost = setup.getAllMobParams().get((Object)fakeMob).baseFluidCost * setup.getAllMobParams().get(fakeMob).getMobCount(setup.getAllPerks().containsKey((Object)PerkType.MASS));
            LOGGER.debug("Calculator mob:{} fluidCost:{}", (Object)fakeMob, (Object)mobFluidCost);
            if (setup.getAllPerks().containsKey((Object)PerkType.EFFICIENCY)) {
                LOGGER.debug("Calculator: EFFICIENCY");
                int fluidSaving = (int)((float)mobFluidCost / 100.0f) * setup.getAllMobParams().get(fakeMob).getPerkEfficiencyValue();
                mobFluidCost -= fluidSaving;
                mobFluidCost = MathHelper.func_76125_a((int)mobFluidCost, (int)0, (int)Integer.MAX_VALUE);
                LOGGER.debug("Calculator: saving of {}mB -> {}mB", (Object)fluidSaving, (Object)mobFluidCost);
            }
            fluidCost += mobFluidCost;
        }
        LOGGER.debug("Calculator fluidCost:{}", (Object)fluidCost);
        if (setup.getAllPerks().containsKey((Object)PerkType.RATE)) {
            LOGGER.debug("Calculator: RATE");
            int n = (int)((float)baseSpawnTicks / 100.0f * (float)setup.getMinRateValue());
            LOGGER.debug("Calculator: {} @ {}% -> {}", (Object)baseSpawnTicks, (Object)setup.getMinRateValue(), (Object)(actualSpawnTicks -= n));
        }
        HeartTileEntity.Recipe recipe = new HeartTileEntity.Recipe(actualSpawnTicks, fluidCost);
        block2: for (FakeMob fakeMob : setup.getAllMobs()) {
            ItemStack controller = ControllerTileEntity.getItemStack(fakeMob);
            List recipes = setup.getWorld().func_199532_z().func_215370_b(FactoryRecipe.FACTORY_TYPE, (IInventory)new Inventory(new ItemStack[]{controller}), setup.getWorld());
            for (FactoryRecipe factoryRecipe : recipes) {
                if (!factoryRecipe.getFakeMob().equals(fakeMob)) continue;
                for (ItemStack itemStack : factoryRecipe.getItems()) {
                    recipe.addItem(fakeMob, itemStack.func_77946_l());
                }
                for (FluidStack fluidStack : factoryRecipe.getFluids()) {
                    recipe.addFluid(fakeMob, fluidStack);
                }
                continue block2;
            }
        }
        return recipe;
    }
}

