/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.modules.debug.items.DebugItem;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.FactoryComponentProvider;
import ipsis.woot.modules.factory.FactoryConfiguration;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.CellTileEntityBase;
import ipsis.woot.util.WootDebug;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class CellBlock
extends Block
implements WootDebug,
FactoryComponentProvider {
    final Class<? extends CellTileEntityBase> tileEntityClazz;

    public CellBlock(Class<? extends CellTileEntityBase> clazz) {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(3.5f));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208174_a, (Comparable)Boolean.valueOf(false)));
        this.tileEntityClazz = clazz;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208174_a});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        try {
            return this.tileEntityClazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException();
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (!(worldIn.func_175625_s(pos) instanceof CellTileEntityBase)) {
            throw new IllegalStateException("Tile entity is missing");
        }
        ItemStack heldItem = player.func_184586_b(handIn);
        if (FluidUtil.getFluidHandler((ItemStack)heldItem).isPresent()) {
            return FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (World)worldIn, (BlockPos)pos, null) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, p_225533_6_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        int transfer = 0;
        int capacity = 0;
        if (stack.func_77973_b() == ((CellBlock)FactorySetup.CELL_1_BLOCK.get()).func_199767_j()) {
            capacity = (Integer)FactoryConfiguration.CELL_1_CAPACITY.get();
            transfer = (Integer)FactoryConfiguration.CELL_1_MAX_TRANSFER.get();
        } else if (stack.func_77973_b() == ((CellBlock)FactorySetup.CELL_2_BLOCK.get()).func_199767_j()) {
            capacity = (Integer)FactoryConfiguration.CELL_2_CAPACITY.get();
            transfer = (Integer)FactoryConfiguration.CELL_2_MAX_TRANSFER.get();
        } else if (stack.func_77973_b() == ((CellBlock)FactorySetup.CELL_3_BLOCK.get()).func_199767_j()) {
            capacity = (Integer)FactoryConfiguration.CELL_3_CAPACITY.get();
            transfer = (Integer)FactoryConfiguration.CELL_3_MAX_TRANSFER.get();
        } else if (stack.func_77973_b() == ((CellBlock)FactorySetup.CELL_4_BLOCK.get()).func_199767_j()) {
            capacity = (Integer)FactoryConfiguration.CELL_4_CAPACITY.get();
            transfer = (Integer)FactoryConfiguration.CELL_4_MAX_TRANSFER.get();
        }
        int contents = 0;
        CompoundNBT compoundNBT = stack.func_179543_a("BlockEntityTag");
        if (compoundNBT != null && compoundNBT.func_74764_b("Tank")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundNBT)compoundNBT.func_74775_l("Tank"));
            contents = fluidStack.getAmount();
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.cell.0", new Object[]{contents, capacity}));
        tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.cell.1", new Object[]{transfer}));
    }

    @Override
    public FactoryComponent getFactoryComponent() {
        return FactoryComponent.CELL;
    }

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> CellBlock");
        DebugItem.getTileEntityDebug(debug, itemUseContext);
        return debug;
    }
}

