/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.fluilds.network;

import ipsis.woot.util.FluidStackPacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class FluidStackPacket {
    public List<FluidStack> fluidStackList = new ArrayList<FluidStack>();

    public FluidStackPacket() {
    }

    public FluidStackPacket(FluidStack ... stacks) {
        for (FluidStack fluidStack : stacks) {
            this.fluidStackList.add(fluidStack.copy());
        }
    }

    public static FluidStackPacket fromBytes(PacketBuffer buf) {
        FluidStackPacket pkt = new FluidStackPacket();
        int stacks = buf.readInt();
        if (stacks > 0) {
            for (int i = 0; i < stacks; ++i) {
                if (buf.readBoolean()) {
                    pkt.fluidStackList.add(FluidStack.readFromPacket((PacketBuffer)buf));
                    continue;
                }
                pkt.fluidStackList.add(FluidStack.EMPTY);
            }
        }
        return pkt;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.fluidStackList.size());
        for (int i = 0; i < this.fluidStackList.size(); ++i) {
            FluidStack fluidStack = this.fluidStackList.get(i);
            if (fluidStack.isEmpty()) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            fluidStack.writeToPacket(buf);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this.lambda$null$1((Supplier)ctx)));
    }

    private /* synthetic */ Runnable lambda$null$1(Supplier ctx) {
        return () -> this.lambda$null$0((Supplier)ctx);
    }

    private /* synthetic */ void lambda$null$0(Supplier ctx) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_71070_bA instanceof FluidStackPacketHandler) {
            ((FluidStackPacketHandler)player.field_71070_bA).handlePacket(this);
        }
        ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
    }
}

