/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import com.google.gson.JsonObject;
import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.modules.squeezer.DyeMakeup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ObjectHolder;

public class DyeSqueezerRecipe
implements IRecipe<IInventory> {
    private final Ingredient ingredient;
    private final int energy;
    private final int red;
    private final int yellow;
    private final int blue;
    private final int white;
    private final ResourceLocation id;
    private final IRecipeType<?> type;
    private static List<ItemStack> validInputs = new ArrayList<ItemStack>();
    private List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    public static final IRecipeType<DyeSqueezerRecipe> DYE_SQUEEZER_TYPE = IRecipeType.func_222147_a((String)"dyesqueezer");
    @ObjectHolder(value="woot:dyesqueezer")
    public static final IRecipeSerializer<IRecipe<?>> SERIALIZER = null;

    public DyeSqueezerRecipe(ResourceLocation id, Ingredient ingredient, int energy, int red, int yellow, int blue, int white) {
        this.id = id;
        this.ingredient = ingredient;
        this.energy = energy;
        this.red = red;
        this.yellow = yellow;
        this.blue = blue;
        this.white = white;
        this.type = DYE_SQUEEZER_TYPE;
        this.inputs.add(Arrays.asList(ingredient.func_193365_a()));
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getRed() {
        return this.red;
    }

    public int getYellow() {
        return this.yellow;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getWhite() {
        return this.white;
    }

    public FluidStack getOutput() {
        return new FluidStack((Fluid)FluidSetup.PUREDYE_FLUID.get(), 72);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public static void clearValidInputs() {
        validInputs.clear();
    }

    public static void addValidInput(ItemStack itemStack) {
        validInputs.add(itemStack);
    }

    public static boolean isValidInput(ItemStack itemStack) {
        for (ItemStack i : validInputs) {
            if (!i.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public static DyeSqueezerRecipe dyeSqueezerRecipe(ResourceLocation id, Ingredient ingredient, int energy, DyeMakeup dyeMakeup) {
        return new DyeSqueezerRecipe(id, ingredient, energy, dyeMakeup.getRed(), dyeMakeup.getYellow(), dyeMakeup.getBlue(), dyeMakeup.getWhite());
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.ingredient == null) {
            throw new IllegalStateException("No valid ingredient for recipe " + id);
        }
        consumer.accept(new Finished(id, this.ingredient, this.energy, this.red, this.yellow, this.blue, this.white));
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.ingredient.test(inv.func_70301_a(0));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }

    public static class Finished
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final int energy;
        private final int red;
        private final int yellow;
        private final int blue;
        private final int white;

        private Finished(ResourceLocation id, Ingredient ingredient, int energy, int red, int yellow, int blue, int white) {
            this.id = id;
            this.ingredient = ingredient;
            this.energy = energy;
            this.red = red;
            this.yellow = yellow;
            this.blue = blue;
            this.white = white;
        }

        public void func_218610_a(JsonObject json) {
            json.add("ingredient", this.ingredient.func_200304_c());
            json.addProperty("energy", (Number)this.energy);
            json.addProperty("red", (Number)this.red);
            json.addProperty("yellow", (Number)this.yellow);
            json.addProperty("blue", (Number)this.blue);
            json.addProperty("white", (Number)this.white);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

