/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.compat.jei;

import ipsis.woot.compat.jei.AnvilRecipeCategory;
import ipsis.woot.compat.jei.DyeSqueezerRecipeCategory;
import ipsis.woot.compat.jei.EnchantSqueezerRecipeCategory;
import ipsis.woot.compat.jei.FluidConvertorRecipeCategory;
import ipsis.woot.compat.jei.InfuserRecipeCategory;
import ipsis.woot.crafting.AnvilRecipe;
import ipsis.woot.crafting.DyeSqueezerRecipe;
import ipsis.woot.crafting.EnchantSqueezerRecipe;
import ipsis.woot.crafting.FluidConvertorRecipe;
import ipsis.woot.crafting.InfuserRecipe;
import ipsis.woot.modules.anvil.AnvilSetup;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.fluidconvertor.client.FluidConvertorScreen;
import ipsis.woot.modules.generic.GenericSetup;
import ipsis.woot.modules.infuser.client.InfuserScreen;
import ipsis.woot.modules.layout.LayoutSetup;
import ipsis.woot.modules.squeezer.SqueezerConfiguration;
import ipsis.woot.modules.squeezer.client.DyeSqueezerScreen;
import ipsis.woot.modules.squeezer.client.EnchantSqueezerScreen;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class WootJeiPlugin
implements IModPlugin {
    public static int maxInfuserRecipeMb = 1000;
    @Nullable
    public static IJeiRuntime jeiRuntime;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("woot", "main");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new DyeSqueezerRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new InfuserRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new AnvilRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new EnchantSqueezerRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new FluidConvertorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipeManager = world.func_199532_z();
        ArrayList<IRecipe> dyeRecipes = new ArrayList<IRecipe>();
        ArrayList<IRecipe> anvilRecipes = new ArrayList<IRecipe>();
        ArrayList<InfuserRecipe> infuserRecipes = new ArrayList<InfuserRecipe>();
        ArrayList<IRecipe> conatusGenRecipes = new ArrayList<IRecipe>();
        for (IRecipe recipe : recipeManager.func_199510_b()) {
            if (recipe instanceof DyeSqueezerRecipe) {
                dyeRecipes.add(recipe);
                continue;
            }
            if (recipe instanceof AnvilRecipe) {
                anvilRecipes.add(recipe);
                continue;
            }
            if (recipe instanceof InfuserRecipe) {
                InfuserRecipe r = (InfuserRecipe)recipe;
                infuserRecipes.add(r);
                if (r.getFluidInput().getAmount() <= maxInfuserRecipeMb) continue;
                maxInfuserRecipeMb = r.getFluidInput().getAmount();
                continue;
            }
            if (!(recipe instanceof FluidConvertorRecipe)) continue;
            conatusGenRecipes.add(recipe);
        }
        registration.addRecipes(dyeRecipes, DyeSqueezerRecipeCategory.UID);
        registration.addRecipes(anvilRecipes, AnvilRecipeCategory.UID);
        registration.addRecipes(infuserRecipes, InfuserRecipeCategory.UID);
        registration.addRecipes(conatusGenRecipes, FluidConvertorRecipeCategory.UID);
        ArrayList<EnchantSqueezerRecipe> books = new ArrayList<EnchantSqueezerRecipe>();
        for (Enchantment e : ForgeRegistries.ENCHANTMENTS) {
            for (int i = e.func_77319_d(); i <= e.func_77325_b(); ++i) {
                ItemStack itemStack = new ItemStack((IItemProvider)Items.field_151134_bR);
                itemStack.func_77966_a(e, i);
                books.add(new EnchantSqueezerRecipe(itemStack, SqueezerConfiguration.getEnchantFluidAmount(i), SqueezerConfiguration.getEnchantEnergy(i)));
            }
        }
        registration.addRecipes(books, EnchantSqueezerRecipeCategory.UID);
        registration.addIngredientInfo(Arrays.asList(new ItemStack((IItemProvider)GenericSetup.T1_SHARD_ITEM.get()), new ItemStack((IItemProvider)GenericSetup.T2_SHARD_ITEM.get()), new ItemStack((IItemProvider)GenericSetup.T3_SHARD_ITEM.get())), VanillaTypes.ITEM, new String[]{"jei.woot.shard"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)AnvilSetup.ANVIL_BLOCK.get()), VanillaTypes.ITEM, new String[]{"jei.woot.anvil.0", "jei.woot.anvil.1", "jei.woot.anvil.2", "jei.woot.anvil.3"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)LayoutSetup.INTERN_ITEM.get()), VanillaTypes.ITEM, new String[]{"jei.woot.intern.0", "jei.woot.intern.1"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)FactorySetup.MOB_SHARD_ITEM.get()), VanillaTypes.ITEM, new String[]{"jei.woot.mob_shard.0", "jei.woot.mob_shard.1", "jei.woot.mob_shard.2"});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(InfuserScreen.class, 84, 39, 30, 18, new ResourceLocation[]{InfuserRecipeCategory.UID});
        registration.addRecipeClickArea(DyeSqueezerScreen.class, 60, 39, 18, 18, new ResourceLocation[]{DyeSqueezerRecipeCategory.UID});
        registration.addRecipeClickArea(EnchantSqueezerScreen.class, 101, 32, 50, 36, new ResourceLocation[]{EnchantSqueezerRecipeCategory.UID});
        registration.addRecipeClickArea(FluidConvertorScreen.class, 74, 40, 70, 26, new ResourceLocation[]{FluidConvertorRecipeCategory.UID});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        WootJeiPlugin.jeiRuntime = jeiRuntime;
    }
}

