/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.simulator.spawning.SpawnController;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.FakeMobKey;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class SimulationCommand {
    private static final String TAG = "commands.woot.simulation.";
    static final SuggestionProvider<CommandSource> ENTITY_SUGGESTIONS = (ctx, builder) -> ISuggestionProvider.func_212476_a(ForgeRegistries.ENTITIES.getKeys().stream(), (SuggestionsBuilder)builder);

    static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"simulation").then(LearnCommand.register())).then(DumpCommand.register())).then(FlushCommand.register())).then(StatusCommand.register())).then(RollDropsCommand.register());
    }

    private static int rollDrops(CommandSource source, ResourceLocation resourceLocation, String tag, int looting) throws CommandSyntaxException {
        FakeMob fakeMob = tag.equalsIgnoreCase("") ? new FakeMob(resourceLocation.toString()) : new FakeMob(resourceLocation.toString() + "," + tag);
        if (fakeMob.isValid() && SpawnController.get().isLivingEntity(fakeMob, (World)source.func_197023_e())) {
            List<ItemStack> drops = MobSimulator.getInstance().getRolledDrops(new FakeMobKey(fakeMob, looting));
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.woot.simulation.roll", new Object[]{fakeMob, looting, drops.stream().map(ItemStack::toString).collect(Collectors.joining(","))}), true);
        }
        return 0;
    }

    private static int learnEntity(CommandSource source, ResourceLocation resourceLocation, String tag) throws CommandSyntaxException {
        FakeMob fakeMob = tag.equalsIgnoreCase("") ? new FakeMob(resourceLocation.toString()) : new FakeMob(resourceLocation.toString() + "," + tag);
        if (fakeMob.isValid() && SpawnController.get().isLivingEntity(fakeMob, (World)source.func_197023_e())) {
            boolean result = MobSimulator.getInstance().learn(fakeMob);
            if (result) {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.woot.simulation.learn.ok", new Object[]{resourceLocation.toString()}), true);
            } else {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.woot.simulation.learn.fail", new Object[]{resourceLocation.toString()}), true);
            }
        }
        return 0;
    }

    private static int dumpEntity(CommandSource source, ResourceLocation resourceLocation, String tag) throws CommandSyntaxException {
        FakeMob fakeMob = tag.equalsIgnoreCase("") ? new FakeMob(resourceLocation.toString()) : new FakeMob(resourceLocation.toString() + "," + tag);
        if (fakeMob.isValid() && SpawnController.get().isLivingEntity(fakeMob, (World)source.func_197023_e())) {
            for (SimulatedMobDropSummary summary : MobSimulator.getInstance().getDropSummary(fakeMob)) {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.woot.simulation.dump.drop", new Object[]{summary}), true);
            }
        }
        return 0;
    }

    private static int status(CommandSource source) throws CommandSyntaxException {
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.woot.simulation.status.simulating", new Object[]{MobSimulator.getInstance().getSimulations().stream().map(FakeMobKey::toString).collect(Collectors.joining(","))}), true);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.woot.simulation.status.waiting", new Object[]{MobSimulator.getInstance().getWaiting().stream().map(FakeMobKey::toString).collect(Collectors.joining(","))}), true);
        return 0;
    }

    private static int flushEntity(CommandSource source, ResourceLocation resourceLocation, String tag) throws CommandSyntaxException {
        FakeMob fakeMob = tag.equalsIgnoreCase("") ? new FakeMob(resourceLocation.toString()) : new FakeMob(resourceLocation.toString() + "," + tag);
        if (fakeMob.isValid() && SpawnController.get().isLivingEntity(fakeMob, (World)source.func_197023_e())) {
            MobSimulator.getInstance().flush(fakeMob);
            MobSimulator.getInstance().learn(fakeMob);
        }
        return 0;
    }

    private static class StatusCommand {
        private StatusCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"status").requires(cs -> cs.func_197034_c(0))).executes(ctx -> SimulationCommand.status((CommandSource)ctx.getSource()));
        }
    }

    private static class FlushCommand {
        private FlushCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"flush").requires(cs -> cs.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entity", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(ENTITY_SUGGESTIONS).executes(ctx -> SimulationCommand.flushEntity((CommandSource)ctx.getSource(), ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"entity"), ""))).then(Commands.func_197056_a((String)"tag", (ArgumentType)StringArgumentType.string()).executes(ctx -> SimulationCommand.flushEntity((CommandSource)ctx.getSource(), ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"entity"), StringArgumentType.getString((CommandContext)ctx, (String)"tag")))));
        }
    }

    private static class DumpCommand {
        private DumpCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"dump").requires(cs -> cs.func_197034_c(0))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entity", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(ENTITY_SUGGESTIONS).executes(ctx -> SimulationCommand.dumpEntity((CommandSource)ctx.getSource(), ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"entity"), ""))).then(Commands.func_197056_a((String)"tag", (ArgumentType)StringArgumentType.string()).executes(ctx -> SimulationCommand.dumpEntity((CommandSource)ctx.getSource(), ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"entity"), StringArgumentType.getString((CommandContext)ctx, (String)"tag")))));
        }
    }

    private static class RollDropsCommand {
        private RollDropsCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"roll").requires(cs -> cs.func_197034_c(0))).then(Commands.func_197056_a((String)"entity", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(ENTITY_SUGGESTIONS).then(Commands.func_197056_a((String)"looting", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(ctx -> SimulationCommand.rollDrops((CommandSource)ctx.getSource(), ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"entity"), "", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"looting")))))).then(Commands.func_197056_a((String)"tag", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"looting", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(ctx -> SimulationCommand.rollDrops((CommandSource)ctx.getSource(), ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"entity"), "", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"looting")))));
        }
    }

    private static class LearnCommand {
        private LearnCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"learn").requires(cs -> cs.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entity", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(ENTITY_SUGGESTIONS).executes(ctx -> SimulationCommand.learnEntity((CommandSource)ctx.getSource(), ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"entity"), ""))).then(Commands.func_197056_a((String)"tag", (ArgumentType)StringArgumentType.string()).executes(ctx -> SimulationCommand.learnEntity((CommandSource)ctx.getSource(), ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"entity"), StringArgumentType.getString((CommandContext)ctx, (String)"tag")))));
        }
    }
}

