/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.data.MCDataOutput;
import codechicken.lib.internal.network.CCLNetwork;
import codechicken.lib.packet.PacketCustom;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ServerUtils {
    public static MinecraftServer getServer() {
        return (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
    }

    public static ServerPlayerEntity getPlayer(String playername) {
        return ServerUtils.getServer().func_184103_al().func_152612_a(playername);
    }

    public static List<ServerPlayerEntity> getPlayers() {
        return ServerUtils.getServer().func_184103_al().func_181057_v();
    }

    public static boolean isPlayerLoadingChunk(ServerPlayerEntity player, ChunkPos chunk) {
        return player.func_71121_q().func_72863_F().field_217237_a.func_219097_a(chunk, false).anyMatch(e -> e.func_145782_y() == player.func_145782_y());
    }

    public static File getSaveDirectory() {
        return ServerUtils.getSaveDirectory(DimensionType.field_223227_a_);
    }

    public static File getSaveDirectory(DimensionType dimension) {
        return ServerUtils.getServer().func_71218_a(dimension).func_217485_w().func_75765_b();
    }

    public static GameProfile getGameProfile(String username) {
        ServerPlayerEntity player = ServerUtils.getPlayer(username);
        if (player != null) {
            return player.func_146103_bH();
        }
        PlayerProfileCache.ProfileEntry cachedEntry = (PlayerProfileCache.ProfileEntry)ServerUtils.getServer().func_152358_ax().field_152661_c.get(username = username.toLowerCase(Locale.ROOT));
        if (cachedEntry != null) {
            return cachedEntry.func_152668_a();
        }
        return ServerUtils.getServer().func_152358_ax().func_152655_a(username);
    }

    public static boolean isPlayerOP(UUID uuid) {
        GameProfile profile = ServerUtils.getServer().func_152358_ax().func_152652_a(uuid);
        return profile != null && ServerUtils.getServer().func_184103_al().func_152596_g(profile);
    }

    public static boolean isPlayerOP(String username) {
        GameProfile prof = ServerUtils.getGameProfile(username);
        return prof != null && ServerUtils.getServer().func_184103_al().func_152596_g(prof);
    }

    public static void openContainer(ServerPlayerEntity player, INamedContainerProvider containerProvider) {
        ServerUtils.openContainer(player, containerProvider, e -> {});
    }

    public static void openContainer(ServerPlayerEntity player, INamedContainerProvider containerProvider, Consumer<MCDataOutput> packetConsumer) {
        if (player.field_70170_p.func_201670_d()) {
            return;
        }
        player.func_71128_l();
        player.func_71117_bO();
        int containerId = player.field_71139_cq;
        Container container = containerProvider.createMenu(containerId, player.field_71071_by, (PlayerEntity)player);
        ContainerType type = container.func_216957_a();
        PacketCustom packet = new PacketCustom(CCLNetwork.NET_CHANNEL, 10);
        packet.writeRegistryIdUnsafe(ForgeRegistries.CONTAINERS, (IForgeRegistryEntry)type);
        packet.writeVarInt(containerId);
        packet.writeTextComponent(containerProvider.func_145748_c_());
        packetConsumer.accept(packet);
        packet.sendToPlayer(player);
        player.field_71070_bA = container;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)player, container));
    }
}

