/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.Uniform;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.lwjgl.opengl.GL20;

public abstract class AbstractShaderObject
implements ShaderObject {
    private final String name;
    private final ShaderObject.ShaderType type;
    private final ImmutableList<Uniform> uniforms;
    protected int shaderId = -1;
    protected boolean dirty;

    protected AbstractShaderObject(String name, ShaderObject.ShaderType type, Collection<Uniform> uniforms) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.uniforms = ImmutableList.copyOf(uniforms);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ShaderObject.ShaderType getShaderType() {
        return this.type;
    }

    @Override
    public ImmutableList<Uniform> getUniforms() {
        return this.uniforms;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void alloc() {
        if (this.dirty || this.shaderId == -1) {
            if (this.shaderId == -1) {
                this.shaderId = GL20.glCreateShader((int)this.type.getGLCode());
                if (this.shaderId == 0) {
                    throw new RuntimeException("Allocation of ShaderObject failed.");
                }
            }
            GL20.glShaderSource((int)this.shaderId, (CharSequence)this.getSource());
            GL20.glCompileShader((int)this.shaderId);
            if (GL20.glGetShaderi((int)this.shaderId, (int)35713) == 0) {
                throw new RuntimeException("ShaderProgram linkage failure. \n" + GL20.glGetShaderInfoLog((int)this.shaderId));
            }
        }
    }

    @Override
    public int getShaderID() {
        return this.shaderId;
    }

    @Override
    public void onLink(int programId) {
    }

    protected abstract String getSource();
}

