/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class TextSplitter {
    public static final String START = "start";
    public static final Pattern LINEBREAK = Pattern.compile("[\\n\\r]+");
    private final Function<String, Integer> width;
    private final int lineWidth;
    private final IntSupplier pixelsPerLine;
    private final Map<String, Map<Integer, SpecialManualElement>> specialByAnchor = new HashMap<String, Map<Integer, SpecialManualElement>>();
    private final Int2ObjectMap<SpecialManualElement> specialByPage = new Int2ObjectOpenHashMap();
    private final List<List<String>> entry = new ArrayList<List<String>>();
    private final Function<String, String> tokenTransform;
    private final int pixelsPerPage;
    private final Object2IntMap<String> pageByAnchor = new Object2IntOpenHashMap();

    public TextSplitter(Function<String, Integer> w, int lineWidthPixel, int pageHeightPixel, IntSupplier pixelsPerLine, Function<String, String> tokenTransform) {
        this.width = w;
        this.lineWidth = lineWidthPixel;
        this.pixelsPerPage = pageHeightPixel;
        this.pixelsPerLine = pixelsPerLine;
        this.tokenTransform = tokenTransform;
    }

    public TextSplitter(ManualInstance m) {
        this(m, s -> s);
    }

    public TextSplitter(ManualInstance m, Function<String, String> tokenTransform) {
        this(s -> m.fontRenderer().func_78256_a(s), m.pageWidth, m.pageHeight, () -> {
            m.fontRenderer().getClass();
            return 9;
        }, tokenTransform);
    }

    public void clearSpecialByPage() {
        this.specialByPage.clear();
    }

    public void clearSpecialByAnchor() {
        this.specialByAnchor.clear();
    }

    public void addSpecialPage(String ref, int offset, SpecialManualElement element) {
        if (offset < 0 || ref == null || ref.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (!this.specialByAnchor.containsKey(ref)) {
            this.specialByAnchor.put(ref, new HashMap());
        }
        this.specialByAnchor.get(ref).put(offset, element);
    }

    public void split(String in) {
        for (Map<Integer, SpecialManualElement> forAnchor : this.specialByAnchor.values()) {
            for (SpecialManualElement e : forAnchor.values()) {
                e.recalculateCraftingRecipes();
            }
        }
        this.clearSpecialByPage();
        this.entry.clear();
        String[] wordsAndSpaces = TextSplitter.splitWhitespace(in);
        int pos = 0;
        ArrayList overflow = new ArrayList();
        this.updateSpecials(START, 0);
        String formattingFromPreviousLine = "";
        while (pos < wordsAndSpaces.length || !overflow.isEmpty()) {
            int linesMax;
            boolean forceNewPage;
            List<String> page = new ArrayList<String>(overflow);
            overflow.clear();
            boolean bl = forceNewPage = this.getLinesOnPage(this.entry.size()) <= 0;
            block3: while (page.size() < this.getLinesOnPage(this.entry.size()) && pos < wordsAndSpaces.length) {
                String line = formattingFromPreviousLine;
                formattingFromPreviousLine = "";
                int currWidth = 0;
                while (pos < wordsAndSpaces.length && currWidth < this.lineWidth) {
                    String token = this.tokenTransform.apply(wordsAndSpaces[pos]);
                    int textWidth = this.getWidth(token);
                    if (currWidth + textWidth <= this.lineWidth || line.length() == 0) {
                        ++pos;
                        if (token.equals("<np>")) {
                            if (page.isEmpty() && line.isEmpty()) break block3;
                            page.add(line);
                            break block3;
                        }
                        if (LINEBREAK.matcher(token).matches()) break;
                        if (token.startsWith("<&") && token.endsWith(">")) {
                            String id = token.substring(2, token.length() - 1);
                            int pageForId = this.entry.size();
                            Map<Integer, SpecialManualElement> specialForId = this.specialByAnchor.get(id);
                            boolean specialOnNextPage = false;
                            boolean pageFull = false;
                            if (specialForId != null && specialForId.containsKey(0)) {
                                SpecialManualElement specialHere = specialForId.get(0);
                                if (!(page.size() + 1 <= this.getLinesOnPage(specialHere) || page.isEmpty() && this.getLinesOnPage(specialHere) <= 0)) {
                                    ++pageForId;
                                    specialOnNextPage = true;
                                } else {
                                    boolean bl2 = pageFull = page.size() + 1 > this.getLinesOnPage(specialHere);
                                }
                            }
                            if (!specialOnNextPage && this.updateSpecials(id, pageForId)) {
                                specialOnNextPage = true;
                            }
                            if (!specialOnNextPage && !pageFull) continue;
                            if (!line.isEmpty()) {
                                page.add(line);
                            }
                            if (specialOnNextPage) {
                                --pos;
                            }
                            forceNewPage = true;
                            break block3;
                        }
                        if (Character.isWhitespace(token.charAt(0)) && currWidth == 0) continue;
                        line = line + token;
                        currWidth += textWidth;
                        continue;
                    }
                    formattingFromPreviousLine = TextFormatting.func_211164_a((String)line);
                    break;
                }
                line = line.trim();
                if (page.isEmpty() && line.isEmpty()) continue;
                page.add(line);
            }
            if (!(forceNewPage |= (linesMax = this.getLinesOnPage(this.entry.size())) <= 0) && page.stream().allMatch(String::isEmpty)) continue;
            if (page.size() > linesMax) {
                if (linesMax > 0) {
                    overflow.addAll(page.subList(linesMax, page.size()));
                    page = page.subList(0, linesMax - 1);
                } else {
                    page = new ArrayList();
                }
            }
            this.entry.add(page);
        }
        for (List<String> page : this.entry) {
            for (int i = 0; i < page.size(); ++i) {
                page.set(i, page.get(i).replace('\u00a0', ' '));
            }
        }
        this.specialByPage.keySet().stream().max(Comparator.naturalOrder()).ifPresent(maxPageWithSpecial -> {
            while (this.entry.size() <= maxPageWithSpecial) {
                this.entry.add(new ArrayList());
            }
        });
    }

    private int getWidth(String text) {
        if (LINEBREAK.matcher(text).matches()) {
            return 0;
        }
        switch (text) {
            case "<br>": 
            case "<np>": {
                return 0;
            }
        }
        if (text.startsWith("<link;")) {
            text = text.substring(text.indexOf(59) + 1);
            text = text.substring(text.indexOf(59) + 1, text.lastIndexOf(59));
        }
        return this.width.apply(text);
    }

    private int getLinesOnPage(int id) {
        return this.getLinesOnPage((SpecialManualElement)this.specialByPage.get(id));
    }

    private int getLinesOnPage(@Nullable SpecialManualElement elementOnPage) {
        int pixels = this.pixelsPerPage;
        if (elementOnPage != null) {
            pixels = this.pixelsPerPage - elementOnPage.getPixelsTaken();
        }
        return MathHelper.func_76128_c((double)((double)pixels / (double)this.pixelsPerLine.getAsInt()));
    }

    private boolean updateSpecials(String ref, int page) {
        if (this.specialByAnchor.containsKey(ref)) {
            Int2ObjectOpenHashMap specialByPageTmp = new Int2ObjectOpenHashMap();
            for (Map.Entry<Integer, SpecialManualElement> entry : this.specialByAnchor.get(ref).entrySet()) {
                int specialPage = page + entry.getKey();
                if (this.specialByPage.containsKey(specialPage)) {
                    return true;
                }
                specialByPageTmp.put(specialPage, (Object)entry.getValue());
            }
            this.specialByPage.putAll((Map)specialByPageTmp);
        } else if (!ref.equals(START)) {
            System.out.println("WARNING: Reference " + ref + " was found, but no special pages were registered for it");
        }
        this.pageByAnchor.put((Object)ref, page);
        return false;
    }

    public static String[] splitWhitespace(String in) {
        ArrayList<String> parts = new ArrayList<String>();
        int i = 0;
        while (i < in.length()) {
            StringBuilder here = new StringBuilder();
            char first = in.charAt(i);
            here.append(first);
            ++i;
            while (i < in.length()) {
                char hereC = in.charAt(i);
                byte action = TextSplitter.shouldSplit(first, hereC);
                if ((action & 1) != 0) {
                    here.append(in.charAt(i));
                    ++i;
                }
                if ((action & 2) == 0 && (action & 1) != 0) continue;
                break;
            }
            parts.add(here.toString());
        }
        return parts.toArray(new String[0]);
    }

    private static byte shouldSplit(char start, char here) {
        int ret = 1;
        if (Character.isWhitespace(start) ^ Character.isWhitespace(here)) {
            ret = 2;
        } else if (Character.isWhitespace(here)) {
            if (start == '\n' && here == '\r' || start == '\r' && here == '\n') {
                ret = 3;
            } else if (here == '\r' || here == '\n' || start == '\r' || start == '\n') {
                ret = 2;
            }
        }
        if (here == '<') {
            ret = 2;
        }
        if (start == '<') {
            ret = 1;
            if (here == '>') {
                ret = (byte)(ret | 2);
            }
        }
        return (byte)ret;
    }

    public List<List<String>> getEntryText() {
        return this.entry;
    }

    public Int2ObjectMap<SpecialManualElement> getSpecials() {
        return this.specialByPage;
    }

    public int getPageForAnchor(String anchor) {
        return this.pageByAnchor.getInt((Object)anchor);
    }

    public boolean hasAnchor(String anchor) {
        return this.pageByAnchor.containsKey((Object)anchor);
    }
}

