/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.shapes;

import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.shapes.CachedVoxelShapes;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class CachedShapesWithTransform<ShapeKey, TransformKey>
extends CachedVoxelShapes<Pair<ShapeKey, TransformKey>> {
    public CachedShapesWithTransform(Function<ShapeKey, List<AxisAlignedBB>> creator, BiFunction<TransformKey, AxisAlignedBB, AxisAlignedBB> transform) {
        super(p -> {
            List base = (List)creator.apply(p.getLeft());
            if (base == null) {
                return ImmutableList.of();
            }
            ArrayList ret = new ArrayList(base.size());
            for (AxisAlignedBB aabb : base) {
                ret.add(transform.apply(p.getRight(), aabb));
            }
            return ret;
        });
    }

    public VoxelShape get(ShapeKey shapeKey, TransformKey transformKey) {
        return this.get(Pair.of(shapeKey, transformKey));
    }

    public static CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> createForMultiblock(Function<BlockPos, List<AxisAlignedBB>> create) {
        return new CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>>(create, (key, box) -> {
            AxisAlignedBB mirrored = box;
            if (((Boolean)key.getRight()).booleanValue()) {
                mirrored = new AxisAlignedBB(1.0 - box.field_72340_a, box.field_72338_b, box.field_72339_c, 1.0 - box.field_72336_d, box.field_72337_e, box.field_72334_f);
            }
            return Utils.transformAABB(mirrored, (Direction)key.getLeft());
        });
    }

    public static VoxelShape get(CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> cache, MultiblockPartTileEntity<?> tile) {
        return cache.get(tile.posInMultiblock, (Pair<Direction, Boolean>)Pair.of((Object)tile.getFacing(), (Object)tile.getIsMirrored()));
    }
}

