/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.cokeoven;

import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIIngredientStackListBuilder;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class CokeOvenRecipeCategory
extends IERecipeCategory<CokeOvenRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("immersiveengineering", "cokeoven");
    private final IDrawableStatic tankOverlay;

    public CokeOvenRecipeCategory(IGuiHelper helper) {
        super(CokeOvenRecipe.class, helper, UID, "block.immersiveengineering.coke_oven");
        ResourceLocation background = new ResourceLocation("immersiveengineering", "textures/gui/coke_oven.png");
        this.setBackground(helper.createDrawable(background, 8, 16, 142, 54));
        this.setIcon(new ItemStack((IItemProvider)IEBlocks.Multiblocks.cokeOven));
        this.tankOverlay = helper.createDrawable(background, 178, 33, 16, 47);
    }

    public void setIngredients(CokeOvenRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, JEIIngredientStackListBuilder.make(recipe.input).build());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.output);
        ingredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack(IEContent.fluidCreosote, recipe.creosoteOutput));
    }

    public void setRecipe(IRecipeLayout recipeLayout, CokeOvenRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 21, 18);
        guiItemStacks.set(0, Arrays.asList(recipe.input.getMatchingStacks()));
        guiItemStacks.init(1, false, 76, 18);
        if (!recipe.output.func_190926_b()) {
            guiItemStacks.set(1, recipe.output);
        }
        if (recipe.creosoteOutput > 0) {
            IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
            guiFluidStacks.init(0, false, 121, 4, 16, 47, 5000, false, (IDrawable)this.tankOverlay);
            guiFluidStacks.set(0, new FluidStack(IEContent.fluidCreosote, recipe.creosoteOutput));
            guiFluidStacks.addTooltipCallback(JEIHelper.fluidTooltipCallback);
        }
    }
}

