/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MessageShaderManual
implements IMessage {
    private MessageType key;
    private ResourceLocation[] args;

    public MessageShaderManual(MessageType key, ResourceLocation ... args) {
        this.key = key;
        this.args = args;
    }

    public MessageShaderManual(PacketBuffer buf) {
        this.key = MessageType.values()[buf.readInt()];
        int l = buf.readInt();
        this.args = new ResourceLocation[l];
        for (int i = 0; i < l; ++i) {
            this.args[i] = new ResourceLocation(buf.func_150789_c(1000));
        }
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.key.ordinal());
        if (this.args != null) {
            buf.writeInt(this.args.length);
            for (ResourceLocation rl : this.args) {
                buf.func_180714_a(rl.toString());
            }
        } else {
            buf.writeInt(0);
        }
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        if (ctx.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            ServerPlayerEntity player = ctx.getSender();
            assert (player != null);
            UUID playerId = player.func_110124_au();
            ctx.enqueueWork(() -> {
                if (this.key == MessageType.SYNC) {
                    Collection received = ShaderRegistry.receivedShaders.get((Object)playerId);
                    ResourceLocation[] ss = received.toArray(new ResourceLocation[0]);
                    ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageShaderManual(MessageType.SYNC, ss));
                } else if (this.key == MessageType.UNLOCK && this.args.length > 0) {
                    ShaderRegistry.receivedShaders.put((Object)playerId, (Object)this.args[0]);
                } else if (this.key == MessageType.SPAWN && this.args.length > 0) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        ApiUtils.consumePlayerIngredient((PlayerEntity)player, ShaderRegistry.shaderRegistry.get((Object)this.args[0]).replicationCost);
                    }
                    ItemStack shaderStack = new ItemStack((IItemProvider)ShaderRegistry.itemShader);
                    ItemNBTHelper.putString(shaderStack, "shader_name", this.args[0].toString());
                    ItemEntity entityitem = player.func_71019_a(shaderStack, false);
                    if (entityitem != null) {
                        entityitem.func_174868_q();
                        entityitem.func_200217_b(player.func_110124_au());
                    }
                }
            });
        } else {
            ctx.enqueueWork(() -> {
                PlayerEntity player;
                if (this.key == MessageType.SYNC && (player = ImmersiveEngineering.proxy.getClientPlayer()) != null) {
                    UUID name = player.func_110124_au();
                    for (ResourceLocation shader : this.args) {
                        if (shader == null) continue;
                        ShaderRegistry.receivedShaders.put((Object)name, (Object)shader);
                    }
                }
            });
        }
    }

    public static enum MessageType {
        SYNC,
        UNLOCK,
        SPAWN;

    }
}

