/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SheetmetalTankTileEntity
extends MultiblockPartTileEntity<SheetmetalTankTileEntity>
implements IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IBlockBounds {
    public static TileEntityType<SheetmetalTankTileEntity> TYPE;
    public FluidTank tank = new FluidTank(512000);
    private int[] oldComps = new int[4];
    private int masterCompOld;
    private static final BlockPos ioTopOffset;
    private static final BlockPos ioBottomOffset;
    private static final Set<BlockPos> ioOffsets;
    @OnlyIn(value=Dist.CLIENT)
    private AxisAlignedBB renderAABB;

    public SheetmetalTankTileEntity() {
        super(IEMultiblocks.SHEETMETAL_TANK, TYPE, true);
    }

    @Override
    public String[] getOverlayText(PlayerEntity player, RayTraceResult mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack(player.func_184586_b(Hand.MAIN_HAND))) {
            SheetmetalTankTileEntity master = (SheetmetalTankTileEntity)this.master();
            FluidStack fs = master != null ? master.tank.getFluid() : this.tank.getFluid();
            String s = !fs.isEmpty() ? fs.getDisplayName().func_150254_d() + ": " + fs.getAmount() + "mB" : I18n.func_135052_a((String)"gui.immersiveengineering.empty", (Object[])new Object[0]);
            return new String[]{s};
        }
        return new String[0];
    }

    @Override
    public boolean useNixieFont(PlayerEntity player, RayTraceResult mop) {
        return false;
    }

    public void func_73660_a() {
        ApiUtils.checkForNeedlessTicking(this);
        if (!(this.isDummy() || this.field_145850_b.field_72995_K || this.isRSDisabled())) {
            for (Direction f : Direction.field_199792_n) {
                if (f == Direction.UP || this.tank.getFluidAmount() <= 0) continue;
                int outSize = Math.min(144, this.tank.getFluidAmount());
                FluidStack out = Utils.copyFluidStackWithAmount(this.tank.getFluid(), outSize, false);
                BlockPos outputPos = this.func_174877_v().func_177972_a(f);
                FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)outputPos, (Direction)f.func_176734_d()).ifPresent(output -> {
                    int accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE);
                    if (accepted > 0) {
                        int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.getAmount(), accepted), false), IFluidHandler.FluidAction.EXECUTE);
                        this.tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
                        this.markContainingBlockForUpdate(null);
                        this.updateComparatorValuesPart2();
                    }
                });
            }
        }
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(1, 0, 1));
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        CompoundNBT tankTag = this.tank.writeToNBT(new CompoundNBT());
        nbt.func_218657_a("tank", (INBT)tankTag);
    }

    @Override
    public VoxelShape getBlockBounds() {
        if (this.posInMultiblock.func_177958_n() % 2 == 0 && this.posInMultiblock.func_177956_o() == 0 && this.posInMultiblock.func_177952_p() % 2 == 0) {
            return VoxelShapes.func_197873_a((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)1.0, (double)0.625);
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        SheetmetalTankTileEntity master = (SheetmetalTankTileEntity)this.master();
        if (master != null && ioOffsets.contains(this.posInMultiblock)) {
            return new FluidTank[]{master.tank};
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        return ioOffsets.contains(this.posInMultiblock);
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return ioBottomOffset.equals((Object)this.posInMultiblock);
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        SheetmetalTankTileEntity master = (SheetmetalTankTileEntity)this.master();
        if (master != null && FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)master.tank)) {
            this.updateMasterBlock(null, true);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.offsetToMaster.equals((Object)BlockPos.field_177992_a) ? new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(2, 5, 2)) : new AxisAlignedBB(this.func_174877_v(), this.func_174877_v());
        }
        return this.renderAABB;
    }

    @Override
    public int getComparatorInputOverride() {
        if (ioBottomOffset.equals((Object)this.posInMultiblock)) {
            return 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
        }
        SheetmetalTankTileEntity master = (SheetmetalTankTileEntity)this.master();
        if (this.offsetToMaster.func_177956_o() >= 1 && master != null) {
            FluidTank t = master.tank;
            int layer = this.offsetToMaster.func_177956_o() - 1;
            int vol = t.getCapacity() / 4;
            int filled = t.getFluidAmount() - layer * vol;
            return Math.min(15, Math.max(0, 15 * filled / vol));
        }
        return 0;
    }

    private void updateComparatorValuesPart1() {
        int vol = this.tank.getCapacity() / 4;
        for (int i = 0; i < 4; ++i) {
            int filled = this.tank.getFluidAmount() - i * vol;
            this.oldComps[i] = Math.min(15, Math.max(15 * filled / vol, 0));
        }
        this.masterCompOld = 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
    }

    private void updateComparatorValuesPart2() {
        int vol = this.tank.getCapacity() / 6;
        if (15 * this.tank.getFluidAmount() / this.tank.getCapacity() != this.masterCompOld) {
            this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
        }
        BlockPos masterPos = this.field_174879_c.func_177973_b((Vec3i)this.offsetToMaster);
        for (int i = 0; i < 4; ++i) {
            int filled = this.tank.getFluidAmount() - i * vol;
            int now = Math.min(15, Math.max(15 * filled / vol, 0));
            if (now == this.oldComps[i]) continue;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos = masterPos.func_177982_a(x, i + 1, z);
                    this.field_145850_b.func_195593_d(pos, this.field_145850_b.func_180495_p(pos).func_177230_c());
                }
            }
        }
    }

    static {
        ioTopOffset = new BlockPos(1, 4, 1);
        ioBottomOffset = new BlockPos(1, 0, 1);
        ioOffsets = ImmutableSet.of((Object)ioTopOffset, (Object)ioBottomOffset);
    }
}

