/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBeltTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPumpTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.CapabilityReference;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BottlingMachineTileEntity
extends PoweredMultiblockTileEntity<BottlingMachineTileEntity, MultiblockRecipe>
implements ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IBlockBounds {
    public static TileEntityType<BottlingMachineTileEntity> TYPE;
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(8000)};
    public List<BottlingProcess> bottlingProcessQueue = new ArrayList<BottlingProcess>();
    private CapabilityReference<IItemHandler> outputCap = CapabilityReference.forTileEntity(this, () -> {
        Direction outDir = this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e();
        return new DirectionalBlockPos(this.getBlockPosForPos(new BlockPos(2, 1, 1)).func_177972_a(outDir), outDir.func_176734_d());
    }, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    LazyOptional<IItemHandler> insertionHandler = this.registerConstantCap(new BottlingMachineInventoryHandler(this));

    public BottlingMachineTileEntity() {
        super(IEMultiblocks.BOTTLING_MACHINE, 16000, true, TYPE);
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        ListNBT processNBT = nbt.func_150295_c("bottlingQueue", 10);
        this.bottlingProcessQueue.clear();
        for (int i = 0; i < processNBT.size(); ++i) {
            CompoundNBT tag = processNBT.func_150305_b(i);
            BottlingProcess process = BottlingProcess.readFromNBT(tag);
            this.bottlingProcessQueue.add(process);
        }
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        ListNBT processNBT = new ListNBT();
        for (BottlingProcess process : this.bottlingProcessQueue) {
            processNBT.add((Object)process.writeToNBT());
        }
        nbt.func_218657_a("bottlingQueue", (INBT)processNBT);
        nbt.func_218657_a("tank", (INBT)this.tanks[0].writeToNBT(new CompoundNBT()));
    }

    @Override
    public void receiveMessageFromClient(CompoundNBT message) {
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy() || this.isRSDisabled() || this.field_145850_b.field_72995_K) {
            return;
        }
        this.tickedProcesses = 0;
        int max = this.getMaxProcessPerTick();
        int i = 0;
        Iterator<BottlingProcess> processIterator = this.bottlingProcessQueue.iterator();
        this.tickedProcesses = 0;
        while (processIterator.hasNext() && i++ < max) {
            BottlingProcess process = processIterator.next();
            if (process.processStep(this)) {
                ++this.tickedProcesses;
            }
            if (!process.processFinished) continue;
            ItemStack output = !((ItemStack)process.items.get(1)).func_190926_b() ? (ItemStack)process.items.get(1) : (ItemStack)process.items.get(0);
            this.doProcessOutput(output);
            processIterator.remove();
        }
    }

    @Override
    public VoxelShape getBlockBounds() {
        if (new BlockPos(1, 0, 0).equals((Object)this.posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
        }
        if (this.posInMultiblock.func_177956_o() == 0 || new BlockPos(2, 1, 0).equals((Object)this.posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        if (this.posInMultiblock.func_177952_p() == 1 && this.posInMultiblock.func_177956_o() == 1) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
        }
        if (new BlockPos(1, 1, 0).equals((Object)this.posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);
        }
        if (new BlockPos(1, 1, 0).equals((Object)this.posInMultiblock)) {
            float xMax;
            float zMin;
            float xMin;
            Direction f;
            Direction direction = f = this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e();
            float f2 = f == Direction.EAST ? -0.0625f : (f == Direction.WEST ? 0.25f : (this.getFacing() == Direction.WEST ? 0.125f : (xMin = this.getFacing() == Direction.EAST ? 0.25f : 0.0f)));
            float f3 = this.getFacing() == Direction.NORTH ? 0.125f : (this.getFacing() == Direction.SOUTH ? 0.25f : (f == Direction.SOUTH ? -0.0625f : (zMin = f == Direction.NORTH ? 0.25f : 0.0f)));
            float f4 = f == Direction.EAST ? 0.75f : (f == Direction.WEST ? 1.0625f : (this.getFacing() == Direction.WEST ? 0.75f : (xMax = this.getFacing() == Direction.EAST ? 0.875f : 1.0f)));
            float zMax = this.getFacing() == Direction.NORTH ? 0.75f : (this.getFacing() == Direction.SOUTH ? 0.875f : (f == Direction.SOUTH ? 0.75f : (f == Direction.NORTH ? 1.0625f : 1.0f)));
            return VoxelShapes.func_197873_a((double)xMin, (double)0.0625, (double)zMin, (double)xMax, (double)0.6875, (double)zMax);
        }
        if (new BlockPos(1, 2, 1).equals((Object)this.posInMultiblock)) {
            float xMin = this.getFacing() == Direction.WEST ? 0.0f : 0.21875f;
            float zMin = this.getFacing() == Direction.NORTH ? 0.0f : 0.21875f;
            float xMax = this.getFacing() == Direction.EAST ? 1.0f : 0.78125f;
            float zMax = this.getFacing() == Direction.SOUTH ? 1.0f : 0.78125f;
            return VoxelShapes.func_197873_a((double)xMin, (double)-0.4375, (double)zMin, (double)xMax, (double)0.5625, (double)zMax);
        }
        if (new BlockPos(1, 2, 0).equals((Object)this.posInMultiblock)) {
            float xMax;
            float zMin;
            float xMin;
            float f = this.getFacing() == Direction.WEST ? 0.8125f : (xMin = this.getFacing() == Direction.EAST ? 0.0f : 0.125f);
            float f5 = this.getFacing() == Direction.NORTH ? 0.8125f : (zMin = this.getFacing() == Direction.SOUTH ? 0.0f : 0.125f);
            float f6 = this.getFacing() == Direction.WEST ? 1.0f : (xMax = this.getFacing() == Direction.EAST ? 0.1875f : 0.875f);
            float zMax = this.getFacing() == Direction.NORTH ? 1.0f : (this.getFacing() == Direction.SOUTH ? 0.1875f : 0.875f);
            return VoxelShapes.func_197873_a((double)xMin, (double)-1.0, (double)zMin, (double)xMax, (double)0.25, (double)zMax);
        }
        return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    @Override
    public Set<BlockPos> getEnergyPos() {
        return ImmutableSet.of((Object)new BlockPos(2, 1, 0));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(1, 0, 1));
    }

    @Override
    public void replaceStructureBlock(BlockPos pos, BlockState state, ItemStack stack, int h, int l, int w) {
        TileEntity tile;
        super.replaceStructureBlock(pos, state, stack, h, l, w);
        if (h == 2 && l == 1 && w == 1) {
            TileEntity tile2 = this.field_145850_b.func_175625_s(pos);
            if (tile2 instanceof FluidPumpTileEntity) {
                ((FluidPumpTileEntity)tile2).setDummy(true);
            }
        } else if (h == 1 && l == 0 && (tile = this.field_145850_b.func_175625_s(pos)) instanceof ConveyorBeltTileEntity) {
            ((ConveyorBeltTileEntity)tile).setFacing(this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e());
        }
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        if (new BlockPos(0, 1, 1).equals((Object)this.posInMultiblock) && !world.field_72995_K && entity != null && entity.func_70089_S() && entity instanceof ItemEntity) {
            BottlingMachineTileEntity master = (BottlingMachineTileEntity)this.master();
            if (master == null) {
                return;
            }
            ItemStack stack = ((ItemEntity)entity).func_92059_d();
            if (stack.func_190926_b()) {
                return;
            }
            if (master.bottlingProcessQueue.size() < master.getProcessQueueMaxLength()) {
                float dist = 1.0f;
                BottlingProcess p = null;
                if (master.bottlingProcessQueue.size() > 0 && (p = master.bottlingProcessQueue.get(master.bottlingProcessQueue.size() - 1)) != null) {
                    dist = (float)p.processTick / (float)p.maxProcessTick;
                }
                if (p != null && dist < master.getMinProcessDistance((PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe>)null)) {
                    return;
                }
                p = new BottlingProcess(Utils.copyStackWithAmount(stack, 1));
                master.bottlingProcessQueue.add(p);
                master.func_70296_d();
                master.markContainingBlockForUpdate(null);
                stack.func_190918_g(1);
                if (stack.func_190916_E() <= 0) {
                    entity.func_70106_y();
                }
            }
        }
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.outputCap, output, false)).func_190926_b()) {
            Direction outDir = this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e();
            BlockPos pos = this.func_174877_v().func_177967_a(outDir, 2);
            Utils.dropStackAtPos(this.field_145850_b, pos, output, outDir);
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 2;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 2;
    }

    @Override
    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe> process) {
        return 0.5f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected MultiblockRecipe getRecipeForId(ResourceLocation id) {
        return null;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            BottlingMachineTileEntity master = (BottlingMachineTileEntity)this.master();
            if (master == null) {
                return LazyOptional.empty();
            }
            if (new BlockPos(0, 1, 1).equals((Object)this.posInMultiblock) && facing == (this.getIsMirrored() ? this.getFacing().func_176746_e() : this.getFacing().func_176735_f())) {
                return master.insertionHandler.cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        BottlingMachineTileEntity master = (BottlingMachineTileEntity)this.master();
        if (master != null && BlockPos.field_177992_a.equals((Object)this.posInMultiblock) && (side == null || side.func_176740_k() != Direction.Axis.Y)) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        if (BlockPos.field_177992_a.equals((Object)this.posInMultiblock) && (side == null || side.func_176740_k() != Direction.Axis.Y)) {
            BottlingMachineTileEntity master = (BottlingMachineTileEntity)this.master();
            return master != null && master.tanks[iTank].getFluidAmount() < master.tanks[iTank].getCapacity();
        }
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    @Override
    public Direction[] sigOutputDirections() {
        if (new BlockPos(2, 1, 1).equals((Object)this.posInMultiblock)) {
            return new Direction[]{this.getIsMirrored() ? this.getFacing().func_176735_f() : this.getFacing().func_176746_e()};
        }
        return new Direction[0];
    }

    public static class BottlingMachineInventoryHandler
    implements IItemHandlerModifiable {
        BottlingMachineTileEntity multiblock;

        public BottlingMachineInventoryHandler(BottlingMachineTileEntity multiblock) {
            this.multiblock = multiblock;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.multiblock.bottlingProcessQueue.size() < this.multiblock.getProcessQueueMaxLength()) {
                stack = stack.func_77946_l();
                float dist = 1.0f;
                BottlingProcess p = null;
                if (this.multiblock.bottlingProcessQueue.size() > 0 && (p = this.multiblock.bottlingProcessQueue.get(this.multiblock.bottlingProcessQueue.size() - 1)) != null) {
                    dist = (float)p.processTick / (float)p.maxProcessTick;
                }
                if (p != null && dist < this.multiblock.getMinProcessDistance((PoweredMultiblockTileEntity.MultiblockProcess<MultiblockRecipe>)null)) {
                    return stack;
                }
                if (!simulate) {
                    p = new BottlingProcess(Utils.copyStackWithAmount(stack, 1));
                    this.multiblock.bottlingProcessQueue.add(p);
                    this.multiblock.func_70296_d();
                    this.multiblock.markContainingBlockForUpdate(null);
                }
                stack.func_190918_g(1);
                if (stack.func_190916_E() <= 0) {
                    stack = ItemStack.field_190927_a;
                }
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }

    public static class BottlingProcess {
        public NonNullList<ItemStack> items;
        public int processTick;
        public int maxProcessTick;
        boolean processFinished;

        public BottlingProcess(ItemStack input) {
            this.maxProcessTick = (int)(120.0 * (Double)IEConfig.MACHINES.bottlingMachineConfig.timeModifier.get());
            this.processFinished = false;
            this.items = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
            this.items.set(0, (Object)input);
        }

        public boolean processStep(BottlingMachineTileEntity tile) {
            int energyExtracted = (int)(8.0 * (Double)IEConfig.MACHINES.bottlingMachineConfig.energyModifier.get());
            if (tile.energyStorage.extractEnergy(energyExtracted, true) >= energyExtracted) {
                FluidStack fs;
                tile.energyStorage.extractEnergy(energyExtracted, false);
                if (++this.processTick == (int)((double)this.maxProcessTick * 0.4375) && !(fs = tile.tanks[0].getFluid()).isEmpty()) {
                    BottlingMachineRecipe recipe = BottlingMachineRecipe.findRecipe((ItemStack)this.items.get(0), fs);
                    if (recipe != null) {
                        if (tile.tanks[0].drain(recipe.fluidInput, IFluidHandler.FluidAction.SIMULATE).getAmount() == recipe.fluidInput.getAmount()) {
                            this.items.set(1, recipe.getActualItemOutputs(tile).get(0));
                            tile.tanks[0].drain(recipe.fluidInput, IFluidHandler.FluidAction.EXECUTE);
                        }
                    } else {
                        ItemStack ret = Utils.fillFluidContainer((IFluidHandler)tile.tanks[0], (ItemStack)this.items.get(0), ItemStack.field_190927_a, null);
                        if (!ret.func_190926_b()) {
                            this.items.set(1, (Object)ret);
                        }
                    }
                    if (((ItemStack)this.items.get(1)).func_190926_b()) {
                        this.items.set(1, this.items.get(0));
                    }
                }
                if (this.processTick >= this.maxProcessTick) {
                    this.processFinished = true;
                }
                return true;
            }
            return false;
        }

        public CompoundNBT writeToNBT() {
            CompoundNBT nbt = new CompoundNBT();
            if (!((ItemStack)this.items.get(0)).func_190926_b()) {
                nbt.func_218657_a("input", (INBT)((ItemStack)this.items.get(0)).func_77955_b(new CompoundNBT()));
            }
            if (!((ItemStack)this.items.get(1)).func_190926_b()) {
                nbt.func_218657_a("output", (INBT)((ItemStack)this.items.get(1)).func_77955_b(new CompoundNBT()));
            }
            nbt.func_74768_a("processTick", this.processTick);
            return nbt;
        }

        public static BottlingProcess readFromNBT(CompoundNBT nbt) {
            ItemStack input = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("input"));
            BottlingProcess process = new BottlingProcess(input);
            if (nbt.func_150297_b("output", 10)) {
                process.items.set(1, (Object)ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("output")));
            }
            process.processTick = nbt.func_74762_e("processTick");
            return process;
        }
    }
}

