/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import java.lang.reflect.Field;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.pipeline.BlockInfo;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;

public class SmartLightingQuad
extends BakedQuad {
    private static Field parent;
    private static Field blockInfo;
    BlockPos blockPos;
    int[][] relativePos;
    boolean ignoreLight;
    public static int staticBrightness;

    public SmartLightingQuad(int[] vertexDataIn, int tintIndexIn, Direction faceIn, TextureAtlasSprite spriteIn, BlockPos p) {
        super(vertexDataIn, tintIndexIn, faceIn, spriteIn, false);
        this.blockPos = p;
        this.relativePos = new int[4][];
        this.ignoreLight = false;
        for (int i = 0; i < 4; ++i) {
            this.relativePos[i] = new int[]{(int)Math.floor(Float.intBitsToFloat(vertexDataIn[7 * i])), (int)Math.floor(Float.intBitsToFloat(vertexDataIn[7 * i + 1])), (int)Math.floor(Float.intBitsToFloat(vertexDataIn[7 * i + 2]))};
        }
    }

    public SmartLightingQuad(int[] vertexDataIn, int tintIndexIn, Direction faceIn, TextureAtlasSprite spriteIn) {
        super(vertexDataIn, tintIndexIn, faceIn, spriteIn, false);
        this.ignoreLight = true;
    }

    public void pipe(IVertexConsumer consumer) {
        ILightReader world = null;
        BlockInfo info = null;
        if (consumer instanceof VertexLighterFlat) {
            try {
                info = (BlockInfo)blockInfo.get(consumer);
                world = info.getWorld();
                consumer = (IVertexConsumer)parent.get(consumer);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        consumer.setQuadOrientation(this.func_178210_d());
        if (this.func_178212_b()) {
            consumer.setQuadTint(this.func_178211_c());
        }
        float[] data = new float[4];
        VertexFormat format = consumer.getVertexFormat();
        int count = format.func_227894_c_().size();
        int[] eMap = LightUtil.mapFormats((VertexFormat)format, (VertexFormat)DefaultVertexFormats.field_176600_a);
        int itemCount = DefaultVertexFormats.field_176600_a.func_227894_c_().size();
        eMap[eMap.length - 1] = 2;
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < count; ++e) {
                if (eMap[e] != itemCount) {
                    if (((VertexFormatElement)format.func_227894_c_().get(e)).func_177375_c() == VertexFormatElement.Usage.UV && ((VertexFormatElement)format.func_227894_c_().get(e)).func_177367_b() == VertexFormatElement.Type.SHORT) {
                        int brightness;
                        if (!this.ignoreLight && world != null) {
                            BlockPos here = this.blockPos.func_177982_a(this.relativePos[v][0], this.relativePos[v][1], this.relativePos[v][2]);
                            brightness = world.func_226659_b_(here, 0);
                        } else {
                            brightness = staticBrightness;
                        }
                        data[0] = (float)(brightness >> 4 & 0xF) * 32.0f / 65535.0f;
                        data[1] = (float)(brightness >> 20 & 0xF) * 32.0f / 65535.0f;
                    } else {
                        LightUtil.unpack((int[])this.func_178209_a(), (float[])data, (VertexFormat)DefaultVertexFormats.field_176600_a, (int)v, (int)eMap[e]);
                    }
                    consumer.put(e, data);
                    continue;
                }
                consumer.put(e, new float[]{0.0f});
            }
        }
    }

    static {
        try {
            blockInfo = VertexLighterFlat.class.getDeclaredField("blockInfo");
            blockInfo.setAccessible(true);
            parent = QuadGatheringTransformer.class.getDeclaredField("parent");
            parent.setAccessible(true);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

