/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.client.models.SimpleUVModelTransform;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DynamicModelLoader {
    private static Set<Material> requestedTextures = new HashSet<Material>();
    private static Set<ResourceLocation> manualTextureRequests = new HashSet<ResourceLocation>();
    private static final Multimap<ModelWithTransforms, ModelResourceLocation> requestedModels = HashMultimap.create();
    private static Map<ModelWithTransforms, IUnbakedModel> unbakedModels = new HashMap<ModelWithTransforms, IUnbakedModel>();
    private static Class<? extends IUnbakedModel> VANILLA_MODEL_WRAPPER;
    private static Field BASE_MODEL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void modelBake(ModelBakeEvent evt) {
        IELogger.logger.debug("Baking models");
        for (Map.Entry<ModelWithTransforms, IUnbakedModel> unbaked : unbakedModels.entrySet()) {
            ModelRequest conf = unbaked.getKey().model;
            Object state = unbaked.getKey().transforms.isEmpty() ? ModelRotation.func_177524_a((int)conf.rotX, (int)conf.rotY) : new SimpleUVModelTransform(ImmutableMap.copyOf(unbaked.getKey().transforms), conf.uvLock);
            IBakedModel baked = unbaked.getValue().func_225613_a_((ModelBakery)evt.getModelLoader(), ModelLoader.defaultTextureGetter(), (IModelTransform)state, conf.name);
            Multimap<ModelWithTransforms, ModelResourceLocation> multimap = requestedModels;
            synchronized (multimap) {
                for (ModelResourceLocation mrl : requestedModels.get((Object)unbaked.getKey())) {
                    evt.getModelRegistry().put(mrl, baked);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void textureStitch(TextureStitchEvent.Pre evt) {
        if (evt.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            return;
        }
        IELogger.logger.debug("Loading dynamic models");
        try {
            Multimap<ModelWithTransforms, ModelResourceLocation> multimap = requestedModels;
            synchronized (multimap) {
                for (ModelWithTransforms reqModel : requestedModels.keySet()) {
                    BlockModel model = (BlockModel)ModelLoaderRegistry.ExpandedBlockModelDeserializer.INSTANCE.fromJson((JsonElement)reqModel.model.data, BlockModel.class);
                    HashSet missingTexErrors = new HashSet();
                    requestedTextures.addAll(model.func_225614_a_(DynamicModelLoader::getVanillaModel, missingTexErrors));
                    if (!missingTexErrors.isEmpty()) {
                        throw new RuntimeException("Missing textures: " + missingTexErrors);
                    }
                    unbakedModels.put(reqModel, (IUnbakedModel)model);
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            System.exit(1);
        }
        IELogger.logger.debug("Stitching textures!");
        for (ResourceLocation resourceLocation : manualTextureRequests) {
            evt.addSprite(resourceLocation);
        }
        for (Material material : requestedTextures) {
            evt.addSprite(material.func_229313_b_());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void modelRegistry(ModelRegistryEvent evt) {
        requestedTextures.clear();
        unbakedModels.clear();
    }

    private static IUnbakedModel getVanillaModel(ResourceLocation loc) {
        if (loc.func_110623_a().equals("builtin/generated")) {
            return (IUnbakedModel)Util.func_200696_a((Object)BlockModel.func_178294_a((String)"{}"), p_209273_0_ -> {
                p_209273_0_.field_178317_b = "generation marker";
            });
        }
        IUnbakedModel wrapper = (IUnbakedModel)ModelLoader.defaultModelGetter().apply(loc);
        if (VANILLA_MODEL_WRAPPER.isInstance(wrapper)) {
            try {
                return (BlockModel)BASE_MODEL.get(wrapper);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return wrapper;
    }

    public static void requestTexture(ResourceLocation name) {
        manualTextureRequests.add(name);
    }

    public static void requestModel(ModelRequest reqModel, ModelResourceLocation name) {
        DynamicModelLoader.requestModel(reqModel, name, (Map<ItemCameraTransforms.TransformType, TransformationMatrix>)ImmutableMap.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestModel(ModelRequest reqModel, ModelResourceLocation name, Map<ItemCameraTransforms.TransformType, TransformationMatrix> transforms) {
        Multimap<ModelWithTransforms, ModelResourceLocation> multimap = requestedModels;
        synchronized (multimap) {
            requestedModels.put((Object)new ModelWithTransforms(reqModel, transforms), (Object)name);
        }
    }

    static {
        try {
            VANILLA_MODEL_WRAPPER = Class.forName("net.minecraftforge.client.model.ModelLoader$VanillaModelWrapper");
            BASE_MODEL = VANILLA_MODEL_WRAPPER.getDeclaredField("model");
            BASE_MODEL.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private static class ModelWithTransforms {
        final ModelRequest model;
        final Map<ItemCameraTransforms.TransformType, TransformationMatrix> transforms;

        private ModelWithTransforms(ModelRequest model, Map<ItemCameraTransforms.TransformType, TransformationMatrix> transforms) {
            this.model = model;
            this.transforms = transforms;
        }
    }

    public static class ModelRequest {
        private final JsonObject data;
        private final int rotX;
        private final int rotY;
        private final boolean uvLock;
        private final ResourceLocation name;

        public ModelRequest(ResourceLocation name, ResourceLocation loader, JsonObject data, int rotX, int rotY, boolean uvLock) {
            this.name = name;
            this.data = data;
            this.rotX = rotX;
            this.rotY = rotY;
            this.uvLock = uvLock;
            Preconditions.checkArgument((!data.has("loader") ? 1 : 0) != 0);
            this.data.addProperty("loader", loader.toString());
        }

        public static ModelRequest ieObj(ResourceLocation loc, int rotY) {
            return ModelRequest.withModel(loc, new ResourceLocation("immersiveengineering", "ie_obj"), rotY);
        }

        public static ModelRequest obj(ResourceLocation loc, int rotY) {
            return ModelRequest.withModel(loc, new ResourceLocation("forge", "obj"), rotY);
        }

        private static ModelRequest withModel(ResourceLocation model, ResourceLocation loader, int rotY) {
            JsonObject json = new JsonObject();
            json.addProperty("model", new ResourceLocation(model.func_110624_b(), "models/" + model.func_110623_a()).toString());
            json.addProperty("flip-v", Boolean.valueOf(true));
            return new ModelRequest(model, loader, json, 0, rotY, true);
        }
    }
}

