/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.ILocalHandlerProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public interface IImmersiveConnectable
extends ILocalHandlerProvider {
    public boolean canConnect();

    public BlockPos getConnectionMaster(@Nullable WireType var1, TargetingInfo var2);

    public boolean canConnectCable(WireType var1, ConnectionPoint var2, Vec3i var3);

    public void connectCable(WireType var1, ConnectionPoint var2, IImmersiveConnectable var3, ConnectionPoint var4);

    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo var1, Vec3i var2);

    @Deprecated
    default public void onEnergyPassthrough(int amount) {
    }

    @Deprecated
    default public void onEnergyPassthrough(double amount) {
        this.onEnergyPassthrough((int)amount);
    }

    @Deprecated
    default public void addAvailableEnergy(float amount, Consumer<Float> consume) {
    }

    public void removeCable(@Nullable Connection var1, ConnectionPoint var2);

    public Vec3d getConnectionOffset(@Nonnull Connection var1, ConnectionPoint var2);

    default public Set<BlockPos> getIgnored(IImmersiveConnectable other) {
        return ImmutableSet.of((Object)ApiUtils.toBlockPos(this));
    }

    public Collection<ConnectionPoint> getConnectionPoints();

    default public Iterable<? extends Connection> getInternalConnections() {
        return ImmutableList.of();
    }
}

