/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.RegistryObject;

public class MixerRecipe
extends MultiblockRecipe {
    public static IRecipeType<MixerRecipe> TYPE = IRecipeType.func_222147_a((String)"immersiveengineering:mixer");
    public static RegistryObject<IERecipeSerializer<MixerRecipe>> SERIALIZER;
    public static float energyModifier;
    public static float timeModifier;
    public final IngredientWithSize[] itemInputs;
    public final FluidStack fluidInput;
    public final FluidStack fluidOutput;
    public final int fluidAmount;
    public static Map<ResourceLocation, MixerRecipe> recipeList;

    public MixerRecipe(ResourceLocation id, FluidStack fluidOutput, FluidStack fluidInput, IngredientWithSize[] itemInputs, int energy) {
        super(ItemStack.field_190927_a, TYPE, id);
        this.fluidOutput = fluidOutput;
        this.fluidAmount = fluidOutput.getAmount();
        this.fluidInput = fluidInput;
        this.itemInputs = itemInputs;
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor((float)fluidOutput.getAmount() * timeModifier);
        this.fluidInputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidInput});
        this.setInputListWithSizes(Lists.newArrayList((Object[])this.itemInputs));
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
    }

    @Override
    protected IERecipeSerializer<MixerRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public static MixerRecipe findRecipe(FluidStack fluid, NonNullList<ItemStack> components) {
        if (fluid == null) {
            return null;
        }
        for (MixerRecipe recipe : recipeList.values()) {
            if (!recipe.matches(fluid, components)) continue;
            return recipe;
        }
        return null;
    }

    public FluidStack getFluidOutput(FluidStack input, NonNullList<ItemStack> components) {
        return this.fluidOutput;
    }

    public boolean matches(FluidStack fluid, NonNullList<ItemStack> components) {
        return this.compareToInputs(fluid, components, this.fluidInput, this.itemInputs);
    }

    protected boolean compareToInputs(FluidStack fluid, NonNullList<ItemStack> components, FluidStack fluidInput, IngredientWithSize[] itemInputs) {
        if (fluid != null && fluid.containsFluid(fluidInput)) {
            ArrayList<ItemStack> queryList = new ArrayList<ItemStack>(components.size());
            for (ItemStack s : components) {
                if (s.func_190926_b()) continue;
                queryList.add(s.func_77946_l());
            }
            for (IngredientWithSize add : itemInputs) {
                if (add == null) continue;
                int addAmount = add.getCount();
                Iterator it = queryList.iterator();
                while (it.hasNext()) {
                    ItemStack query = (ItemStack)it.next();
                    if (query.func_190926_b()) continue;
                    if (add.test(query)) {
                        if (query.func_190916_E() > addAmount) {
                            query.func_190918_g(addAmount);
                            addAmount = 0;
                        } else {
                            addAmount -= query.func_190916_E();
                            query.func_190920_e(0);
                        }
                    }
                    if (query.func_190916_E() <= 0) {
                        it.remove();
                    }
                    if (addAmount > 0) continue;
                    break;
                }
                if (addAmount <= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int[] getUsedSlots(FluidStack input, NonNullList<ItemStack> components) {
        HashSet<Integer> usedSlotSet = new HashSet<Integer>();
        block0: for (IngredientWithSize ingr : this.itemInputs) {
            for (int j = 0; j < components.size(); ++j) {
                if (usedSlotSet.contains(j) || ((ItemStack)components.get(j)).func_190926_b() || !ingr.test((ItemStack)components.get(j))) continue;
                usedSlotSet.add(j);
                continue block0;
            }
        }
        int it = 0;
        int[] processSlots = new int[usedSlotSet.size()];
        for (Integer slot : usedSlotSet) {
            processSlots[it++] = slot;
        }
        return processSlots;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    @Override
    public boolean shouldCheckItemAvailability() {
        return false;
    }

    static {
        energyModifier = 1.0f;
        timeModifier = 1.0f;
    }
}

