/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.DataHandlerUtils;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;

public class TurbineCache
extends MultiblockCache<SynchronizedTurbineData>
implements IMekanismGasHandler,
IMekanismStrictEnergyHandler {
    private final List<IGasTank> gasTanks = Collections.singletonList(BasicGasTank.create((long)Long.MAX_VALUE, (IMekanismGasHandler)this));
    private final List<IEnergyContainer> energyContainers = Collections.singletonList(BasicEnergyContainer.create((FloatingLong)FloatingLong.MAX_VALUE, (IMekanismStrictEnergyHandler)this));
    public TileEntityGasTank.GasMode dumpMode = TileEntityGasTank.GasMode.IDLE;

    public void apply(SynchronizedTurbineData data) {
        data.setTankData(this.gasTanks);
        data.setContainerData(this.energyContainers);
        data.dumpMode = this.dumpMode;
    }

    public void sync(SynchronizedTurbineData data) {
        List<IGasTank> tanksToCopy = data.getGasTanks(null);
        for (int i = 0; i < tanksToCopy.size(); ++i) {
            if (i >= this.gasTanks.size()) continue;
            this.gasTanks.get(i).setStack(tanksToCopy.get(i).getStack());
        }
        List<IEnergyContainer> containersToCopy = data.getEnergyContainers(null);
        for (int i = 0; i < containersToCopy.size(); ++i) {
            if (i >= this.energyContainers.size()) continue;
            this.energyContainers.get(i).setEnergy(containersToCopy.get(i).getEnergy());
        }
        this.dumpMode = data.dumpMode;
    }

    public void load(CompoundNBT nbtTags) {
        DataHandlerUtils.readTanks(this.getGasTanks(null), (ListNBT)nbtTags.func_150295_c("GasTanks", 10));
        DataHandlerUtils.readContainers(this.getEnergyContainers(null), (ListNBT)nbtTags.func_150295_c("EnergyContainers", 10));
        NBTUtils.setEnumIfPresent((CompoundNBT)nbtTags, (String)"dumping", TileEntityGasTank.GasMode::byIndexStatic, mode -> {
            this.dumpMode = mode;
        });
    }

    public void save(CompoundNBT nbtTags) {
        nbtTags.func_218657_a("GasTanks", (INBT)DataHandlerUtils.writeTanks(this.getGasTanks(null)));
        nbtTags.func_218657_a("EnergyContainers", (INBT)DataHandlerUtils.writeContainers(this.getEnergyContainers(null)));
        nbtTags.func_74768_a("dumping", this.dumpMode.ordinal());
    }

    @Nonnull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasTanks;
    }

    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    public void onContentsChanged() {
    }
}

