/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.rangedpumps.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    private ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private ForgeConfigSpec spec;
    private ForgeConfigSpec.IntValue range;
    private ForgeConfigSpec.IntValue speed;
    private ForgeConfigSpec.IntValue tankCapacity;
    private ForgeConfigSpec.IntValue energyCapacity;
    private ForgeConfigSpec.IntValue energyUsagePerMove;
    private ForgeConfigSpec.IntValue energyUsagePerDrain;
    private ForgeConfigSpec.BooleanValue useEnergy;
    private ForgeConfigSpec.BooleanValue replaceLiquidWithBlock;
    private ForgeConfigSpec.ConfigValue<String> blockIdToReplaceLiquidsWith;

    public ServerConfig() {
        this.builder.push("pump");
        this.range = this.builder.comment("The range of the pump").defineInRange("range", 64, 0, 1024);
        this.speed = this.builder.comment("The interval in ticks for when to move on to the next block (higher is slower)").defineInRange("speed", 8, 0, 1024);
        this.tankCapacity = this.builder.comment("The capacity of the internal pump tank").defineInRange("tankCapacity", 32000, 1000, Integer.MAX_VALUE);
        this.energyCapacity = this.builder.comment("The capacity of the energy storage").defineInRange("energyCapacity", 32000, 0, Integer.MAX_VALUE);
        this.energyUsagePerMove = this.builder.comment("Energy drained when moving to the next block").defineInRange("energyUsagePerMove", 0, 0, Integer.MAX_VALUE);
        this.energyUsagePerDrain = this.builder.comment("Energy drained when draining liquid").defineInRange("energyUsagePerDrain", 100, 0, Integer.MAX_VALUE);
        this.useEnergy = this.builder.comment("Whether the pump uses energy to work").define("useEnergy", true);
        this.replaceLiquidWithBlock = this.builder.comment("Replaces liquids that are removed with a block defined in 'blockIdToReplaceLiquidsWith' (to reduce lag)").define("replaceLiquidWithBlock", true);
        this.blockIdToReplaceLiquidsWith = this.builder.comment("The block that liquids are replaced with when 'replaceLiquidWithBlock' is true").define("blockIdToReplaceLiquidsWith", (Object)"minecraft:stone");
        this.builder.pop();
        this.spec = this.builder.build();
    }

    public int getRange() {
        return (Integer)this.range.get();
    }

    public int getSpeed() {
        return (Integer)this.speed.get();
    }

    public int getTankCapacity() {
        return (Integer)this.tankCapacity.get();
    }

    public int getEnergyCapacity() {
        return (Integer)this.energyCapacity.get();
    }

    public int getEnergyUsagePerMove() {
        return (Integer)this.energyUsagePerMove.get();
    }

    public int getEnergyUsagePerDrain() {
        return (Integer)this.energyUsagePerDrain.get();
    }

    public boolean getUseEnergy() {
        return (Boolean)this.useEnergy.get();
    }

    public boolean getReplaceLiquidWithBlock() {
        return (Boolean)this.replaceLiquidWithBlock.get();
    }

    public String getBlockIdToReplaceLiquidsWith() {
        return (String)this.blockIdToReplaceLiquidsWith.get();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }
}

