/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;
import net.telepathicgrunt.bumblezone.items.BzItems;

@Mod.EventBusSubscriber(modid="the_bumblezone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SugarWaterEvents {
    public static Block SUGAR_WATER_BLOCK;

    public static void setup() {
        SUGAR_WATER_BLOCK = ((FlowingFluidBlock)BzBlocks.SUGAR_WATER_BLOCK.get()).func_176223_P().func_177230_c();
    }

    @SubscribeEvent
    public static void getSugarWater(PlayerInteractEvent.RightClickItem event) {
        Hand playerHand;
        ItemStack itemstack;
        PlayerEntity playerEntity = (PlayerEntity)event.getEntity();
        World world = event.getWorld();
        RayTraceResult raytraceresult = SugarWaterEvents.rayTrace(world, playerEntity, RayTraceContext.FluidMode.SOURCE_ONLY);
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK && world.func_180495_p(((BlockRayTraceResult)raytraceresult).func_216350_a()) == ((FlowingFluidBlock)BzBlocks.SUGAR_WATER_BLOCK.get()).func_176223_P() && (itemstack = playerEntity.func_184586_b(playerHand = event.getHand())).func_77973_b() == Items.field_151069_bo) {
            world.func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            if (!playerEntity.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            if (itemstack.func_190926_b()) {
                playerEntity.func_184611_a(playerHand, new ItemStack((IItemProvider)BzItems.SUGAR_WATER_BOTTLE.get()));
            } else if (!playerEntity.field_71071_by.func_70441_a(new ItemStack((IItemProvider)BzItems.SUGAR_WATER_BOTTLE.get()))) {
                playerEntity.func_71019_a(new ItemStack((IItemProvider)BzItems.SUGAR_WATER_BOTTLE.get()), false);
            }
            event.setCanceled(true);
        }
    }

    protected static RayTraceResult rayTrace(World world, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        Vec3d eyePos = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float yTargetNormalized = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float xTargetNormalized = f3 * f4;
        float zTargetNormalized = f2 * f4;
        double targetDistance = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        Vec3d targetPos = eyePos.func_72441_c((double)xTargetNormalized * targetDistance, (double)yTargetNormalized * targetDistance, (double)zTargetNormalized * targetDistance);
        return world.func_217299_a(new RayTraceContext(eyePos, targetPos, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }
}

