/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.util;

import com.mojang.authlib.GameProfile;
import com.raoulvdberge.refinedstorage.render.Styles;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public final class WorldUtils {
    public static void updateBlock(@Nullable World world, BlockPos pos) {
        if (world != null) {
            BlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public static IItemHandler getItemHandler(@Nullable TileEntity tile, Direction side) {
        if (tile == null) {
            return null;
        }
        IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).orElse(null);
        if (handler == null) {
            if (side != null && tile instanceof ISidedInventory) {
                handler = new SidedInvWrapper((ISidedInventory)tile, side);
            } else if (tile instanceof IInventory) {
                handler = new InvWrapper((IInventory)tile);
            }
        }
        return handler;
    }

    public static IFluidHandler getFluidHandler(@Nullable TileEntity tile, Direction side) {
        if (tile != null) {
            return (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).orElse(null);
        }
        return null;
    }

    public static FakePlayer getFakePlayer(ServerWorld world, @Nullable UUID owner) {
        PlayerProfileCache profileCache;
        GameProfile profile;
        if (owner != null && (profile = (profileCache = world.func_73046_m().func_152358_ax()).func_152652_a(owner)) != null) {
            return FakePlayerFactory.get((ServerWorld)world, (GameProfile)profile);
        }
        return FakePlayerFactory.getMinecraft((ServerWorld)world);
    }

    public static void sendNoPermissionMessage(PlayerEntity player) {
        player.func_145747_a(new TranslationTextComponent("misc.refinedstorage.security.no_permission", new Object[0]).func_150255_a(Styles.RED));
    }

    public static RayTraceResult rayTracePlayer(World world, PlayerEntity player) {
        double reachDistance = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        Vec3d base = player.func_174824_e(1.0f);
        Vec3d look = player.func_70040_Z();
        Vec3d target = base.func_72441_c(look.field_72450_a * reachDistance, look.field_72448_b * reachDistance, look.field_72449_c * reachDistance);
        return world.func_217299_a(new RayTraceContext(base, target, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
    }
}

