/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.tracker;

import com.raoulvdberge.refinedstorage.api.storage.tracker.IStorageTracker;
import com.raoulvdberge.refinedstorage.api.storage.tracker.StorageTrackerEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class ItemStorageTracker
implements IStorageTracker<ItemStack> {
    private static final String NBT_STACK = "Stack";
    private static final String NBT_NAME = "Name";
    private static final String NBT_TIME = "Time";
    private final Map<Key, StorageTrackerEntry> changes = new HashMap<Key, StorageTrackerEntry>();
    private final Runnable listener;

    public ItemStorageTracker(Runnable listener) {
        this.listener = listener;
    }

    @Override
    public void changed(PlayerEntity player, ItemStack stack) {
        this.changes.put(new Key(stack), new StorageTrackerEntry(System.currentTimeMillis(), player.func_200200_C_().func_150254_d()));
        this.listener.run();
    }

    @Override
    public StorageTrackerEntry get(ItemStack stack) {
        return this.changes.get(new Key(stack));
    }

    public void readFromNbt(ListNBT list) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            ItemStack stack = StackUtils.deserializeStackFromNbt(tag.func_74775_l(NBT_STACK));
            if (stack.func_190926_b()) continue;
            this.changes.put(new Key(stack), new StorageTrackerEntry(tag.func_74763_f(NBT_TIME), tag.func_74779_i(NBT_NAME)));
        }
    }

    public ListNBT serializeNbt() {
        ListNBT list = new ListNBT();
        for (Map.Entry<Key, StorageTrackerEntry> entry : this.changes.entrySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74772_a(NBT_TIME, entry.getValue().getTime());
            tag.func_74778_a(NBT_NAME, entry.getValue().getName());
            tag.func_218657_a(NBT_STACK, (INBT)StackUtils.serializeStackToNbt(entry.getKey().stack));
            list.add((Object)tag);
        }
        return list;
    }

    private class Key {
        private final ItemStack stack;

        public Key(ItemStack stack) {
            this.stack = stack;
        }

        public boolean equals(Object other) {
            return other instanceof Key && API.instance().getComparer().isEqualNoQuantity(this.stack, ((Key)other).stack);
        }

        public int hashCode() {
            return API.instance().getItemStackHashCode(this.stack);
        }
    }
}

