/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.cache;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.storage.cache.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.storage.cache.InvalidateCause;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemStorageCache
implements IStorageCache<ItemStack> {
    public static final Function<InvalidateCause, Consumer<INetwork>> INVALIDATE = cause -> network -> network.getItemStorageCache().invalidate((InvalidateCause)((Object)cause));
    private static final Logger LOGGER = LogManager.getLogger(ItemStorageCache.class);
    private final INetwork network;
    private final CopyOnWriteArrayList<IStorage<ItemStack>> storages = new CopyOnWriteArrayList();
    private final IStackList<ItemStack> list = API.instance().createItemStackList();
    private final IStackList<ItemStack> craftables = API.instance().createItemStackList();
    private final List<IStorageCacheListener<ItemStack>> listeners = new LinkedList<IStorageCacheListener<ItemStack>>();
    private final List<StackListResult<ItemStack>> batchedChanges = new ArrayList<StackListResult<ItemStack>>();

    public ItemStorageCache(INetwork network) {
        this.network = network;
    }

    @Override
    public void invalidate(InvalidateCause cause) {
        LOGGER.debug("Invalidating item storage cache of network at position {} due to {}", (Object)this.network.getPosition(), (Object)cause);
        this.storages.clear();
        this.network.getNodeGraph().all().stream().filter(node -> node.isActive() && node instanceof IStorageProvider).forEach(node -> ((IStorageProvider)((Object)node)).addItemStorages(this.storages));
        this.list.clear();
        this.sort();
        for (IStorage<ItemStack> storage : this.storages) {
            if (storage.getAccessType() == AccessType.INSERT) continue;
            for (ItemStack stack : storage.getStacks()) {
                if (stack.func_190926_b()) continue;
                this.add(stack, stack.func_190916_E(), true, false);
            }
        }
        this.listeners.forEach(IStorageCacheListener::onInvalidated);
    }

    @Override
    public void add(@Nonnull ItemStack stack, int size, boolean rebuilding, boolean batched) {
        StackListResult<ItemStack> result = this.list.add(stack, size);
        if (!rebuilding) {
            if (!batched) {
                this.listeners.forEach(l -> l.onChanged(result));
            } else {
                this.batchedChanges.add(result);
            }
        }
    }

    @Override
    public void remove(@Nonnull ItemStack stack, int size, boolean batched) {
        StackListResult<ItemStack> result = this.list.remove(stack, size);
        if (result != null) {
            if (!batched) {
                this.listeners.forEach(l -> l.onChanged(result));
            } else {
                this.batchedChanges.add(result);
            }
        }
    }

    @Override
    public void flush() {
        if (!this.batchedChanges.isEmpty()) {
            if (this.batchedChanges.size() > 1) {
                this.listeners.forEach(l -> l.onChangedBulk(this.batchedChanges));
            } else {
                this.batchedChanges.forEach(change -> this.listeners.forEach(l -> l.onChanged(change)));
            }
            this.batchedChanges.clear();
        }
    }

    @Override
    public void addListener(IStorageCacheListener<ItemStack> listener) {
        this.listeners.add(listener);
        listener.onAttached();
    }

    @Override
    public void removeListener(IStorageCacheListener<ItemStack> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void reAttachListeners() {
        this.listeners.forEach(IStorageCacheListener::onAttached);
    }

    @Override
    public void sort() {
        this.storages.sort(IStorage.COMPARATOR);
    }

    @Override
    public IStackList<ItemStack> getList() {
        return this.list;
    }

    @Override
    public IStackList<ItemStack> getCraftablesList() {
        return this.craftables;
    }

    @Override
    public List<IStorage<ItemStack>> getStorages() {
        return this.storages;
    }
}

