/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v6;

import com.google.common.collect.ImmutableList;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementList;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskErrorType;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTaskError;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.ErrorCraftingMonitorElement;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.FluidCraftingMonitorElement;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.ItemCraftingMonitorElement;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.FluidCraftingPreviewElement;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.ItemCraftingPreviewElement;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v6.Craft;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v6.Crafting;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v6.CraftingTaskError;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v6.Processing;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.v6.ProcessingState;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.FluidStorageDisk;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.ItemStorageDisk;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.factory.FluidStorageDiskFactory;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.factory.ItemStorageDiskFactory;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingTask
implements ICraftingTask {
    private static final String NBT_REQUESTED = "Requested";
    private static final String NBT_QUANTITY = "Quantity";
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_TICKS = "Ticks";
    private static final String NBT_ID = "Id";
    private static final String NBT_EXECUTION_STARTED = "ExecutionStarted";
    private static final String NBT_INTERNAL_STORAGE = "InternalStorage";
    private static final String NBT_INTERNAL_FLUID_STORAGE = "InternalFluidStorage";
    private static final String NBT_TO_EXTRACT_INITIAL = "ToExtractInitial";
    private static final String NBT_TO_EXTRACT_INITIAL_FLUIDS = "ToExtractInitialFluids";
    private static final String NBT_CRAFTS = "Crafts";
    private static final String NBT_MISSING = "Missing";
    private static final String NBT_MISSING_FLUIDS = "MissingFluids";
    private static final String NBT_TOTAL_STEPS = "TotalSteps";
    private static final String NBT_CURRENT_STEP = "CurrentStep";
    private static final String NBT_PATTERN_STACK = "Stack";
    private static final String NBT_PATTERN_CONTAINER_POS = "ContainerPos";
    private static final int DEFAULT_EXTRACT_FLAGS = 1;
    private static final Logger LOGGER = LogManager.getLogger(CraftingTask.class);
    private INetwork network;
    private ICraftingRequestInfo requested;
    private int quantity;
    private ICraftingPattern pattern;
    private UUID id = UUID.randomUUID();
    private int ticks;
    private long calculationStarted = -1L;
    private long executionStarted = -1L;
    private int totalSteps;
    private int currentstep;
    private Set<ICraftingPattern> patternsUsed = new HashSet<ICraftingPattern>();
    private IStorageDisk<ItemStack> internalStorage;
    private IStorageDisk<FluidStack> internalFluidStorage;
    private IStackList<ItemStack> toExtractInitial = API.instance().createItemStackList();
    private IStackList<FluidStack> toExtractInitialFluids = API.instance().createFluidStackList();
    private Map<ICraftingPattern, Craft> crafts = new LinkedHashMap<ICraftingPattern, Craft>();
    private List<Craft> toRemove = new ArrayList<Craft>();
    private IStackList<ItemStack> missing = API.instance().createItemStackList();
    private IStackList<FluidStack> missingFluids = API.instance().createFluidStackList();
    private IStackList<ItemStack> toTake = API.instance().createItemStackList();
    private IStackList<FluidStack> toTakeFluids = API.instance().createFluidStackList();
    private List<ItemStack> toCraft = new ArrayList<ItemStack>();
    private List<FluidStack> toCraftFluids = new ArrayList<FluidStack>();

    public CraftingTask(INetwork network, ICraftingRequestInfo requested, int quantity, ICraftingPattern pattern) {
        this.network = network;
        this.requested = requested;
        this.quantity = quantity;
        this.pattern = pattern;
        this.internalStorage = new ItemStorageDisk(null, -1);
        this.internalFluidStorage = new FluidStorageDisk(null, -1);
    }

    public CraftingTask(INetwork network, CompoundNBT tag) throws CraftingTaskReadException {
        this.network = network;
        this.requested = API.instance().createCraftingRequestInfo(tag.func_74775_l(NBT_REQUESTED));
        this.quantity = tag.func_74762_e(NBT_QUANTITY);
        this.pattern = CraftingTask.readPatternFromNbt(tag.func_74775_l(NBT_PATTERN), network.getWorld());
        this.ticks = tag.func_74762_e(NBT_TICKS);
        this.id = tag.func_186857_a(NBT_ID);
        this.executionStarted = tag.func_74763_f(NBT_EXECUTION_STARTED);
        this.totalSteps = tag.func_74762_e(NBT_TOTAL_STEPS);
        this.currentstep = tag.func_74762_e(NBT_CURRENT_STEP);
        ItemStorageDiskFactory factoryItem = new ItemStorageDiskFactory();
        FluidStorageDiskFactory factoryFluid = new FluidStorageDiskFactory();
        this.internalStorage = factoryItem.createFromNbt(null, tag.func_74775_l(NBT_INTERNAL_STORAGE));
        this.internalFluidStorage = factoryFluid.createFromNbt(null, tag.func_74775_l(NBT_INTERNAL_FLUID_STORAGE));
        this.toExtractInitial = CraftingTask.readItemStackList(tag.func_150295_c(NBT_TO_EXTRACT_INITIAL, 10));
        this.toExtractInitialFluids = CraftingTask.readFluidStackList(tag.func_150295_c(NBT_TO_EXTRACT_INITIAL_FLUIDS, 10));
        ListNBT craftList = tag.func_150295_c(NBT_CRAFTS, 10);
        for (int i = 0; i < craftList.size(); ++i) {
            Craft c = Craft.createCraftFromNBT(network, craftList.func_150305_b(i));
            this.crafts.put(c.getPattern(), c);
        }
        this.missing = CraftingTask.readItemStackList(tag.func_150295_c(NBT_MISSING, 10));
        this.missingFluids = CraftingTask.readFluidStackList(tag.func_150295_c(NBT_MISSING_FLUIDS, 10));
    }

    @Override
    public CompoundNBT writeToNbt(CompoundNBT tag) {
        tag.func_218657_a(NBT_REQUESTED, (INBT)this.requested.writeToNbt());
        tag.func_74768_a(NBT_QUANTITY, this.quantity);
        tag.func_218657_a(NBT_PATTERN, (INBT)CraftingTask.writePatternToNbt(this.pattern));
        tag.func_74768_a(NBT_TICKS, this.ticks);
        tag.func_186854_a(NBT_ID, this.id);
        tag.func_74772_a(NBT_EXECUTION_STARTED, this.executionStarted);
        tag.func_218657_a(NBT_INTERNAL_STORAGE, (INBT)this.internalStorage.writeToNbt());
        tag.func_218657_a(NBT_INTERNAL_FLUID_STORAGE, (INBT)this.internalFluidStorage.writeToNbt());
        tag.func_218657_a(NBT_TO_EXTRACT_INITIAL, (INBT)CraftingTask.writeItemStackList(this.toExtractInitial));
        tag.func_218657_a(NBT_TO_EXTRACT_INITIAL_FLUIDS, (INBT)CraftingTask.writeFluidStackList(this.toExtractInitialFluids));
        tag.func_74768_a(NBT_TOTAL_STEPS, this.totalSteps);
        tag.func_74768_a(NBT_CURRENT_STEP, this.currentstep);
        ListNBT craftingList = new ListNBT();
        for (Craft craft : this.crafts.values()) {
            craftingList.add((Object)craft.writeToNbt());
        }
        tag.func_218657_a(NBT_CRAFTS, (INBT)craftingList);
        tag.func_218657_a(NBT_MISSING, (INBT)CraftingTask.writeItemStackList(this.missing));
        tag.func_218657_a(NBT_MISSING_FLUIDS, (INBT)CraftingTask.writeFluidStackList(this.missingFluids));
        return tag;
    }

    static ListNBT writeItemStackList(IStackList<ItemStack> stacks) {
        ListNBT list = new ListNBT();
        for (StackListEntry<ItemStack> entry : stacks.getStacks()) {
            list.add((Object)StackUtils.serializeStackToNbt(entry.getStack()));
        }
        return list;
    }

    static IStackList<ItemStack> readItemStackList(ListNBT list) throws CraftingTaskReadException {
        IStackList<ItemStack> stacks = API.instance().createItemStackList();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = StackUtils.deserializeStackFromNbt(list.func_150305_b(i));
            if (stack.func_190926_b()) {
                throw new CraftingTaskReadException("Empty stack!");
            }
            stacks.add(stack);
        }
        return stacks;
    }

    static ListNBT writeFluidStackList(IStackList<FluidStack> stacks) {
        ListNBT list = new ListNBT();
        for (StackListEntry<FluidStack> entry : stacks.getStacks()) {
            list.add((Object)entry.getStack().writeToNBT(new CompoundNBT()));
        }
        return list;
    }

    static IStackList<FluidStack> readFluidStackList(ListNBT list) throws CraftingTaskReadException {
        IStackList<FluidStack> stacks = API.instance().createFluidStackList();
        for (int i = 0; i < list.size(); ++i) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)list.func_150305_b(i));
            if (stack.isEmpty()) {
                throw new CraftingTaskReadException("Empty stack!");
            }
            stacks.add(stack);
        }
        return stacks;
    }

    @Override
    @Nullable
    public ICraftingTaskError calculate() {
        if (this.calculationStarted != -1L) {
            throw new IllegalStateException("Task already calculated!");
        }
        if (this.executionStarted != -1L) {
            throw new IllegalStateException("Task already started!");
        }
        this.calculationStarted = System.currentTimeMillis();
        IStackList<ItemStack> results = API.instance().createItemStackList();
        IStackList<FluidStack> fluidResults = API.instance().createFluidStackList();
        IStackList<ItemStack> storage = this.network.getItemStorageCache().getList().copy();
        IStackList<FluidStack> fluidStorage = this.network.getFluidStorageCache().getList().copy();
        int qtyPerCraft = this.getQuantityPerCraft(this.requested.getItem(), this.requested.getFluid(), this.pattern);
        int qty = (this.quantity - 1) / qtyPerCraft + 1;
        ICraftingTaskError result = this.calculateInternal(qty, storage, fluidStorage, results, fluidResults, this.pattern, true);
        if (result != null) {
            return result;
        }
        if (this.requested.getItem() != null) {
            ItemStack req = this.requested.getItem().func_77946_l();
            req.func_190920_e(qty);
            this.toCraft.add(req);
        } else {
            FluidStack req = this.requested.getFluid().copy();
            req.setAmount(qty);
            this.toCraftFluids.add(req);
        }
        if (this.missing.isEmpty()) {
            this.crafts.values().forEach(c -> {
                this.totalSteps += c.getQuantity();
                if (c instanceof Processing) {
                    ((Processing)c).finishCalculation();
                }
            });
        }
        return null;
    }

    @Nullable
    private ICraftingTaskError calculateInternal(int qty, IStackList<ItemStack> mutatedStorage, IStackList<FluidStack> mutatedFluidStorage, IStackList<ItemStack> results, IStackList<FluidStack> fluidResults, ICraftingPattern pattern, boolean root) {
        if (System.currentTimeMillis() - this.calculationStarted > (long)RS.SERVER_CONFIG.getAutocrafting().getCalculationTimeoutMs()) {
            return new CraftingTaskError(CraftingTaskErrorType.TOO_COMPLEX);
        }
        if (!this.patternsUsed.add(pattern)) {
            return new CraftingTaskError(CraftingTaskErrorType.RECURSIVE, pattern);
        }
        IStackList<ItemStack> itemsToExtract = API.instance().createItemStackList();
        IStackList<FluidStack> fluidsToExtract = API.instance().createFluidStackList();
        NonNullList recipe = NonNullList.func_191196_a();
        ArrayList<Pair<NonNullList<ItemStack>, Integer>> ingredients = new ArrayList<Pair<NonNullList<ItemStack>, Integer>>();
        this.combineCommonStacks((NonNullList<ItemStack>)recipe, ingredients, pattern);
        Craft craft = this.crafts.get(pattern);
        if (craft == null) {
            craft = pattern.isProcessing() ? new Processing(pattern, root) : new Crafting(pattern, root, (NonNullList<ItemStack>)recipe);
            this.crafts.put(pattern, craft);
        }
        craft.addQuantity(qty);
        int ingredientNumber = -1;
        for (Pair pair : ingredients) {
            ++ingredientNumber;
            PossibleInputs possibleInputs = new PossibleInputs(new ArrayList<ItemStack>((Collection)pair.getLeft()));
            possibleInputs.sort(mutatedStorage, results);
            ItemStack possibleInput = possibleInputs.get();
            ItemStack fromSelf = results.get(possibleInput);
            ItemStack fromNetwork = mutatedStorage.get(possibleInput);
            int remaining = (Integer)pair.getRight() * qty;
            if (remaining < 0) {
                return new CraftingTaskError(CraftingTaskErrorType.TOO_COMPLEX);
            }
            while (remaining > 0) {
                int toTake;
                if (fromSelf != null) {
                    toTake = Math.min(remaining, fromSelf.func_190916_E());
                    craft.addItemsToUse(ingredientNumber, possibleInput, toTake, (Integer)pair.getRight());
                    results.remove(fromSelf, toTake);
                    remaining -= toTake;
                    fromSelf = results.get(possibleInput);
                }
                if (fromNetwork != null && remaining > 0) {
                    toTake = Math.min(remaining, fromNetwork.func_190916_E());
                    this.toTake.add(possibleInput, toTake);
                    craft.addItemsToUse(ingredientNumber, possibleInput, toTake, (Integer)pair.getRight());
                    mutatedStorage.remove(fromNetwork, toTake);
                    remaining -= toTake;
                    fromNetwork = mutatedStorage.get(possibleInput);
                    this.toExtractInitial.add(possibleInput, toTake);
                }
                if (remaining <= 0) continue;
                ICraftingPattern subPattern = this.network.getCraftingManager().getPattern(possibleInput);
                if (subPattern != null) {
                    int qtyPerCraft = this.getQuantityPerCraft(possibleInput, null, subPattern);
                    int subQty = (remaining - 1) / qtyPerCraft + 1;
                    ICraftingTaskError result = this.calculateInternal(subQty, mutatedStorage, mutatedFluidStorage, results, fluidResults, subPattern, false);
                    if (result != null) {
                        return result;
                    }
                    fromSelf = results.get(possibleInput);
                    if (fromSelf == null) {
                        throw new IllegalStateException("Recursive calculation didn't yield anything");
                    }
                    fromNetwork = mutatedStorage.get(possibleInput);
                    this.toCraft.add(fromSelf.func_77946_l());
                    continue;
                }
                if (!possibleInputs.cycle()) {
                    possibleInput = possibleInputs.get();
                    this.missing.add(possibleInput, remaining);
                    itemsToExtract.add(possibleInput, remaining);
                    remaining = 0;
                    continue;
                }
                possibleInput = possibleInputs.get();
                fromSelf = results.get(possibleInput);
                fromNetwork = mutatedStorage.get(possibleInput);
            }
        }
        if (craft instanceof Crafting) {
            ItemStack output = pattern.getOutput((NonNullList<ItemStack>)recipe);
            results.add(output, output.func_190916_E() * qty);
            for (ItemStack byproduct : pattern.getByproducts((NonNullList<ItemStack>)recipe)) {
                results.add(byproduct, byproduct.func_190916_E() * qty);
            }
        } else {
            Processing processing = (Processing)craft;
            ingredientNumber = -1;
            for (NonNullList<FluidStack> inputs : pattern.getFluidInputs()) {
                if (inputs.isEmpty()) continue;
                ++ingredientNumber;
                PossibleFluidInputs possibleInputs = new PossibleFluidInputs(new ArrayList<FluidStack>((Collection<FluidStack>)inputs));
                possibleInputs.sort(mutatedFluidStorage, fluidResults);
                FluidStack possibleInput = possibleInputs.get();
                FluidStack fromSelf = fluidResults.get(possibleInput, 1);
                FluidStack fromNetwork = mutatedFluidStorage.get(possibleInput, 1);
                int remaining = possibleInput.getAmount() * qty;
                if (remaining < 0) {
                    return new CraftingTaskError(CraftingTaskErrorType.TOO_COMPLEX);
                }
                processing.addFluidsToUse(possibleInput);
                while (remaining > 0) {
                    if (fromSelf != null) {
                        int toTake = Math.min(remaining, fromSelf.getAmount());
                        fluidResults.remove(possibleInput, toTake);
                        remaining -= toTake;
                        fromSelf = fluidResults.get(possibleInput, 1);
                    }
                    if (fromNetwork != null && remaining > 0) {
                        int toTake = Math.min(remaining, fromNetwork.getAmount());
                        this.toTakeFluids.add(possibleInput, toTake);
                        mutatedFluidStorage.remove(fromNetwork, toTake);
                        remaining -= toTake;
                        fromNetwork = mutatedFluidStorage.get(possibleInput, 1);
                        this.toExtractInitialFluids.add(possibleInput, toTake);
                    }
                    if (remaining <= 0) continue;
                    ICraftingPattern subPattern = this.network.getCraftingManager().getPattern(possibleInput);
                    if (subPattern != null) {
                        int qtyPerCraft = this.getQuantityPerCraft(null, possibleInput, subPattern);
                        int subQty = (remaining - 1) / qtyPerCraft + 1;
                        ICraftingTaskError result = this.calculateInternal(subQty, mutatedStorage, mutatedFluidStorage, results, fluidResults, subPattern, false);
                        if (result != null) {
                            return result;
                        }
                        fromSelf = fluidResults.get(possibleInput, 1);
                        if (fromSelf == null) {
                            throw new IllegalStateException("Recursive fluid calculation didn't yield anything");
                        }
                        fromNetwork = mutatedFluidStorage.get(possibleInput, 1);
                        this.toCraftFluids.add(fromSelf.copy());
                        continue;
                    }
                    this.missingFluids.add(possibleInput, remaining);
                    fluidsToExtract.add(possibleInput, remaining);
                    remaining = 0;
                }
            }
            pattern.getOutputs().forEach(x -> results.add((ItemStack)x, x.func_190916_E() * qty));
            pattern.getFluidOutputs().forEach(x -> fluidResults.add((FluidStack)x, x.getAmount() * qty));
            if (processing.getItemsToReceive().isEmpty()) {
                pattern.getOutputs().forEach(processing::addItemsToReceive);
            }
            if (processing.getFluidsToReceive().isEmpty()) {
                pattern.getFluidOutputs().forEach(processing::addFluidsToReceive);
            }
        }
        this.patternsUsed.remove(pattern);
        return null;
    }

    private void extractInitial() {
        ItemStack result;
        ArrayList<ItemStack> toRemove;
        if (!this.toExtractInitial.isEmpty()) {
            toRemove = new ArrayList<ItemStack>();
            for (StackListEntry<ItemStack> stackListEntry : this.toExtractInitial.getStacks()) {
                result = this.network.extractItem(stackListEntry.getStack(), stackListEntry.getStack().func_190916_E(), Action.PERFORM);
                if (result.func_190926_b()) continue;
                this.internalStorage.insert(stackListEntry.getStack(), result.func_190916_E(), Action.PERFORM);
                toRemove.add(result);
            }
            for (ItemStack itemStack : toRemove) {
                this.toExtractInitial.remove(itemStack);
            }
            if (!toRemove.isEmpty()) {
                this.network.getCraftingManager().onTaskChanged();
            }
        }
        if (!this.toExtractInitialFluids.isEmpty()) {
            toRemove = new ArrayList();
            for (StackListEntry<Object> stackListEntry : this.toExtractInitialFluids.getStacks()) {
                result = this.network.extractFluid((FluidStack)stackListEntry.getStack(), ((FluidStack)stackListEntry.getStack()).getAmount(), Action.PERFORM);
                if (result.isEmpty()) continue;
                this.internalFluidStorage.insert((FluidStack)stackListEntry.getStack(), result.getAmount(), Action.PERFORM);
                toRemove.add(result);
            }
            for (FluidStack fluidStack : toRemove) {
                this.toExtractInitialFluids.remove(fluidStack);
            }
            if (!toRemove.isEmpty()) {
                this.network.getCraftingManager().onTaskChanged();
            }
        }
    }

    private void combineCommonStacks(NonNullList<ItemStack> recipe, List<Pair<NonNullList<ItemStack>, Integer>> ingredients, ICraftingPattern pattern) {
        for (NonNullList<ItemStack> inputs : pattern.getInputs()) {
            if (inputs.isEmpty()) {
                recipe.add((Object)ItemStack.field_190927_a);
                continue;
            }
            recipe.add(inputs.get(0));
            boolean match = false;
            for (Pair<NonNullList<ItemStack>, Integer> pair : ingredients) {
                if (((NonNullList)pair.getLeft()).size() != inputs.size()) continue;
                match = true;
                for (int i = 0; i < inputs.size(); ++i) {
                    if (API.instance().getComparer().isEqualNoQuantity((ItemStack)((NonNullList)pair.getLeft()).get(i), (ItemStack)inputs.get(i))) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                pair.setValue((Object)((Integer)pair.getRight() + ((ItemStack)inputs.get(0)).func_190916_E()));
                break;
            }
            if (match) continue;
            ingredients.add((Pair<NonNullList<ItemStack>, Integer>)new MutablePair(inputs, (Object)((ItemStack)inputs.get(0)).func_190916_E()));
        }
    }

    private void updateCrafting(Crafting c) {
        block0: for (ICraftingPatternContainer container : this.network.getCraftingManager().getAllContainer(c.getPattern())) {
            int interval = container.getUpdateInterval();
            if (interval < 0) {
                throw new IllegalStateException(container + " has an update interval of < 0");
            }
            if (interval != 0 && this.ticks % interval != 0) continue;
            for (int i = 0; i < container.getMaximumSuccessfulCraftingUpdates(); ++i) {
                if (c.getQuantity() <= 0) {
                    this.toRemove.add(c);
                    return;
                }
                if (CraftingTask.extractFromInternalItemStorage(c.getItemsToUse(true).getStacks(), this.internalStorage, Action.SIMULATE) == null) continue block0;
                CraftingTask.extractFromInternalItemStorage(c.getItemsToUse(false).getStacks(), this.internalStorage, Action.PERFORM);
                ItemStack output = c.getPattern().getOutput(c.getRecipe());
                if (!c.isRoot()) {
                    this.internalStorage.insert(output, output.func_190916_E(), Action.PERFORM);
                } else {
                    ItemStack remainder = this.network.insertItem(output, output.func_190916_E(), Action.PERFORM);
                    this.internalStorage.insert(remainder, remainder.func_190916_E(), Action.PERFORM);
                }
                for (ItemStack byp : c.getPattern().getByproducts(c.getRecipe())) {
                    this.internalStorage.insert(byp, byp.func_190916_E(), Action.PERFORM);
                }
                c.next();
                ++this.currentstep;
                this.network.getCraftingManager().onTaskChanged();
            }
        }
    }

    private void updateProcessing(Processing p) {
        if (p.getState() == ProcessingState.PROCESSED) {
            this.toRemove.add(p);
            this.network.getCraftingManager().onTaskChanged();
            return;
        }
        boolean allLocked = true;
        boolean allNull = true;
        boolean allRejected = true;
        ProcessingState originalState = p.getState();
        block0: for (ICraftingPatternContainer container : this.network.getCraftingManager().getAllContainer(p.getPattern())) {
            int interval = container.getUpdateInterval();
            if (interval < 0) {
                throw new IllegalStateException(container + " has an update interval of < 0");
            }
            if (interval != 0 && this.ticks % interval != 0) continue;
            for (int i = 0; i < container.getMaximumSuccessfulCraftingUpdates(); ++i) {
                if (p.getQuantity() <= 0) {
                    return;
                }
                if (container.isLocked()) {
                    if (!allLocked) continue block0;
                    p.setState(ProcessingState.LOCKED);
                    continue block0;
                }
                allLocked = false;
                if (p.hasItems() && container.getConnectedInventory() == null || p.hasFluids() && container.getConnectedFluidInventory() == null) {
                    if (!allNull) continue block0;
                    p.setState(ProcessingState.MACHINE_NONE);
                    continue block0;
                }
                allNull = false;
                boolean hasAll = false;
                IStackList<FluidStack> extractedFluids = null;
                IStackList<ItemStack> extractedItems = CraftingTask.extractFromInternalItemStorage(p.getItemsToUse(true).getStacks(), this.internalStorage, Action.SIMULATE);
                if (extractedItems != null && (extractedFluids = CraftingTask.extractFromInternalFluidStorage(p.getFluidsToUse().getStacks(), this.internalFluidStorage, Action.SIMULATE)) != null) {
                    hasAll = true;
                }
                boolean canInsert = false;
                if (hasAll && (canInsert = CraftingTask.insertIntoInventory(container.getConnectedInventory(), extractedItems.getStacks(), Action.SIMULATE))) {
                    canInsert = CraftingTask.insertIntoTank(container.getConnectedFluidInventory(), extractedFluids.getStacks(), Action.SIMULATE);
                }
                if (hasAll && !canInsert) {
                    if (!allRejected) continue block0;
                    p.setState(ProcessingState.MACHINE_DOES_NOT_ACCEPT);
                    continue block0;
                }
                allRejected = false;
                if (!hasAll || !canInsert) continue;
                p.setState(ProcessingState.READY);
                CraftingTask.extractFromInternalItemStorage(p.getItemsToUse(false).getStacks(), this.internalStorage, Action.PERFORM);
                CraftingTask.extractFromInternalFluidStorage(p.getFluidsToUse().getStacks(), this.internalFluidStorage, Action.PERFORM);
                CraftingTask.insertIntoInventory(container.getConnectedInventory(), extractedItems.getStacks(), Action.PERFORM);
                CraftingTask.insertIntoTank(container.getConnectedFluidInventory(), extractedFluids.getStacks(), Action.PERFORM);
                p.next();
                ++this.currentstep;
                this.network.getCraftingManager().onTaskChanged();
                container.onUsedForProcessing();
            }
        }
        if (originalState != p.getState()) {
            this.network.getCraftingManager().onTaskChanged();
        }
    }

    private static IStackList<ItemStack> extractFromInternalItemStorage(Collection<StackListEntry<ItemStack>> stacks, IStorageDisk<ItemStack> storage, Action action) {
        IStackList<ItemStack> toReturn = API.instance().createItemStackList();
        for (StackListEntry<ItemStack> entry : stacks) {
            ItemStack result = storage.extract(entry.getStack(), entry.getStack().func_190916_E(), 1, action);
            if (result == ItemStack.field_190927_a || result.func_190916_E() != entry.getStack().func_190916_E()) {
                if (action == Action.PERFORM) {
                    throw new IllegalStateException("The internal crafting inventory reported that " + entry.getStack() + " was available but we got " + result);
                }
                return null;
            }
            toReturn.add(result);
        }
        return toReturn;
    }

    private static IStackList<FluidStack> extractFromInternalFluidStorage(Collection<StackListEntry<FluidStack>> stacks, IStorageDisk<FluidStack> storage, Action action) {
        IStackList<FluidStack> toReturn = API.instance().createFluidStackList();
        for (StackListEntry<FluidStack> entry : stacks) {
            FluidStack result = storage.extract(entry.getStack(), entry.getStack().getAmount(), 1, action);
            if (result == FluidStack.EMPTY || result.getAmount() != entry.getStack().getAmount()) {
                if (action == Action.PERFORM) {
                    throw new IllegalStateException("The internal crafting inventory reported that " + entry.getStack() + " was available but we got " + result);
                }
                return null;
            }
            toReturn.add(result);
        }
        return toReturn;
    }

    private static boolean insertIntoInventory(@Nullable IItemHandler dest, Collection<StackListEntry<ItemStack>> toInsert, Action action) {
        boolean success;
        if (dest == null) {
            return false;
        }
        if (toInsert.isEmpty()) {
            return true;
        }
        ArrayDeque<StackListEntry<ItemStack>> stacks = new ArrayDeque<StackListEntry<ItemStack>>(toInsert);
        StackListEntry currentEntry = (StackListEntry)stacks.poll();
        ItemStack current = currentEntry != null ? (ItemStack)currentEntry.getStack() : null;
        List availableSlots = IntStream.range(0, dest.getSlots()).boxed().collect(Collectors.toList());
        while (current != null && !availableSlots.isEmpty()) {
            ItemStack remainder = ItemStack.field_190927_a;
            for (int i = 0; i < availableSlots.size(); ++i) {
                int slot = (Integer)availableSlots.get(i);
                remainder = dest.insertItem(slot, current.func_77946_l(), action == Action.SIMULATE);
                if (!remainder.func_190926_b() && current.func_190916_E() == remainder.func_190916_E()) continue;
                availableSlots.remove(i);
                break;
            }
            if (remainder.func_190926_b()) {
                currentEntry = (StackListEntry)stacks.poll();
                current = currentEntry != null ? (ItemStack)currentEntry.getStack() : null;
                continue;
            }
            if (current.func_190916_E() == remainder.func_190916_E()) break;
            current = remainder;
        }
        boolean bl = success = current == null && stacks.isEmpty();
        if (!success && action == Action.PERFORM) {
            LOGGER.warn("Item Handler unexpectedly didn't accept " + (current != null ? current.func_77977_a() : null) + ", the remainder has been voided!");
        }
        return success;
    }

    private static boolean insertIntoTank(IFluidHandler dest, Collection<StackListEntry<FluidStack>> toInsert, Action action) {
        for (StackListEntry<FluidStack> entry : toInsert) {
            int filled = dest.fill(entry.getStack(), action == Action.SIMULATE ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
            if (filled == entry.getStack().getAmount()) continue;
            if (action == Action.PERFORM) {
                LOGGER.warn("Fluid Handler unexpectedly didn't accept all of " + entry.getStack().getTranslationKey() + ", the remainder has been voided!");
            }
            return false;
        }
        return true;
    }

    @Override
    public int getCompletionPercentage() {
        if (this.totalSteps == 0) {
            return 0;
        }
        return (int)((float)this.currentstep * 100.0f / (float)this.totalSteps);
    }

    @Override
    public boolean update() {
        if (this.hasMissing()) {
            LOGGER.warn("Crafting task with missing items or fluids cannot execute, cancelling...");
            return true;
        }
        if (this.executionStarted == -1L) {
            this.executionStarted = System.currentTimeMillis();
        }
        ++this.ticks;
        this.extractInitial();
        if (this.crafts.isEmpty()) {
            ItemStack remainder;
            ArrayList<Runnable> toPerform = new ArrayList<Runnable>();
            for (ItemStack stack : this.internalStorage.getStacks()) {
                remainder = this.network.insertItem(stack, stack.func_190916_E(), Action.PERFORM);
                toPerform.add(() -> this.internalStorage.extract(stack, stack.func_190916_E() - remainder.func_190916_E(), 1, Action.PERFORM));
            }
            for (ItemStack stack : this.internalFluidStorage.getStacks()) {
                remainder = this.network.insertFluid((FluidStack)stack, stack.getAmount(), Action.PERFORM);
                toPerform.add(() -> this.lambda$update$4((FluidStack)stack, (FluidStack)remainder));
            }
            toPerform.forEach(Runnable::run);
            return this.internalStorage.getStacks().isEmpty() && this.internalFluidStorage.getStacks().isEmpty();
        }
        for (Craft craft : this.crafts.values()) {
            if (craft instanceof Crafting) {
                this.updateCrafting((Crafting)craft);
                continue;
            }
            this.updateProcessing((Processing)craft);
        }
        for (Craft craft : this.toRemove) {
            this.crafts.remove(craft.getPattern());
        }
        this.toRemove.clear();
        return false;
    }

    @Override
    public void onCancelled() {
        for (ItemStack remainder : this.internalStorage.getStacks()) {
            this.network.insertItem(remainder, remainder.func_190916_E(), Action.PERFORM);
        }
        for (ItemStack remainder : this.internalFluidStorage.getStacks()) {
            this.network.insertFluid((FluidStack)remainder, remainder.getAmount(), Action.PERFORM);
        }
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    public int getQuantityPerCraft(ItemStack item, FluidStack fluid, ICraftingPattern pattern) {
        int qty = 0;
        if (item != null) {
            for (ItemStack output : pattern.getOutputs()) {
                if (!API.instance().getComparer().isEqualNoQuantity(output, item)) continue;
                qty += output.func_190916_E();
                if (pattern.isProcessing()) continue;
                break;
            }
        } else {
            for (FluidStack output : pattern.getFluidOutputs()) {
                if (!API.instance().getComparer().isEqual(output, fluid, 1)) continue;
                qty += output.getAmount();
            }
        }
        return qty;
    }

    @Override
    public ICraftingRequestInfo getRequested() {
        return this.requested;
    }

    @Override
    public int onTrackedInsert(ItemStack stack, int size) {
        for (Craft craft : this.crafts.values()) {
            Processing p;
            int needed;
            if (!(craft instanceof Processing) || (needed = (p = (Processing)craft).getNeeded(stack)) <= 0) continue;
            if (needed > size) {
                needed = size;
            }
            p.addFinished(stack, needed);
            size -= needed;
            if (!p.isRoot()) {
                this.internalStorage.insert(stack, needed, Action.PERFORM);
            } else {
                ItemStack remainder = this.network.insertItem(stack, needed, Action.PERFORM);
                this.internalStorage.insert(remainder, remainder.func_190916_E(), Action.PERFORM);
            }
            if (p.updateFinished()) {
                this.network.getCraftingManager().onTaskChanged();
            }
            if (size != 0) continue;
            return 0;
        }
        return size;
    }

    @Override
    public int onTrackedInsert(FluidStack stack, int size) {
        for (Craft craft : this.crafts.values()) {
            Processing p;
            int needed;
            if (!(craft instanceof Processing) || (needed = (p = (Processing)craft).getNeeded(stack)) <= 0) continue;
            if (needed > size) {
                needed = size;
            }
            p.addFinished(stack, needed);
            size -= needed;
            if (!p.isRoot()) {
                this.internalFluidStorage.insert(stack, needed, Action.PERFORM);
            } else {
                FluidStack remainder = this.network.insertFluid(stack, needed, Action.PERFORM);
                this.internalFluidStorage.insert(remainder, remainder.getAmount(), Action.PERFORM);
            }
            if (p.updateFinished()) {
                this.network.getCraftingManager().onTaskChanged();
            }
            if (size != 0) continue;
            return 0;
        }
        return size;
    }

    static CompoundNBT writePatternToNbt(ICraftingPattern pattern) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a(NBT_PATTERN_STACK, (INBT)pattern.getStack().serializeNBT());
        tag.func_74772_a(NBT_PATTERN_CONTAINER_POS, pattern.getContainer().getPosition().func_218275_a());
        return tag;
    }

    static ICraftingPattern readPatternFromNbt(CompoundNBT tag, World world) throws CraftingTaskReadException {
        BlockPos containerPos = BlockPos.func_218283_e((long)tag.func_74763_f(NBT_PATTERN_CONTAINER_POS));
        INetworkNode node = API.instance().getNetworkNodeManager((ServerWorld)world).getNode(containerPos);
        if (node instanceof ICraftingPatternContainer) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(NBT_PATTERN_STACK));
            if (stack.func_77973_b() instanceof ICraftingPatternProvider) {
                return ((ICraftingPatternProvider)stack.func_77973_b()).create(world, stack, (ICraftingPatternContainer)((Object)node));
            }
            throw new CraftingTaskReadException("Pattern stack is not a crafting pattern provider");
        }
        throw new CraftingTaskReadException("Crafting pattern container doesn't exist anymore");
    }

    @Override
    public List<ICraftingMonitorElement> getCraftingMonitorElements() {
        ICraftingMonitorElementList elements = API.instance().createCraftingMonitorElementList();
        for (Craft craft : this.crafts.values()) {
            if (craft instanceof Crafting) {
                if (craft.getQuantity() <= 0) continue;
                Crafting c = (Crafting)craft;
                for (Object receive : c.getPattern().getOutputs()) {
                    elements.add(new ItemCraftingMonitorElement((ItemStack)receive, 0, 0, 0, 0, receive.func_190916_E() * c.getQuantity()), false);
                }
                continue;
            }
            Processing p = (Processing)craft;
            if (p.getState() == ProcessingState.PROCESSED) continue;
            for (StackListEntry<ItemStack> put : p.getItemsToDisplay().getStacks()) {
                if (p.getProcessing() <= 0 && p.getState() == ProcessingState.READY) continue;
                ICraftingMonitorElement element = new ItemCraftingMonitorElement(put.getStack(), 0, 0, put.getStack().func_190916_E() * p.getProcessing(), 0, 0);
                if (p.getState() == ProcessingState.MACHINE_DOES_NOT_ACCEPT) {
                    element = new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.machine_does_not_accept_item");
                } else if (p.getState() == ProcessingState.MACHINE_NONE) {
                    element = new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.machine_none");
                } else if (p.getState() == ProcessingState.LOCKED) {
                    element = new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.crafter_is_locked");
                }
                elements.add(element, true);
            }
            for (Object receive : p.getItemsToReceive().getStacks()) {
                int count = p.getNeeded((ItemStack)((StackListEntry)receive).getStack());
                if (count <= 0) continue;
                elements.add(new ItemCraftingMonitorElement((ItemStack)((StackListEntry)receive).getStack(), 0, 0, 0, count, 0), true);
            }
            for (StackListEntry<ItemStack> put : p.getFluidsToUse().getStacks()) {
                if (p.getProcessing() <= 0 && p.getState() == ProcessingState.READY) continue;
                ICraftingMonitorElement element = new FluidCraftingMonitorElement((FluidStack)put.getStack(), 0, 0, ((FluidStack)put.getStack()).getAmount() * p.getProcessing(), 0, 0);
                if (p.getState() == ProcessingState.MACHINE_DOES_NOT_ACCEPT) {
                    element = new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.machine_does_not_accept_fluid");
                } else if (p.getState() == ProcessingState.MACHINE_NONE) {
                    element = new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.machine_none");
                } else if (p.getState() == ProcessingState.LOCKED) {
                    element = new ErrorCraftingMonitorElement(element, "gui.refinedstorage.crafting_monitor.crafter_is_locked");
                }
                elements.add(element, true);
            }
            for (Object receive : p.getFluidsToReceive().getStacks()) {
                int count = p.getNeeded((FluidStack)((StackListEntry)receive).getStack());
                if (count <= 0) continue;
                elements.add(new FluidCraftingMonitorElement((FluidStack)((StackListEntry)receive).getStack(), 0, 0, 0, count, 0), true);
            }
        }
        for (ItemStack stack : this.internalStorage.getStacks()) {
            elements.addStorage(new ItemCraftingMonitorElement(stack, stack.func_190916_E(), 0, 0, 0, 0));
        }
        for (ItemStack stack : this.internalFluidStorage.getStacks()) {
            elements.addStorage(new FluidCraftingMonitorElement((FluidStack)stack, stack.getAmount(), 0, 0, 0, 0));
        }
        elements.commit();
        return elements.getElements();
    }

    @Override
    public List<ICraftingPreviewElement> getPreviewStacks() {
        ICraftingPreviewElement<ItemStack> previewStack;
        int hash;
        LinkedHashMap<Integer, ICraftingPreviewElement<ItemStack>> map = new LinkedHashMap<Integer, ICraftingPreviewElement<ItemStack>>();
        LinkedHashMap<Integer, ICraftingPreviewElement<ItemStack>> mapFluids = new LinkedHashMap<Integer, ICraftingPreviewElement<ItemStack>>();
        for (StackListEntry<ItemStack> stackListEntry : this.missing.getStacks()) {
            hash = API.instance().getItemStackHashCode(stackListEntry.getStack());
            previewStack = (ItemCraftingPreviewElement)map.get(hash);
            if (previewStack == null) {
                previewStack = new ItemCraftingPreviewElement(stackListEntry.getStack());
            }
            ((ItemCraftingPreviewElement)previewStack).setMissing(true);
            ((ItemCraftingPreviewElement)previewStack).addToCraft(stackListEntry.getStack().func_190916_E());
            map.put(hash, previewStack);
        }
        for (StackListEntry<ItemStack> stackListEntry : this.missingFluids.getStacks()) {
            hash = API.instance().getFluidStackHashCode((FluidStack)stackListEntry.getStack());
            previewStack = (FluidCraftingPreviewElement)mapFluids.get(hash);
            if (previewStack == null) {
                previewStack = new FluidCraftingPreviewElement((FluidStack)stackListEntry.getStack());
            }
            ((FluidCraftingPreviewElement)previewStack).setMissing(true);
            ((FluidCraftingPreviewElement)previewStack).addToCraft(((FluidStack)stackListEntry.getStack()).getAmount());
            mapFluids.put(hash, previewStack);
        }
        for (ItemStack itemStack : ImmutableList.copyOf(this.toCraft).reverse()) {
            hash = API.instance().getItemStackHashCode(itemStack);
            previewStack = (ItemCraftingPreviewElement)map.get(hash);
            if (previewStack == null) {
                previewStack = new ItemCraftingPreviewElement(itemStack.getStack());
            }
            ((ItemCraftingPreviewElement)previewStack).addToCraft(itemStack.func_190916_E());
            map.put(hash, previewStack);
        }
        for (FluidStack fluidStack : ImmutableList.copyOf(this.toCraftFluids).reverse()) {
            hash = API.instance().getFluidStackHashCode(fluidStack);
            previewStack = (FluidCraftingPreviewElement)mapFluids.get(hash);
            if (previewStack == null) {
                previewStack = new FluidCraftingPreviewElement(fluidStack);
            }
            ((FluidCraftingPreviewElement)previewStack).addToCraft(fluidStack.getAmount());
            mapFluids.put(hash, previewStack);
        }
        for (StackListEntry stackListEntry : this.toTake.getStacks()) {
            hash = API.instance().getItemStackHashCode((ItemStack)stackListEntry.getStack());
            previewStack = (ItemCraftingPreviewElement)map.get(hash);
            if (previewStack == null) {
                previewStack = new ItemCraftingPreviewElement((ItemStack)stackListEntry.getStack());
            }
            ((ItemCraftingPreviewElement)previewStack).addAvailable(((ItemStack)stackListEntry.getStack()).func_190916_E());
            map.put(hash, previewStack);
        }
        for (StackListEntry stackListEntry : this.toTakeFluids.getStacks()) {
            hash = API.instance().getFluidStackHashCode((FluidStack)stackListEntry.getStack());
            previewStack = (FluidCraftingPreviewElement)mapFluids.get(hash);
            if (previewStack == null) {
                previewStack = new FluidCraftingPreviewElement((FluidStack)stackListEntry.getStack());
            }
            ((FluidCraftingPreviewElement)previewStack).addAvailable(((FluidStack)stackListEntry.getStack()).getAmount());
            mapFluids.put(hash, previewStack);
        }
        ArrayList<ICraftingPreviewElement> elements = new ArrayList<ICraftingPreviewElement>();
        elements.addAll(map.values());
        elements.addAll(mapFluids.values());
        return elements;
    }

    @Override
    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    @Override
    public long getExecutionStarted() {
        return this.executionStarted;
    }

    @Override
    public IStackList<ItemStack> getMissing() {
        return this.missing;
    }

    @Override
    public IStackList<FluidStack> getMissingFluids() {
        return this.missingFluids;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    private /* synthetic */ void lambda$update$4(FluidStack stack, FluidStack remainder) {
        this.internalFluidStorage.extract(stack, stack.getAmount() - remainder.getAmount(), 1, Action.PERFORM);
    }

    static class PossibleFluidInputs {
        private List<FluidStack> possibilities;
        private int pos;

        PossibleFluidInputs(List<FluidStack> possibilities) {
            this.possibilities = possibilities;
        }

        FluidStack get() {
            return this.possibilities.get(this.pos);
        }

        boolean cycle() {
            if (this.pos + 1 >= this.possibilities.size()) {
                this.pos = 0;
                return false;
            }
            ++this.pos;
            return true;
        }

        void sort(IStackList<FluidStack> mutatedStorage, IStackList<FluidStack> results) {
            this.possibilities.sort((a, b) -> {
                FluidStack ar = mutatedStorage.get((FluidStack)a);
                FluidStack br = mutatedStorage.get((FluidStack)b);
                return (br == null ? 0 : br.getAmount()) - (ar == null ? 0 : ar.getAmount());
            });
            this.possibilities.sort((a, b) -> {
                FluidStack ar = results.get((FluidStack)a);
                FluidStack br = results.get((FluidStack)b);
                return (br == null ? 0 : br.getAmount()) - (ar == null ? 0 : ar.getAmount());
            });
        }
    }

    static class PossibleInputs {
        private List<ItemStack> possibilities;
        private int pos;

        PossibleInputs(List<ItemStack> possibilities) {
            this.possibilities = possibilities;
        }

        ItemStack get() {
            return this.possibilities.get(this.pos);
        }

        boolean cycle() {
            if (this.pos + 1 >= this.possibilities.size()) {
                this.pos = 0;
                return false;
            }
            ++this.pos;
            return true;
        }

        void sort(IStackList<ItemStack> mutatedStorage, IStackList<ItemStack> results) {
            this.possibilities.sort((a, b) -> {
                ItemStack ar = mutatedStorage.get((ItemStack)a);
                ItemStack br = mutatedStorage.get((ItemStack)b);
                return (br == null ? 0 : br.func_190916_E()) - (ar == null ? 0 : ar.func_190916_E());
            });
            this.possibilities.sort((a, b) -> {
                ItemStack ar = results.get((ItemStack)a);
                ItemStack br = results.get((ItemStack)b);
                return (br == null ? 0 : br.func_190916_E()) - (ar == null ? 0 : ar.func_190916_E());
            });
        }
    }
}

