/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.IBlockChestMaterial;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.cyclopscore.block.multi.CubeDetector;

public class ChestWall
extends Block
implements CubeDetector.IDetectionListener,
IBlockChestMaterial {
    public static final BooleanProperty ENABLED = ColossalChest.ENABLED;
    private final ChestMaterial material;

    public ChestWall(Block.Properties properties, ChestMaterial material) {
        super(properties);
        this.material = material;
        material.setBlockWall(this);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public String func_149739_a() {
        String baseKey = super.func_149739_a();
        return baseKey.substring(0, baseKey.lastIndexOf(95));
    }

    @Override
    public ChestMaterial getMaterial() {
        return this.material;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ENABLED});
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return ColossalChest.isToolEffectiveShared(this.material, state, tool);
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)ENABLED) != false ? BlockRenderType.ENTITYBLOCK_ANIMATED : super.func_149645_b(blockState);
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader blockReader, BlockPos blockPos) {
        return (Boolean)blockState.func_177229_b((IProperty)ENABLED);
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public boolean shouldDisplayFluidOverlay(BlockState blockState, ILightReader world, BlockPos pos, IFluidState fluidState) {
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        ColossalChest.triggerDetector(this.material, (IWorld)world, pos, true, placer instanceof PlayerEntity ? (PlayerEntity)placer : null);
    }

    public void func_220082_b(BlockState blockStateNew, World world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.func_220082_b(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.captureBlockSnapshots && blockStateNew.func_177230_c() != blockStateOld.func_177230_c() && !((Boolean)blockStateNew.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (IWorld)world, blockPos, true, null);
        }
    }

    public void func_176206_d(IWorld world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)blockState.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, world, blockPos, false, null);
        }
        super.func_176206_d(world, blockPos, blockState);
    }

    public void func_180652_a(World world, BlockPos blockPos, Explosion explosion) {
        if (((Boolean)world.func_180495_p(blockPos).func_177229_b((IProperty)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (IWorld)world, blockPos, false, null);
        }
        super.func_180652_a(world, blockPos, explosion);
    }

    public void onDetect(IWorldReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.func_180495_p(location).func_177230_c();
        if (block == this) {
            boolean change = (Boolean)world.func_180495_p(location).func_177229_b((IProperty)ENABLED) == false;
            ((IWorldWriter)world).func_180501_a(location, (BlockState)world.func_180495_p(location).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(valid)), 2);
            if (change) {
                TileColossalChest.detectStructure(world, location, size, valid, originCorner);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (((Boolean)blockState.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            BlockPos tileLocation = ColossalChest.getCoreLocation(this.material, (IWorldReader)world, blockPos);
            if (tileLocation != null) {
                return world.func_180495_p(tileLocation).func_177230_c().func_225533_a_(blockState, world, tileLocation, player, hand, rayTraceResult);
            }
        } else {
            ColossalChest.addPlayerChatError(this.material, world, blockPos, player, hand);
            return ActionResultType.FAIL;
        }
        return super.func_225533_a_(blockState, world, blockPos, player, hand, rayTraceResult);
    }

    public boolean func_196260_a(BlockState blockState, IWorldReader world, BlockPos blockPos) {
        return super.func_196260_a(blockState, world, blockPos) && ColossalChest.canPlace(world, blockPos);
    }

    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (this.material.isExplosionResistant()) {
            return 10000.0f;
        }
        return 0.0f;
    }
}

