/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthetweaks;

import com.thevortex.repack.com.jagrosh.discordipc.IPCClient;
import com.thevortex.repack.com.jagrosh.discordipc.entities.DiscordBuild;
import com.thevortex.repack.com.jagrosh.discordipc.entities.RichPresence;
import com.thevortex.repack.com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import java.time.OffsetDateTime;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class DRP {
    private static final IPCClient CLIENT = new IPCClient(681288767461785641L);
    private static boolean isEnabled = false;
    private static final OffsetDateTime TIME = OffsetDateTime.now();
    public static State currentState = new State(EnumState.STARTUP);
    private static int errorCount = 0;
    private static final Timer TIMER = new Timer("Discord Rich Presence Timer Thread");
    private static TimerTask timerTask;

    public static void start() {
        try {
            CLIENT.connect(new DiscordBuild[0]);
            timerTask = new TimerTask(){

                @Override
                public void run() {
                    DRP.setState(currentState);
                }
            };
            TIMER.schedule(timerTask, 1000L, 120000L);
            isEnabled = true;
        }
        catch (NoDiscordClientException noDiscordClientException) {
            // empty catch block
        }
    }

    public static void stop() {
        if (timerTask != null) {
            timerTask.cancel();
            timerTask = null;
        }
        try {
            CLIENT.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        errorCount = 0;
        isEnabled = false;
    }

    public static void setIdling() {
        DRP.setState(new State(EnumState.MENU));
    }

    public static void setDimension(Dimension dimension) {
        DRP.setState(DRP.getStateFromDimension(dimension));
    }

    public static State getStateFromDimension(Dimension dimension) {
        switch (dimension.func_186058_p().func_186068_a()) {
            case -1: {
                return new State(EnumState.NETHER);
            }
            case 0: {
                return new State(EnumState.OVERWORLD);
            }
            case 1: {
                return new State(EnumState.END);
            }
        }
        return new State(EnumState.DIM, DimensionType.func_212678_a((DimensionType)dimension.func_186058_p()).func_110623_a());
    }

    public static void setState(State state) {
        block11: {
            currentState = state;
            RichPresence.Builder builder = new RichPresence.Builder();
            builder.setDetails(ModList.get().size() + " Mods");
            builder.setState(state.getState().getMessage(state.getReplace()));
            builder.setStartTimestamp(TIME);
            builder.setLargeImage("atm5", "All The Mods 5");
            if (state.getState() == EnumState.STARTUP) {
                builder.setLargeImage("mojang", "Loading");
                builder.setSmallImage("atm5", "All The Mods 5");
            }
            if (state.getState() == EnumState.MENU) {
                builder.setLargeImage("atm5", "All The Mods 5");
                builder.setSmallImage("mojang", "(c)");
            }
            if (state.getState() == EnumState.OVERWORLD) {
                builder.setLargeImage("atm5", "All The Mods 5");
                builder.setSmallImage("overworld", "In the Overworld");
            }
            if (state.getState() == EnumState.NETHER) {
                builder.setLargeImage("atm5", "All The Mods 5");
                builder.setSmallImage("nether", "In the Nether");
            }
            if (state.getState() == EnumState.END) {
                builder.setLargeImage("atm5", "All The Mods 5");
                builder.setSmallImage("end", "In the End");
            }
            try {
                CLIENT.sendRichPresence(builder.build());
            }
            catch (Exception ex) {
                try {
                    CLIENT.connect(new DiscordBuild[0]);
                    errorCount = 0;
                    CLIENT.sendRichPresence(builder.build());
                }
                catch (Exception ex2) {
                    try {
                        CLIENT.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (++errorCount <= 10) break block11;
                    DRP.stop();
                }
            }
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static State getCurrent() {
        return currentState;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> DRP.stop(), "Discord Rich Presence Stop Thread"));
    }

    public static enum EnumState {
        STARTUP("Starting Minecraft", "atm5", "All The Mods 5"),
        MENU("Main Menu", "atm5", "All The Mods 5"),
        OVERWORLD("Dimension: Overworld", "atm5", "All The Mods 5"),
        NETHER("Dimension: Nether", "atm5", "All The Mods 5"),
        END("Dimension: The End", "atm5", "All The Mods 5"),
        DIM("Dimension: %s", "atm5", "All The Mods 5");

        private final String message;
        private final String imagename;
        private final String imagekey;

        private EnumState(String message, String imagename, String imagekey) {
            this.message = message;
            this.imagename = imagename;
            this.imagekey = imagekey;
        }

        public String getMessage(String replace) {
            return this.message.replace("%s", replace);
        }

        public String getImageName(String replace) {
            return this.imagename.replace("%s", replace);
        }

        public String getImageKey() {
            return this.imagekey;
        }
    }

    public static class State {
        private final EnumState state;
        private final String replace;

        public State(EnumState state) {
            this(state, "");
        }

        public State(EnumState state, String replace) {
            this.state = state;
            this.replace = replace;
        }

        public EnumState getState() {
            return this.state;
        }

        public String getReplace() {
            return this.replace;
        }
    }
}

